/*
 * Decompiled with CFR 0.152.
 */
package com.rekindled.embers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import com.rekindled.embers.ConfigManager;
import com.rekindled.embers.RegistryManager;
import com.rekindled.embers.api.augment.AugmentUtil;
import com.rekindled.embers.api.augment.IAugment;
import com.rekindled.embers.api.block.IDial;
import com.rekindled.embers.api.capabilities.EmbersCapabilities;
import com.rekindled.embers.api.power.IEmberCapability;
import com.rekindled.embers.api.power.IEmberPacketReceiver;
import com.rekindled.embers.api.tile.IExtraCapabilityInformation;
import com.rekindled.embers.api.tile.IUpgradeable;
import com.rekindled.embers.api.upgrades.IUpgradeProxy;
import com.rekindled.embers.blockentity.EmberEmitterBlockEntity;
import com.rekindled.embers.blockentity.MechanicalCoreBlockEntity;
import com.rekindled.embers.blockentity.render.AtmosphericBellowsBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.AutomaticHammerBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.EmberBoreBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.EntropicEnumeratorBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.ExcavationBucketsBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.InfernoForgeTopBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.MechanicalPumpBlockEntityRenderer;
import com.rekindled.embers.blockentity.render.StamperBlockEntityRenderer;
import com.rekindled.embers.datagen.EmbersItemTags;
import com.rekindled.embers.render.EmbersRenderTypes;
import com.rekindled.embers.upgrade.ExcavationBucketsUpgrade;
import com.rekindled.embers.util.EmberGenUtil;
import com.rekindled.embers.util.GlowingTextTooltip;
import com.rekindled.embers.util.HeatBarTooltip;
import com.rekindled.embers.util.Misc;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class EmbersClientEvents {
    public static final IGuiOverlay INGAME_OVERLAY = EmbersClientEvents::renderIngameOverlay;
    public static int ticks = 0;
    public static double gaugeAngle = 0.0;
    public static long seed = 0L;
    public static BlockPos lastTarget = null;
    public static ResourceLocation GAUGE = new ResourceLocation("embers", "textures/gui/ember_meter_overlay.png");
    public static ResourceLocation GAUGE_POINTER = new ResourceLocation("embers", "textures/gui/ember_meter_pointer.png");

    public static void onLevelLoad(LevelEvent.Load event) {
        ticks = 0;
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc;
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.START && !(mc = Minecraft.m_91087_()).m_91104_()) {
            ++ticks;
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockState state;
                BlockHitResult result = (BlockHitResult)hitResult;
                ClientLevel world = mc.f_91073_;
                if (result != null && world != null && result.m_6662_() == HitResult.Type.BLOCK && (state = world.m_8055_(result.m_82425_())).m_60734_() instanceof IDial) {
                    ((IDial)state.m_60734_()).updateBEData(result.m_82425_(), Math.max(0, (mc.m_91268_().m_85444_() / 2 - 100) / 11));
                }
            }
        }
    }

    public static void onMovementInput(MovementInputUpdateEvent event) {
        if (event.getEntity().m_6117_() && !event.getEntity().m_20159_() && event.getEntity().m_21120_(event.getEntity().m_7655_()).m_204117_(EmbersItemTags.NORMAL_WALK_SPEED_TOOL)) {
            event.getInput().f_108567_ /= 0.2f;
            event.getInput().f_108566_ /= 0.2f;
            if (event.getEntity().m_20142_()) {
                event.getEntity().m_6858_(false);
            }
        }
    }

    public static void onBlockHighlight(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        Pair<BlockPos, Direction> target = Misc.getHammerTarget((Player)mc.f_91074_);
        if (target != null && event.getTarget().m_82425_().equals(target.getLeft())) {
            event.setCanceled(true);
        }
    }

    public static void onLevelRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91066_.f_92062_) {
                return;
            }
            LocalPlayer player = mc.f_91074_;
            Pair<BlockPos, Direction> target = Misc.getHammerTarget((Player)player);
            if (target != null && player.m_9236_().m_46749_((BlockPos)target.getLeft())) {
                BlockHitResult result;
                BlockPos targetPos = (BlockPos)target.getLeft();
                Direction targetDir = (Direction)target.getRight();
                Vec3 camPos = event.getCamera().m_90583_();
                VertexConsumer consumer = mc.m_91269_().m_110104_().m_6299_(EmbersRenderTypes.GLOW_LINES);
                float red = 1.0f;
                float green = 0.25f + 0.5f * ((float)Math.sin(Math.toRadians(4.0f * ((float)event.getRenderTick() + event.getPartialTick()))) + 1.0f) * 0.25f;
                float blue = 0.062745f;
                float alpha = 0.8f;
                double x = (double)targetPos.m_123341_() - camPos.f_82479_;
                double y = (double)targetPos.m_123342_() - camPos.f_82480_;
                double z = (double)targetPos.m_123343_() - camPos.f_82481_;
                PoseStack.Pose pose = event.getPoseStack().m_85850_();
                Shapes.DoubleLineConsumer lineDrawer = (fromX, fromY, fromZ, toX, toY, toZ) -> {
                    float f = (float)(toX - fromX);
                    float f1 = (float)(toY - fromY);
                    float f2 = (float)(toZ - fromZ);
                    float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
                    consumer.m_252986_(pose.m_252922_(), (float)(fromX + x), (float)(fromY + y), (float)(fromZ + z)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
                    consumer.m_252986_(pose.m_252922_(), (float)(toX + x), (float)(toY + y), (float)(toZ + z)).m_85950_(red, green, blue, alpha).m_252939_(pose.m_252943_(), f, f1, f2).m_5752_();
                };
                player.m_9236_().m_8055_(targetPos).m_60808_((BlockGetter)player.m_9236_(), targetPos).m_83224_(lineDrawer);
                HitResult hitResult = mc.f_91077_;
                if (hitResult instanceof BlockHitResult && (result = (BlockHitResult)hitResult) != null && result.m_6662_() == HitResult.Type.BLOCK && !result.m_82425_().equals((Object)targetPos) && mc.f_91073_.m_7702_(result.m_82425_()) instanceof IEmberPacketReceiver) {
                    lastTarget = result.m_82425_();
                }
                if (lastTarget != null) {
                    Vec3 hitPos = Vec3.m_82512_((Vec3i)lastTarget.m_121996_((Vec3i)targetPos));
                    Vec3 motion = EmberEmitterBlockEntity.getBurstVelocity(targetDir);
                    Vec3 oldPos = new Vec3(0.5, 0.5, 0.5);
                    Vec3 newPos = oldPos.m_82549_(motion);
                    for (int i = 0; i <= 80; ++i) {
                        Vec3 targetVector = hitPos.m_82546_(newPos);
                        double length = targetVector.m_82553_();
                        targetVector = targetVector.m_82490_(0.3 / length);
                        double weight = 0.0;
                        if (length <= 3.0) {
                            weight = 0.9 * ((3.0 - length) / 3.0);
                            if (length <= 0.2) break;
                        }
                        motion = new Vec3((0.9 - weight) * motion.f_82479_ + (0.1 + weight) * targetVector.f_82479_, (0.9 - weight) * motion.f_82480_ + (0.1 + weight) * targetVector.f_82480_, (0.9 - weight) * motion.f_82481_ + (0.1 + weight) * targetVector.f_82481_);
                        newPos = oldPos.m_82549_(motion);
                        lineDrawer.m_83161_(oldPos.f_82479_, oldPos.f_82480_, oldPos.f_82481_, newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                        oldPos = newPos;
                    }
                } else {
                    lineDrawer.m_83161_(0.5, 0.5, 0.5, 0.5 + (double)targetDir.m_122429_(), 0.5 + (double)targetDir.m_122430_(), 0.5 + (double)targetDir.m_122431_());
                }
            } else {
                lastTarget = null;
            }
        }
    }

    public static void renderIngameOverlay(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        Minecraft mc = gui.getMinecraft();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        LocalPlayer player = mc.f_91074_;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)hitResult;
            ClientLevel world = mc.f_91073_;
            if (result != null && result.m_6662_() == HitResult.Type.BLOCK) {
                BlockEntity tileEntity;
                BlockPos pos = result.m_82425_();
                BlockState state = world.m_8055_(pos);
                Direction facing = result.m_82434_();
                ArrayList<Component> text = new ArrayList<Component>();
                if (state.m_60734_() instanceof IDial) {
                    text.addAll(((IDial)state.m_60734_()).getDisplayInfo((Level)world, result.m_82425_(), state, Math.max(0, (height / 2 - 100) / 11)));
                } else if (state.m_60734_() == RegistryManager.ATMOSPHERIC_GAUGE.get() && !player.m_21205_().m_204117_(EmbersItemTags.GAUGE_OVERLAY) && !player.m_21206_().m_204117_(EmbersItemTags.GAUGE_OVERLAY)) {
                    EmbersClientEvents.renderAtmosphericGauge(gui, graphics, (Player)player, partialTicks, width, height);
                } else if (Misc.isWearingLens((Player)player) && (tileEntity = world.m_7702_(result.m_82425_())) != null) {
                    EmbersClientEvents.addCapabilityInformation(text, state, tileEntity, facing);
                }
                if (!text.isEmpty()) {
                    for (int i = 0; i < text.size(); ++i) {
                        graphics.m_280430_(mc.f_91062_, (Component)text.get(i), width / 2 - mc.f_91062_.m_92852_((FormattedText)text.get(i)) / 2, height / 2 + 40 + 11 * i, 0xFFFFFF);
                    }
                }
            }
        }
        if (player.m_21205_().m_41720_() == RegistryManager.ATMOSPHERIC_GAUGE_ITEM.get() || !player.m_21205_().m_204117_(EmbersItemTags.GAUGE_OVERLAY) && player.m_21206_().m_41720_() == RegistryManager.ATMOSPHERIC_GAUGE_ITEM.get()) {
            EmbersClientEvents.renderAtmosphericGauge(gui, graphics, (Player)player, partialTicks, width, height);
        }
    }

    public static void renderAtmosphericGauge(ForgeGui gui, GuiGraphics graphics, Player player, float partialTicks, int width, int height) {
        int x = width / 2;
        int y = height / 2;
        graphics.m_280168_().m_85836_();
        graphics.m_280398_(GAUGE, x - 16, y - 16, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        if (player != null) {
            double ratio = EmberGenUtil.getEmberDensity(seed, player.m_146903_(), player.m_146907_());
            gaugeAngle = gaugeAngle == 0.0 ? 165.0 + 210.0 * ratio : gaugeAngle * 0.99 + 0.01 * (165.0 + 210.0 * ratio);
        }
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)gaugeAngle));
        graphics.m_280168_().m_85837_(-2.5, -2.5, 0.0);
        graphics.m_280398_(GAUGE_POINTER, 0, 0, 0, 0.0f, 0.0f, 12, 5, 16, 16);
        graphics.m_280168_().m_85849_();
    }

    private static void addCapabilityInformation(List<Component> text, BlockState state, BlockEntity tile, Direction facing) {
        IUpgradeable upgradeable;
        boolean proxyable;
        EmbersClientEvents.addCapabilityItemDescription(text, tile, facing);
        EmbersClientEvents.addCapabilityFluidDescription(text, tile, facing);
        EmbersClientEvents.addCapabilityEmberDescription(text, tile, facing);
        if (tile.getCapability(EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY, facing).isPresent()) {
            text.add((Component)Component.m_237115_((String)"embers.tooltip.goggles.upgrade"));
        }
        if (!(proxyable = Misc.isSideProxyable(state, tile, facing)) && tile instanceof IUpgradeProxy) {
            IUpgradeProxy proxy = (IUpgradeProxy)tile;
            MechanicalCoreBlockEntity.BlockEntityDirection multiBlock = proxy.getAttachedMultiblock((Integer)ConfigManager.MAX_PROXY_DISTANCE.get() - 1);
            boolean bl = proxyable = multiBlock != null && Misc.isSideProxyable(multiBlock.blockEntity.m_58904_().m_8055_(multiBlock.blockEntity.m_58899_()), multiBlock.blockEntity, multiBlock.direction);
        }
        if (proxyable) {
            text.add((Component)Component.m_237115_((String)"embers.tooltip.goggles.accessor_slot"));
        }
        if (tile instanceof IUpgradeable && (upgradeable = (IUpgradeable)tile).isSideUpgradeSlot(facing)) {
            text.add((Component)Component.m_237115_((String)"embers.tooltip.goggles.upgrade_slot"));
        }
        if (tile instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)tile).addOtherDescription(text, facing);
        }
    }

    public static void addCapabilityItemDescription(List<Component> text, BlockEntity tile, Direction facing) {
        Capability capability = ForgeCapabilities.ITEM_HANDLER;
        if (tile.getCapability(capability, facing).isPresent()) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            Component filter = null;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.item", filter));
            }
        }
    }

    public static void addCapabilityFluidDescription(List<Component> text, BlockEntity tile, Direction facing) {
        Capability capability = ForgeCapabilities.FLUID_HANDLER;
        if (tile.getCapability(capability, facing).isPresent()) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            Component filter = null;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.fluid", filter));
            }
        }
    }

    public static void addCapabilityEmberDescription(List<Component> text, BlockEntity tile, Direction facing) {
        Capability<IEmberCapability> capability = EmbersCapabilities.EMBER_CAPABILITY;
        if (tile.getCapability(capability, facing).isPresent()) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.ember", null));
            }
        }
    }

    public static void afterModelBake(ModelEvent.BakingCompleted event) {
        ModelBakery bakery = event.getModelManager().getModelBakery();
        EmberBoreBlockEntityRenderer.blades = EmbersClientEvents.getModel(bakery, "ember_bore_blades");
        MechanicalPumpBlockEntityRenderer.pistonBottom = EmbersClientEvents.getModel(bakery, "mechanical_pump_piston_bottom");
        MechanicalPumpBlockEntityRenderer.pistonTop = EmbersClientEvents.getModel(bakery, "mechanical_pump_piston_top");
        StamperBlockEntityRenderer.arm = EmbersClientEvents.getModel(bakery, "stamper_arm");
        AutomaticHammerBlockEntityRenderer.hammer = EmbersClientEvents.getModel(bakery, "automatic_hammer_end");
        InfernoForgeTopBlockEntityRenderer.hatch = EmbersClientEvents.getModel(bakery, "inferno_forge_hatch");
        AtmosphericBellowsBlockEntityRenderer.top = EmbersClientEvents.getModel(bakery, "atmospheric_bellows_top");
        AtmosphericBellowsBlockEntityRenderer.leather = EmbersClientEvents.getModel(bakery, "atmospheric_bellows_leather");
        EntropicEnumeratorBlockEntityRenderer.cubies[0][0][0] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_drf");
        EntropicEnumeratorBlockEntityRenderer.cubies[1][0][0] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_dlf");
        EntropicEnumeratorBlockEntityRenderer.cubies[0][1][0] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_urf");
        EntropicEnumeratorBlockEntityRenderer.cubies[1][1][0] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_ulf");
        EntropicEnumeratorBlockEntityRenderer.cubies[0][0][1] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_drb");
        EntropicEnumeratorBlockEntityRenderer.cubies[1][0][1] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_dlb");
        EntropicEnumeratorBlockEntityRenderer.cubies[0][1][1] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_urb");
        EntropicEnumeratorBlockEntityRenderer.cubies[1][1][1] = EmbersClientEvents.getModel(bakery, "entropic_enumerator_ulb");
        ExcavationBucketsBlockEntityRenderer.wheel = EmbersClientEvents.getModel(bakery, "excavation_buckets_wheel");
        ExcavationBucketsUpgrade.buckets = EmbersClientEvents.getModel(bakery, "ember_bore_excavation_buckets");
    }

    public static BakedModel getModel(ModelBakery bakery, String name) {
        ResourceLocation location = new ResourceLocation("embers", "block/" + name);
        ModelBakery.ModelBakerImpl bakerImpl = new ModelBakery.ModelBakerImpl(bakery, (modelLoc, material) -> material.m_119204_(), location);
        UnbakedModel model = bakery.m_119341_(location);
        return model.m_7611_((ModelBaker)bakerImpl, Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, location);
    }

    public static void onTooltip(RenderTooltipEvent.GatherComponents event) {
        if (AugmentUtil.hasHeat(event.getItemStack())) {
            List augments;
            event.getTooltipElements().add(Either.left((Object)Component.m_237119_()));
            if (AugmentUtil.getLevel(event.getItemStack()) > 0) {
                event.getTooltipElements().add(Either.right((Object)new GlowingTextTooltip(Component.m_237115_((String)"embers.tooltip.heat_level").m_130940_(ChatFormatting.GRAY).m_7532_(), Component.m_237113_((String)("" + AugmentUtil.getLevel(event.getItemStack()))).m_7532_())));
                int slots = AugmentUtil.getLevel(event.getItemStack()) - AugmentUtil.getTotalAugmentLevel(event.getItemStack());
                if (slots > 0) {
                    event.getTooltipElements().add(Either.right((Object)new GlowingTextTooltip(Component.m_237115_((String)"embers.tooltip.augment_slots").m_130940_(ChatFormatting.GRAY).m_7532_(), Component.m_237113_((String)("" + slots)).m_7532_())));
                }
            }
            float heat = AugmentUtil.getHeat(event.getItemStack());
            float maxHeat = AugmentUtil.getMaxHeat(event.getItemStack());
            event.getTooltipElements().add(Either.right((Object)new HeatBarTooltip(Component.m_237115_((String)"embers.tooltip.heat_amount").m_130940_(ChatFormatting.GRAY).m_7532_(), heat, maxHeat)));
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                event.getTooltipElements().add(Either.left((Object)Component.m_237110_((String)"embers.tooltip.heat_debug", (Object[])new Object[]{Float.valueOf(heat), Float.valueOf(maxHeat)}).m_130940_(ChatFormatting.DARK_GRAY)));
            }
            if ((augments = AugmentUtil.getAugments(event.getItemStack()).stream().filter(x -> x.shouldRenderTooltip()).collect(Collectors.toList())).size() > 0) {
                event.getTooltipElements().add(Either.left((Object)Component.m_237115_((String)"embers.tooltip.augments").m_130940_(ChatFormatting.GRAY)));
                for (IAugment augment : augments) {
                    int level = AugmentUtil.getAugmentLevel(event.getItemStack(), augment);
                    event.getTooltipElements().add(Either.right((Object)new GlowingTextTooltip(Component.m_237110_((String)("embers.tooltip.augment." + augment.getName().m_214298_()), (Object[])new Object[]{Component.m_237115_((String)EmbersClientEvents.getFormattedModifierLevel(level))}).m_7532_())));
                }
            }
        }
    }

    public static String getFormattedModifierLevel(int level) {
        String key = "embers.tooltip.num" + level;
        if (I18n.m_118936_((String)key)) {
            return key;
        }
        return "embers.tooltip.numstop";
    }
}

