/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.floodlight;

import com.mangomilk.design_decor.registry.CDDSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FloodlightBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock,
IWrenchable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty TURNED_ON = BooleanProperty.m_61465_((String)"turned_on");
    public static final BooleanProperty WRENCHED = BooleanProperty.m_61465_((String)"wrenched");
    public static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape SHAPE_UP = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)8.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)8.0);

    public FloodlightBlock(BlockBehaviour.Properties p_52591_) {
        super(p_52591_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52588_, (Comparable)Direction.UP)).m_61124_((Property)TURNED_ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WRENCHED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState p_54561_, BlockGetter p_54562_, BlockPos p_54563_, CollisionContext p_54564_) {
        return switch ((Direction)p_54561_.m_61143_((Property)f_52588_)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE_NORTH;
        };
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean beenWrenched = (Boolean)pState.m_61143_((Property)WRENCHED);
        if (!beenWrenched && pLevel.m_276867_(pPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)TURNED_ON, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)TURNED_ON) == false)), 2);
        }
    }

    public void m_213897_(BlockState p_221937_, ServerLevel p_221938_, BlockPos p_221939_, RandomSource p_221940_) {
        if (((Boolean)p_221937_.m_61143_((Property)TURNED_ON)).booleanValue() && p_221938_.m_276867_(p_221939_) != ((Boolean)p_221937_.m_61143_((Property)WRENCHED)).booleanValue()) {
            p_221938_.m_7731_(p_221939_, (BlockState)p_221937_.m_61124_((Property)TURNED_ON, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (!onWrenched.m_19077_()) {
            return onWrenched;
        }
        boolean isOn = (Boolean)state.m_61143_((Property)TURNED_ON);
        context.m_43725_().m_7731_(context.m_8083_(), (BlockState)((BlockState)state.m_61124_((Property)TURNED_ON, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)TURNED_ON) == false))).m_61124_((Property)WRENCHED, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)WRENCHED) == false)), 2);
        this.playRotateSound(context.m_43725_(), context.m_8083_());
        if (!isOn) {
            context.m_43725_().m_7785_((double)context.m_8083_().m_123341_(), (double)context.m_8083_().m_123342_(), (double)context.m_8083_().m_123343_(), (SoundEvent)CDDSoundEvents.FLOODLIGHT_ON.get(), SoundSource.BLOCKS, 0.25f, Create.RANDOM.nextFloat() * 0.2f + 1.6f, false);
        }
        if (isOn) {
            context.m_43725_().m_7785_((double)context.m_8083_().m_123341_(), (double)context.m_8083_().m_123342_(), (double)context.m_8083_().m_123343_(), (SoundEvent)CDDSoundEvents.FLOODLIGHT_OFF.get(), SoundSource.BLOCKS, 0.25f, Create.RANDOM.nextFloat() * 0.2f + 0.8f, false);
        }
        return onWrenched;
    }

    public FluidState m_5888_(BlockState p_51475_) {
        return (Boolean)p_51475_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_51475_);
    }

    public boolean m_7357_(BlockState p_51456_, BlockGetter p_51457_, BlockPos p_51458_, PathComputationType p_51459_) {
        return false;
    }

    public BlockState m_7417_(BlockState p_51461_, Direction p_51462_, BlockState p_51463_, LevelAccessor p_51464_, BlockPos p_51465_, BlockPos p_51466_) {
        if (((Boolean)p_51461_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_51464_.m_186469_(p_51465_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_51464_));
        }
        return super.m_7417_(p_51461_, p_51462_, p_51463_, p_51464_, p_51465_, p_51466_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_55125_) {
        p_55125_.m_61104_(new Property[]{WATERLOGGED, f_52588_, TURNED_ON, WRENCHED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_58126_) {
        FluidState fluidstate = p_58126_.m_43725_().m_6425_(p_58126_.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockstate = this.m_49966_();
        Level levelreader = p_58126_.m_43725_();
        BlockPos blockpos = p_58126_.m_8083_();
        int n = 0;
        Direction[] adirection = p_58126_.m_6232_();
        Direction[] directionArray = adirection;
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            Direction direction1 = direction.m_122424_();
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)f_52588_, (Comparable)direction1)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            return blockstate;
        }
        return (BlockState)Objects.requireNonNull(super.m_5573_(p_58126_)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public void FloodlightSoundOff(Level p_49713_, BlockPos p_49714_, @Nullable Direction p_49715_) {
        this.FloodlightSoundOff(null, p_49713_, p_49714_, p_49715_);
    }

    public boolean FloodlightSoundOff(@Nullable Entity p_152189_, Level p_152190_, BlockPos p_152191_, @Nullable Direction p_152192_) {
        BlockEntity blockentity = p_152190_.m_7702_(p_152191_);
        if (!p_152190_.f_46443_) {
            p_152190_.m_5594_((Player)null, p_152191_, (SoundEvent)CDDSoundEvents.FLOODLIGHT_OFF.get(), SoundSource.BLOCKS, 0.25f, Create.RANDOM.nextFloat() * 0.2f + 0.8f);
            p_152190_.m_142346_(p_152189_, GameEvent.f_157792_, p_152191_);
            return true;
        }
        return false;
    }

    public void FloodlightSoundOn(Level p_49713_, BlockPos p_49714_, @Nullable Direction p_49715_) {
        this.FloodlightSoundOn(null, p_49713_, p_49714_, p_49715_);
    }

    public boolean FloodlightSoundOn(@Nullable Entity p_152189_, Level p_152190_, BlockPos p_152191_, @Nullable Direction p_152192_) {
        BlockEntity blockentity = p_152190_.m_7702_(p_152191_);
        if (!p_152190_.f_46443_) {
            p_152190_.m_5594_((Player)null, p_152191_, (SoundEvent)CDDSoundEvents.FLOODLIGHT_ON.get(), SoundSource.BLOCKS, 0.25f, Create.RANDOM.nextFloat() * 0.2f + 1.6f);
            p_152190_.m_142346_(p_152189_, GameEvent.f_157792_, p_152191_);
            return true;
        }
        return false;
    }
}

