/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear.other;

import com.aetherteam.aether.item.accessories.ring.RingItem;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import teamrazor.deepaether.client.keys.DeepAetherKeys;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.init.DASounds;
import teamrazor.deepaether.item.gear.EquipmentUtil;
import teamrazor.deepaether.networking.DeepAetherPlayer;
import top.theillusivec4.curios.api.SlotContext;

public class SliderEye
extends RingItem {
    public int maxFallTime = 0;
    int i = 0;

    public SliderEye(Supplier<? extends SoundEvent> ringSound, Item.Properties properties) {
        super(ringSound, properties);
    }

    private TargetingConditions targetingConditions(AABB aabb, Entity entity2) {
        return TargetingConditions.m_148352_().m_26888_(entity -> !entity.m_7306_(entity2) && entity.m_9236_().m_6857_().m_61935_(aabb));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Level level = slotContext.entity().m_9236_();
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (level.m_5776_()) {
                this.HandleClient(player, stack, level);
            } else {
                this.HandleServer(player, level);
            }
        }
    }

    private void HandleServer(Player player, Level level) {
        DeepAetherPlayer.get(player).ifPresent(aetherPlayer -> {
            if (aetherPlayer.isSliderSlamActivated()) {
                this.maxFallTime = 200;
                aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setSliderSlamActivated", false);
            }
        });
        if (this.maxFallTime > 0) {
            --this.maxFallTime;
            if (player.m_20096_()) {
                if (!(player instanceof ServerPlayer)) {
                    this.maxFallTime = 0;
                }
                AABB aabb = new AABB(player.m_20182_().m_82520_(-3.0, -1.0, -3.0), player.m_20182_().m_82520_(3.0, 4.0, 3.0));
                List entities = level.m_45971_(LivingEntity.class, this.targetingConditions(aabb, (Entity)player), (LivingEntity)player, aabb);
                float knockback = EquipmentUtil.getCurios((LivingEntity)player, (Item)DAItems.SLIDER_EYE.get()).size() == 2 ? 2.5f : 2.0f;
                for (LivingEntity target : entities) {
                    target.m_6469_(level.m_269111_().m_269075_(player), 1.4f);
                    Vec3 push = target.m_20182_().m_82505_(player.m_20182_()).m_82548_().m_82541_().m_82542_((double)knockback, (double)knockback, (double)knockback);
                    if (push.f_82480_ < 0.0) {
                        push.m_82542_(1.0, -1.0, 1.0);
                    }
                    push.m_82520_(0.0, 1.0, 0.0);
                    target.m_246865_(push);
                }
            }
        }
    }

    private void HandleClient(Player player, ItemStack stack, Level level) {
        ServerPlayer serverPlayer;
        if (this.mayUse(stack, player)) {
            if (!player.m_7500_()) {
                player.m_36335_().m_41524_(stack.m_41720_(), EquipmentUtil.getCurios((LivingEntity)player, (Item)DAItems.SLIDER_EYE.get()).size() == 2 ? 150 : 200);
            }
            player.m_20334_(0.0, 0.0, 0.0);
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
            DeepAetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.SERVER, "setSliderSlamActivated", true));
            level.m_247517_(player, player.m_20097_(), (SoundEvent)DASounds.ITEM_ACCESSORY_ABILITY_SLIDER_EYE.get(), SoundSource.PLAYERS);
            this.maxFallTime = 200;
        }
        if (this.maxFallTime > 0) {
            --this.maxFallTime;
            player.m_246865_(new Vec3(0.0, (double)-0.3f, 0.0));
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
            if (player.m_20096_()) {
                this.maxFallTime = 0;
                level.m_247517_(player, player.m_20097_(), SoundEvents.f_11913_, SoundSource.PLAYERS);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0, 0.0, 0.0);
            }
        }
    }

    public boolean mayUse(ItemStack stack, Player player) {
        return DeepAetherKeys.SLIDER_EYE_SLAM_ABILITY.m_90857_() && !player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_20096_();
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 200;
    }

    public List<Component> getAttributesTooltip(List<Component> tagTooltips, ItemStack stack) {
        if (this.i > 70) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_1"));
        } else if (this.i > 60) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_2"));
        } else if (this.i > 50) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_3"));
        } else if (this.i > 40) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_4"));
        } else if (this.i > 30) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_5"));
        } else if (this.i > 20) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_6"));
        } else if (this.i > 10) {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_7"));
        } else {
            tagTooltips.add((Component)Component.m_237115_((String)"gui.deep_aether.flawless_tier_8"));
        }
        this.i = this.i < 80 ? ++this.i : 0;
        return super.getAttributesTooltip(tagTooltips, stack);
    }
}

