/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.item.gear;

import com.aetherteam.aether.item.accessories.ring.RingItem;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import teamrazor.deepaether.init.DAItems;
import teamrazor.deepaether.item.gear.skyjade.SkyjadeAccessory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class EquipmentUtil {
    public static boolean hasFullStratusSet(LivingEntity entity) {
        return EquipmentUtil.hasArmorSet(entity, (Item)DAItems.STRATUS_HELMET.get(), (Item)DAItems.STRATUS_CHESTPLATE.get(), (Item)DAItems.STRATUS_LEGGINGS.get(), (Item)DAItems.STRATUS_BOOTS.get(), (Item)DAItems.STRATUS_GLOVES.get());
    }

    private static boolean hasArmorSet(LivingEntity entity, Item helmet, Item chestplate, Item leggings, Item boots, Item gloves) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_150930_(helmet) && entity.m_6844_(EquipmentSlot.CHEST).m_150930_(chestplate) && entity.m_6844_(EquipmentSlot.LEGS).m_150930_(leggings) && entity.m_6844_(EquipmentSlot.FEET).m_150930_(boots) && CuriosApi.getCuriosHelper().findFirstCurio(entity, gloves).isPresent();
    }

    public static boolean hasTwoSpookyRings(SlotContext context) {
        return CuriosApi.getCuriosHelper().findCurios(context.entity(), (Item)DAItems.SPOOKY_RING.get()).size() == 2;
    }

    public static void damageRing(LivingEntity entity, RingItem ring) {
        List<SlotResult> slotResults = EquipmentUtil.getCurios(entity, (Item)ring);
        for (SlotResult slotResult : slotResults) {
            if (slotResult == null || entity.m_217043_().m_188503_(3) != 0) continue;
            slotResult.stack().m_41622_(1, entity, wearer -> CuriosApi.getCuriosHelper().onBrokenCurio(slotResult.slotContext()));
        }
    }

    public static double handleStratusRingBoost(LivingEntity entity) {
        EquipmentUtil.damageRing(entity, (RingItem)DAItems.GRAVITITE_RING.get());
        EquipmentUtil.damageRing(entity, (RingItem)DAItems.STRATUS_RING.get());
        double multiplier = 1.0;
        if (CuriosApi.getCuriosHelper().findFirstCurio(entity, (Item)DAItems.STRATUS_RING.get()).isPresent()) {
            multiplier += 1.2 * (double)EquipmentUtil.getCurios(entity, (Item)DAItems.STRATUS_RING.get()).toArray().length;
        }
        if (CuriosApi.getCuriosHelper().findFirstCurio(entity, (Item)DAItems.GRAVITITE_RING.get()).isPresent()) {
            multiplier += 1.1 * (double)EquipmentUtil.getCurios(entity, (Item)DAItems.GRAVITITE_RING.get()).toArray().length;
        }
        return multiplier;
    }

    public static float handleSkyjadeRingAbility(LivingEntity entity, float speed) {
        float newSpeed = speed;
        List<SlotResult> slotResults = EquipmentUtil.getCurios(entity, (Item)DAItems.SKYJADE_RING.get());
        for (SlotResult slotResult : slotResults) {
            if (slotResult == null) continue;
            newSpeed = SkyjadeAccessory.handleMiningSpeed(newSpeed, slotResult.stack());
        }
        return newSpeed;
    }

    public static List<SlotResult> getCurios(LivingEntity entity, Item item) {
        return CuriosApi.getCuriosHelper().findCurios(entity, item);
    }
}

