/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.init;

import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import teamrazor.deepaether.client.model.AerglowFishModel;
import teamrazor.deepaether.client.renderer.AetherFishRenderer;
import teamrazor.deepaether.client.renderer.DABoatRenderer;
import teamrazor.deepaether.client.renderer.DAModelLayers;
import teamrazor.deepaether.client.renderer.FireProjectileRenderer;
import teamrazor.deepaether.client.renderer.QuailRenderer;
import teamrazor.deepaether.client.renderer.VenomiteRenderer;
import teamrazor.deepaether.entity.DABoatEntity;
import teamrazor.deepaether.init.DABlockEntityTypes;
import teamrazor.deepaether.init.DAEntities;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DAEntityRenderers {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)DAEntities.AETHER_FISH.get(), AetherFishRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.QUAIL.get(), QuailRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.VENOMITE.get(), VenomiteRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DABlockEntityTypes.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DABlockEntityTypes.HANGING_SIGN.get(), HangingSignRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.BOAT.get(), context -> new DABoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)DAEntities.CHEST_BOAT.get(), context -> new DABoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)DAEntities.QUAIL_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)DAEntities.FIRE_PROJECTILE.get(), FireProjectileRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(DAModelLayers.AERGLOW_FISH, AerglowFishModel::createBodyLayer);
        for (DABoatEntity.Type type : DABoatEntity.Type.values()) {
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("deep_aether", type.getModelLocation()), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("deep_aether", type.getChestModelLocation()), "main"), ChestBoatModel::m_247175_);
        }
    }
}

