/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import teamrazor.deepaether.entity.AerglowFish;
import teamrazor.deepaether.entity.DABoatEntity;
import teamrazor.deepaether.entity.DAChestBoatEntity;
import teamrazor.deepaether.entity.FireProjectile;
import teamrazor.deepaether.entity.Venomite;
import teamrazor.deepaether.entity.quail.Quail;
import teamrazor.deepaether.entity.quail.ThrownQuailEgg;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DAEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"deep_aether");
    public static final RegistryObject<EntityType<DABoatEntity>> BOAT = ENTITY_TYPES.register("boat", () -> EntityType.Builder.m_20704_(DABoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("boat"));
    public static final RegistryObject<EntityType<DAChestBoatEntity>> CHEST_BOAT = ENTITY_TYPES.register("chest_boat", () -> EntityType.Builder.m_20704_(DAChestBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("chest_boat"));
    public static final RegistryObject<EntityType<ThrownQuailEgg>> QUAIL_EGG = ENTITY_TYPES.register("quail_egg", () -> EntityType.Builder.m_20704_(ThrownQuailEgg::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("quail_egg"));
    public static final RegistryObject<EntityType<AerglowFish>> AETHER_FISH = DAEntities.register("aerglow_fish", EntityType.Builder.m_20704_(AerglowFish::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).m_20702_(10).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<Quail>> QUAIL = DAEntities.register("quail", EntityType.Builder.m_20704_(Quail::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Quail::new).m_20699_(0.35f, 0.7f));
    public static final RegistryObject<EntityType<Venomite>> VENOMITE = DAEntities.register("venomite", EntityType.Builder.m_20704_(Venomite::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Venomite::new).m_20699_(0.7f, 0.6f));
    public static final RegistryObject<EntityType<FireProjectile>> FIRE_PROJECTILE = ENTITY_TYPES.register("fire_projectile", () -> EntityType.Builder.m_20704_(FireProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.35f, 0.35f).m_20702_(4).m_20717_(10).m_20712_("fire_projectile"));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return ENTITY_TYPES.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AerglowFish.m_27495_();
            Quail.init();
            Venomite.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)AETHER_FISH.get(), AerglowFish.m_27495_().m_22265_());
        event.put((EntityType)QUAIL.get(), Quail.createAttributes().m_22265_());
        event.put((EntityType)VENOMITE.get(), Venomite.createAttributes().m_22265_());
    }
}

