/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.deepaether.datagen.loot.modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DAAddDungeonLootModifier
extends LootModifier {
    public static final Supplier<Codec<DAAddDungeonLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DAAddDungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)WeightedEntry.Wrapper.m_146305_((Codec)ItemStack.f_41582_).listOf().fieldOf("items").forGetter(m -> m.items)).and((App)Codec.INT.fieldOf("totalWeight").forGetter(m -> m.totalWeight)).and((App)Codec.FLOAT.fieldOf("chanceToSpawn").forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, DAAddDungeonLootModifier::new)));
    public final List<WeightedEntry.Wrapper<ItemStack>> items;
    public final int totalWeight;
    public final float chance;

    public DAAddDungeonLootModifier(LootItemCondition[] conditionsIn, List<WeightedEntry.Wrapper<ItemStack>> items, int totalWeight, float chance) {
        super(conditionsIn);
        this.items = items.stream().map(wrapper -> WeightedEntry.m_146290_((Object)((ItemStack)wrapper.m_146310_()).m_41777_(), (int)wrapper.m_142631_().m_146281_())).toList();
        this.totalWeight = totalWeight;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ObjectArrayList list = new ObjectArrayList();
        int size = generatedLoot.size();
        boolean isFull = size == 27;
        int sizeDiff = 27 - size;
        for (ItemStack stack : generatedLoot) {
            if (isFull) {
                if (!(context.m_230907_().m_188501_() > this.chance)) continue;
                WeightedRandom.m_216825_((RandomSource)context.m_230907_(), this.items, (int)this.totalWeight).ifPresent(e -> list.add((Object)((ItemStack)e.m_146310_())));
                continue;
            }
            list.add((Object)stack);
        }
        if (!isFull) {
            for (int i = 0; i <= sizeDiff; ++i) {
                if (!(context.m_230907_().m_188501_() > this.chance)) continue;
                WeightedRandom.m_216825_((RandomSource)context.m_230907_(), this.items, (int)this.totalWeight).ifPresent(e -> list.add((Object)((ItemStack)e.m_146310_())));
            }
        }
        return list;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

