/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.client.PlatformClient;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DrillRenderer<T extends BlockEntity>
extends SafeBlockEntityRenderer<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("createoreexcavation", "drill"), "main");
    private static final ResourceLocation SHAFT = new ResourceLocation("createoreexcavation", "textures/entity/shaft.png");
    private final ModelPart head;
    private final ModelPart shaft;
    private final ModelPart rubble;

    public DrillRenderer(BlockEntityRendererProvider.Context dispatcher) {
        ModelPart root = dispatcher.m_173582_(LAYER_LOCATION);
        this.head = root.m_171324_("head");
        this.shaft = root.m_171324_("shaft");
        this.rubble = root.m_171324_("rubble");
    }

    public static LayerDefinition createModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        head.m_171599_("Bit4_r1", CubeListBuilder.m_171558_().m_171514_(20, 26).m_171488_(-1.0f, 6.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(12, 16).m_171488_(-1.5f, 4.5f, -1.5f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(12, 10).m_171488_(-2.0f, 2.5f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 24).m_171488_(-2.5f, 0.5f, -2.5f, 5.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-5.0f, -2.5f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(3.0f, -2.5f, -2.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-2.0f, -2.5f, -5.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 10).m_171488_(-2.0f, -2.5f, 3.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -2.5f, -3.0f, 6.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        partdefinition.m_171599_("shaft", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -12.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rubble = partdefinition.m_171599_("rubble", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)24.0f, (float)0.0f));
        rubble.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.2f, -2.8f, -1.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)0.0f, (float)-0.2486f, (float)-0.1618f, (float)0.1217f));
        rubble.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-8.0f, -3.0f, -1.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)0.0f, (float)-0.0598f, (float)0.0156f, (float)-0.1786f));
        rubble.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-9.0f, -3.0f, -7.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)0.0f, (float)0.3412f, (float)0.1265f, (float)-0.0937f));
        rubble.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -3.0f, -7.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)13.0f, (float)0.0f, (float)0.3414f, (float)-0.0741f, (float)0.2054f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderSafe(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        ItemStack drill;
        pPoseStack.m_85836_();
        float f = ((IDrill)pBlockEntity).getFacing().m_122435_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
        pPoseStack.m_252880_(0.0f, ((IDrill)pBlockEntity).getYOffset(), 0.0f);
        pPoseStack.m_85841_(1.0f, -1.0f, -1.0f);
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.0f, ((IDrill)pBlockEntity).getDrillOffset(), 0.0f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)pPartialTick, (float)((IDrill)pBlockEntity).getPrevRotation(), (float)((IDrill)pBlockEntity).getRotation())));
        if (((IDrill)pBlockEntity).shouldRenderShaft()) {
            this.shaft.m_104301_(pPoseStack, pBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)SHAFT)), pPackedLight, pPackedOverlay);
        }
        if (!(drill = ((IDrill)pBlockEntity).getDrill()).m_41619_()) {
            ResourceLocation rl = RegisteredObjects.getKeyOrThrow((Item)drill.m_41720_());
            ResourceLocation tex = new ResourceLocation(rl.m_135827_(), "textures/entity/drill/" + rl.m_135815_() + ".png");
            this.head.m_104301_(pPoseStack, pBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)tex)), pPackedLight, pPackedOverlay);
        }
        pPoseStack.m_85849_();
        BlockPos below = ((IDrill)pBlockEntity).getBelow();
        BlockState state = pBlockEntity.m_58904_().m_8055_(below);
        if (((IDrill)pBlockEntity).shouldRenderRubble() && !state.m_60795_() && !(pBlockEntity.m_58904_() instanceof PonderWorld)) {
            try {
                TextureAtlasSprite particle = PlatformClient.getBlockTexture(state, pBlockEntity.m_58904_(), below);
                this.rubble.m_104301_(pPoseStack, particle.m_118381_(pBufferSource.m_6299_(RenderType.m_110463_())), pPackedLight, pPackedOverlay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        pPoseStack.m_85849_();
    }
}

