/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.fuzes;

import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import rbasamoyai.createbigcannons.base.CBCTooltip;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.fuzes.FuzeItem;

public class ImpactFuzeItem
extends FuzeItem {
    public ImpactFuzeItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean onProjectileImpact(ItemStack stack, AbstractCannonProjectile projectile, HitResult hitResult, AbstractCannonProjectile.ImpactResult impactResult, boolean baseFuze) {
        int damage;
        if (baseFuze) {
            return false;
        }
        CompoundTag tag = stack.m_41784_();
        int n = damage = tag.m_128441_("Damage") ? tag.m_128451_("Damage") : this.getFuzeDurability();
        if (damage > 0) {
            tag.m_128405_("Damage", --damage);
        }
        if (damage == 0) {
            return false;
        }
        float f = this.getDetonateChance();
        return f > 0.0f && projectile.m_9236_().m_213780_().m_188501_() < f;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CBCTooltip.appendImpactFuzeText(stack, level, tooltip, flag, this.getDetonateChance(), this.getFuzeDurability());
    }

    protected float getDetonateChance() {
        return CBCConfigs.SERVER.munitions.impactFuzeDetonationChance.getF();
    }

    protected int getFuzeDurability() {
        return (Integer)CBCConfigs.SERVER.munitions.impactFuzeDurability.get();
    }

    @Override
    public void addExtraInfo(List<Component> tooltip, boolean isSneaking, ItemStack stack) {
        super.addExtraInfo(tooltip, isSneaking, stack);
        MutableComponent info = Lang.builder((String)"item").translate("createbigcannons.impact_fuze.tooltip.shell_info.chance", new Object[]{(int)(this.getDetonateChance() * 100.0f)}).component();
        tooltip.addAll(TooltipHelper.cutTextComponent((Component)info, (Style)Style.f_131099_, (Style)Style.f_131099_, (int)6));
    }
}

