/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.createbigcannons.CBCClientCommon;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellExplosionCloudParticleData;
import rbasamoyai.createbigcannons.effects.particles.smoke.ShellExplosionSmokeParticleData;

public class ShellExplosionCloudParticle
extends NoRenderParticle {
    private final float power;
    private final List<TrailSubparticle> trails = new LinkedList<TrailSubparticle>();
    private final boolean isPlume;

    ShellExplosionCloudParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, float power, boolean isPlume) {
        super(level, x, y, z);
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.power = power;
        this.isPlume = isPlume;
        if (((Boolean)CBCConfigs.CLIENT.showExtraShellExplosionTrails.get()).booleanValue()) {
            double secondaryVelScale = (double)this.power * 0.35;
            int secondaryCount = switch (CBCClientCommon.getParticleStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case ParticleStatus.ALL -> 12 + this.f_107223_.m_188503_(6);
                case ParticleStatus.DECREASED -> 6 + this.f_107223_.m_188503_(3);
                case ParticleStatus.MINIMAL -> 4;
            };
            double gravity = this.isPlume ? -0.5 : -0.1;
            for (int i = 0; i < secondaryCount; ++i) {
                double rx = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double ry = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double rz = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double dx1 = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                double dy1 = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                if (this.isPlume) {
                    dy1 += 2.0;
                }
                double dz1 = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                int lifetime = 5;
                this.trails.add(new TrailSubparticle(new Vec3(rx, ry, rz).m_82490_(2.5), new Vec3(dx1, dy1, dz1).m_82490_(secondaryVelScale), 0.85, gravity, lifetime));
            }
        }
    }

    public void m_5989_() {
        int PLUME_AGE = 5;
        if (this.f_107224_ < PLUME_AGE) {
            float primaryScale = this.power * 2.0f;
            int plumes = switch (CBCClientCommon.getParticleStatus()) {
                default -> throw new IncompatibleClassChangeError();
                case ParticleStatus.ALL -> 20;
                case ParticleStatus.DECREASED -> 10;
                case ParticleStatus.MINIMAL -> 5;
            };
            double velScale = (double)this.power * 0.25;
            velScale *= (double)(1.0f - (float)this.f_107224_ / (float)PLUME_AGE);
            double displacementScale = (double)this.power * 0.35;
            for (int i = 0; i <= plumes; ++i) {
                double rx = this.f_107212_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * displacementScale;
                double ry = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                if (this.isPlume) {
                    ry = Math.abs(ry);
                }
                ry *= displacementScale;
                ry += this.f_107213_ + 0.5;
                double rz = this.f_107214_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * displacementScale;
                double dx = (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * velScale;
                double dy = this.f_107223_.m_188500_() - this.f_107223_.m_188500_();
                if (this.isPlume) {
                    dy += 1.2;
                }
                double dz = (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * velScale;
                int lifetime = 160 + this.f_107223_.m_188503_(80);
                this.f_107208_.m_6493_((ParticleOptions)new ShellExplosionSmokeParticleData(lifetime, primaryScale), true, rx, ry, rz, dx, dy *= velScale, dz);
            }
        }
        int trailSteps = CBCClientCommon.getParticleStatus() == ParticleStatus.ALL ? 2 : 1;
        float secondaryScale = this.power * 0.75f;
        Iterator<TrailSubparticle> iter = this.trails.iterator();
        while (iter.hasNext()) {
            TrailSubparticle trail = iter.next();
            if (this.f_107224_ > trail.lifetime) {
                iter.remove();
                continue;
            }
            Vec3 origin = trail.calculateDisplacement(this.f_107224_);
            Vec3 next = trail.calculateDisplacement(this.f_107224_ + 1);
            double velScale = 0.125;
            double displacementScale = 0.1;
            for (int i = 0; i <= trailSteps; ++i) {
                Vec3 pos = origin.m_165921_(next, (double)i / (double)trailSteps).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                double rx = pos.f_82479_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * displacementScale;
                double ry = pos.f_82480_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * displacementScale;
                double rz = pos.f_82481_ + (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * displacementScale;
                double dx = (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * velScale;
                double dy = (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * velScale;
                double dz = (this.f_107223_.m_188500_() - this.f_107223_.m_188500_()) * velScale;
                int lifetime = 30 + this.f_107223_.m_188503_(15);
                this.f_107208_.m_6493_((ParticleOptions)new ShellExplosionSmokeParticleData(lifetime, secondaryScale), true, rx, ry, rz, dx, dy, dz);
            }
        }
        super.m_5989_();
    }

    private record TrailSubparticle(Vec3 displacement, Vec3 vel, double drag, double gravity, int lifetime) {
        public Vec3 calculateDisplacement(int ticks) {
            if (ticks <= 0) {
                return this.displacement;
            }
            if (this.drag == 1.0) {
                return this.displacement.m_82549_(this.vel.m_82490_((double)ticks));
            }
            double geo = (1.0 - Math.pow(this.drag, ticks)) / (1.0 - this.drag);
            return this.displacement.m_82549_(this.vel.m_82490_(geo)).m_82520_(0.0, this.gravity * (double)ticks, 0.0);
        }
    }

    public static class Provider
    implements ParticleProvider<ShellExplosionCloudParticleData> {
        @Nullable
        public Particle createParticle(ShellExplosionCloudParticleData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (!((Boolean)CBCConfigs.CLIENT.showShellExplosionClouds.get()).booleanValue()) {
                return null;
            }
            ShellExplosionCloudParticle particle = new ShellExplosionCloudParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type.scale(), type.isPlume());
            particle.m_107257_(10);
            return particle;
        }
    }
}

