/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackPropagator;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CurvedTrackDestroyPacket
extends BlockEntityConfigurationPacket<TrackBlockEntity> {
    private BlockPos targetPos;
    private BlockPos soundSource;
    private boolean wrench;

    public CurvedTrackDestroyPacket(BlockPos pos, BlockPos targetPos, BlockPos soundSource, boolean wrench) {
        super(pos);
        this.targetPos = targetPos;
        this.soundSource = soundSource;
        this.wrench = wrench;
    }

    public CurvedTrackDestroyPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.targetPos);
        buffer.m_130064_(this.soundSource);
        buffer.writeBoolean(this.wrench);
    }

    @Override
    protected void readSettings(FriendlyByteBuf buffer) {
        this.targetPos = buffer.m_130135_();
        this.soundSource = buffer.m_130135_();
        this.wrench = buffer.readBoolean();
    }

    @Override
    protected void applySettings(ServerPlayer player, TrackBlockEntity be) {
        int verifyDistance = (Integer)AllConfigs.server().trains.maxTrackPlacementLength.get() * 4;
        if (!be.m_58899_().m_123314_((Vec3i)player.m_20183_(), (double)verifyDistance)) {
            Create.LOGGER.warn(player.m_6302_() + " too far away from destroyed Curve track");
            return;
        }
        Level level = be.m_58904_();
        BezierConnection bezierConnection = be.getConnections().get(this.targetPos);
        be.removeConnection(this.targetPos);
        BlockEntity blockEntity = level.m_7702_(this.targetPos);
        if (blockEntity instanceof TrackBlockEntity) {
            TrackBlockEntity other = (TrackBlockEntity)blockEntity;
            other.removeConnection(this.pos);
        }
        BlockState blockState = be.m_58900_();
        TrackPropagator.onRailRemoved((LevelAccessor)level, this.pos, blockState);
        if (this.wrench) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(player.m_9236_(), (Vec3i)this.soundSource, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
            if (!player.m_7500_() && bezierConnection != null) {
                bezierConnection.addItemsToPlayer((Player)player);
            }
        } else if (!player.m_7500_() && bezierConnection != null) {
            bezierConnection.spawnItems(level);
        }
        bezierConnection.spawnDestroyParticles(level);
        SoundType soundtype = blockState.getSoundType((LevelReader)level, this.pos, (Entity)player);
        if (soundtype == null) {
            return;
        }
        level.m_5594_(null, this.soundSource, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
    }

    @Override
    protected int maxRange() {
        return 64;
    }

    @Override
    protected void applySettings(TrackBlockEntity be) {
    }
}

