/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.heater;

import com.lgmrszd.compressedcreativity.blocks.heater.HeaterBlockEntity;
import com.lgmrszd.compressedcreativity.index.CCBlockEntities;
import com.lgmrszd.compressedcreativity.index.CCBlocks;
import com.lgmrszd.compressedcreativity.index.CCShapes;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HeaterBlock
extends Block
implements IBE<HeaterBlockEntity> {
    public HeaterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.NONE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlazeBurnerBlock.HEAT_LEVEL});
        super.m_7926_(builder);
    }

    public Class<HeaterBlockEntity> getBlockEntityClass() {
        return HeaterBlockEntity.class;
    }

    public BlockEntityType<? extends HeaterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntities.HEATER.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CCShapes.HEATER_SHAPE;
    }

    public static void registerHeater() {
        BoilerHeaters.registerHeater((Block)((Block)CCBlocks.HEATER.get()), (level, pos, state) -> {
            BlazeBurnerBlock.HeatLevel value = state.m_61145_((Property)BlazeBurnerBlock.HEAT_LEVEL).orElse(BlazeBurnerBlock.HeatLevel.NONE);
            if (value == BlazeBurnerBlock.HeatLevel.NONE) {
                return -1.0f;
            }
            if (value == BlazeBurnerBlock.HeatLevel.SEETHING) {
                return 2.0f;
            }
            if (value.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity te;
        super.onNeighborChange(state, world, pos, neighbor);
        BlockEntity blockEntity = te = state.m_155947_() ? world.m_7702_(pos) : null;
        if (te instanceof HeaterBlockEntity) {
            HeaterBlockEntity hte = (HeaterBlockEntity)te;
            hte.updateHeatExchanger();
        }
    }

    public void m_5871_(ItemStack stack, BlockGetter world, List<Component> curInfo, TooltipFlag flag) {
        curInfo.add((Component)Component.m_237113_((String)"[Work in progress!!!]"));
        super.m_5871_(stack, world, curInfo, flag);
    }
}

