/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.core.PocketBrain;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PocketComputerItem
extends Item
implements IComputerItem,
IMedia,
IColouredItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_ON = "On";
    private static final String NBT_INSTANCE = "InstanceId";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public PocketComputerItem(Item.Properties settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public ItemStack create(int id, @Nullable String label, int colour, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        ItemStack result = new ItemStack((ItemLike)this);
        if (id >= 0) {
            result.m_41784_().m_128405_("ComputerId", id);
        }
        if (label != null) {
            result.m_41714_((Component)Component.m_237113_((String)label));
        }
        if (upgrade != null) {
            result.m_41784_().m_128359_(NBT_UPGRADE, upgrade.upgrade().getUpgradeID().toString());
            if (!upgrade.data().m_128456_()) {
                result.m_41784_().m_128365_(NBT_UPGRADE_INFO, (Tag)upgrade.data().m_6426_());
            }
        }
        if (colour != -1) {
            result.m_41784_().m_128405_("Color", colour);
        }
        return result;
    }

    private void tick(ItemStack stack, PocketHolder holder, PocketBrain brain) {
        brain.updateHolder(holder);
        UpgradeData<IPocketUpgrade> upgrade = brain.getUpgrade();
        if (upgrade != null) {
            upgrade.upgrade().update(brain, brain.computer().getPeripheral(ComputerSide.BACK));
        }
        if (this.updateItem(stack, brain)) {
            holder.setChanged();
        }
    }

    private boolean updateItem(ItemStack stack, PocketBrain brain) {
        boolean on;
        String label;
        boolean changed = brain.updateItem(stack);
        PocketServerComputer computer = brain.computer();
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            PocketComputerItem.setComputerID(stack, id);
        }
        if (!Objects.equals(label = computer.getLabel(), this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != PocketComputerItem.isMarkedOn(stack)) {
            changed = true;
            stack.m_41784_().m_128379_(NBT_ON, on);
        }
        return changed;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int compartmentSlot, boolean selected) {
        if (world.f_46443_ || !(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        int slot = InventoryUtil.getInventorySlotFromCompartment((Player)player, compartmentSlot, stack);
        if (slot < 0) {
            return;
        }
        PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder(player, slot);
        PocketBrain brain = this.getOrCreateBrain((ServerLevel)world, holder, stack);
        brain.computer().keepAlive();
        this.tick(stack, holder, brain);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        Level level = entity.m_9236_();
        if (level.f_46443_ || level.m_7654_() == null) {
            return false;
        }
        PocketServerComputer computer = PocketComputerItem.getServerComputer(level.m_7654_(), stack);
        if (computer != null) {
            this.tick(stack, new PocketHolder.ItemEntityHolder(entity), computer.getBrain());
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            PocketHolder.PlayerHolder holder = new PocketHolder.PlayerHolder((ServerPlayer)player, InventoryUtil.getHandSlot(player, hand));
            PocketBrain brain = this.getOrCreateBrain((ServerLevel)world, holder, stack);
            PocketServerComputer computer = brain.computer();
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
            if (upgrade != null) {
                brain.updateHolder(holder);
                stop = upgrade.onRightClick(world, brain, computer.getPeripheral(ComputerSide.BACK));
                this.updateItem(stack, brain);
            }
            if (!stop) {
                boolean isTypingOnly = hand == InteractionHand.OFF_HAND;
                new ComputerContainerData(computer, stack).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new InteractionResultHolder(InteractionResult.m_19078_((boolean)world.f_46443_), (Object)stack);
    }

    public Component m_7626_(ItemStack stack) {
        String baseString = this.m_5671_(stack);
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null) {
            return Component.m_237110_((String)(baseString + ".upgraded"), (Object[])new Object[]{Component.m_237115_((String)upgrade.getUnlocalisedAdjective())});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int id;
        if ((flag.m_7050_() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((Component)Component.m_237110_((String)"gui.computercraft.tooltip.computer_id", (Object[])new Object[]{id}).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        IPocketUpgrade upgrade = PocketComputerItem.getUpgrade(stack);
        if (upgrade != null && (mod = PocketUpgrades.instance().getOwner(upgrade)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    private PocketBrain getOrCreateBrain(ServerLevel level, PocketHolder holder, ItemStack stack) {
        ServerComputerRegistry registry = ServerContext.get(level.m_7654_()).registry();
        PocketServerComputer computer = PocketComputerItem.getServerComputer(registry, stack);
        if (computer != null) {
            return computer.getBrain();
        }
        int computerID = this.getComputerID(stack);
        if (computerID < 0) {
            computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(level.m_7654_(), "computer");
            PocketComputerItem.setComputerID(stack, computerID);
        }
        PocketBrain brain = new PocketBrain(holder, this.getComputerID(stack), this.getLabel(stack), this.getFamily(), PocketComputerItem.getUpgradeWithData(stack));
        PocketServerComputer computer2 = brain.computer();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(NBT_SESSION, registry.getSessionID());
        tag.m_128362_(NBT_INSTANCE, computer2.register());
        if (PocketComputerItem.isMarkedOn(stack) && holder instanceof PocketHolder.PlayerHolder) {
            computer2.turnOn();
        }
        this.updateItem(stack, brain);
        holder.setChanged();
        return brain;
    }

    public static boolean isServerComputer(ServerComputer computer, ItemStack stack) {
        return stack.m_41720_() instanceof PocketComputerItem && PocketComputerItem.getServerComputer(computer.getLevel().m_7654_(), stack) == computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(ServerComputerRegistry registry, ItemStack stack) {
        return (PocketServerComputer)registry.get(PocketComputerItem.getSessionID(stack), PocketComputerItem.getInstanceID(stack));
    }

    @Nullable
    public static PocketServerComputer getServerComputer(MinecraftServer server, ItemStack stack) {
        return PocketComputerItem.getServerComputer(ServerContext.get(server).registry(), stack);
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
        PocketServerComputer computer;
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        MinecraftServer server = level.m_7654_();
        if (server != null && (computer = PocketComputerItem.getServerComputer(server, stack)) != null) {
            computer.getBrain().setUpgrade(PocketComputerItem.getUpgradeWithData(stack));
        }
    }

    private static void setComputerID(ItemStack stack, int computerID) {
        stack.m_41784_().m_128405_("ComputerId", computerID);
    }

    @Override
    @Nullable
    public String getLabel(ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public ItemStack changeItem(ItemStack stack, Item newItem) {
        ItemStack itemStack;
        if (newItem instanceof PocketComputerItem) {
            PocketComputerItem pocket = (PocketComputerItem)newItem;
            itemStack = pocket.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), PocketComputerItem.getUpgradeWithData(stack));
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    @Override
    public boolean setLabel(ItemStack stack, @Nullable String label) {
        if (label != null) {
            stack.m_41714_((Component)Component.m_237113_((String)label));
        } else {
            stack.m_41787_();
        }
        return true;
    }

    @Override
    @Nullable
    public Mount createDataMount(ItemStack stack, ServerLevel level) {
        int id = this.getComputerID(stack);
        if (id >= 0) {
            return ComputerCraftAPI.createSaveDirMount(level.m_7654_(), "computer/" + id, Config.computerSpaceLimit);
        }
        return null;
    }

    @Nullable
    public static UUID getInstanceID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128403_(NBT_INSTANCE) ? nbt.m_128342_(NBT_INSTANCE) : null;
    }

    private static int getSessionID(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_(NBT_SESSION) ? nbt.m_128451_(NBT_SESSION) : -1;
    }

    private static boolean isMarkedOn(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_(NBT_ON);
    }

    @Nullable
    public static IPocketUpgrade getUpgrade(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_(NBT_UPGRADE)) {
            return null;
        }
        return PocketUpgrades.instance().get(compound.m_128461_(NBT_UPGRADE));
    }

    @Nullable
    public static UpgradeData<IPocketUpgrade> getUpgradeWithData(ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (compound == null || !compound.m_128441_(NBT_UPGRADE)) {
            return null;
        }
        IPocketUpgrade upgrade = PocketUpgrades.instance().get(compound.m_128461_(NBT_UPGRADE));
        return upgrade == null ? null : UpgradeData.of(upgrade, NBTUtil.getCompoundOrEmpty(compound, NBT_UPGRADE_INFO));
    }

    public static void setUpgrade(ItemStack stack, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        CompoundTag compound = stack.m_41784_();
        if (upgrade == null) {
            compound.m_128473_(NBT_UPGRADE);
            compound.m_128473_(NBT_UPGRADE_INFO);
        } else {
            compound.m_128359_(NBT_UPGRADE, upgrade.upgrade().getUpgradeID().toString());
            compound.m_128365_(NBT_UPGRADE_INFO, (Tag)upgrade.data().m_6426_());
        }
    }

    public static CompoundTag getUpgradeInfo(ItemStack stack) {
        return stack.m_41698_(NBT_UPGRADE_INFO);
    }
}

