/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.component.ComputerComponents;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.metrics.MetricsObserver;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.RepeatArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.common.ClearColourRecipe;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.computer.apis.CommandAPI;
import dan200.computercraft.shared.computer.blocks.CommandComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.items.CommandComputerItem;
import dan200.computercraft.shared.computer.items.ComputerItem;
import dan200.computercraft.shared.computer.recipe.ComputerUpgradeRecipe;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.data.BlockNamedEntityLootCondition;
import dan200.computercraft.shared.data.ConstantLootConditionSerializer;
import dan200.computercraft.shared.data.HasComputerIdLootCondition;
import dan200.computercraft.shared.data.PlayerCreativeLootCondition;
import dan200.computercraft.shared.details.BlockDetails;
import dan200.computercraft.shared.details.ItemDetails;
import dan200.computercraft.shared.integration.PermissionRegistry;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.lectern.CustomLecternBlockEntity;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.DiskItem;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.media.items.TreasureDiskItem;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlockEntity;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveMenu;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockItem;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.redstone.RedstoneRelayBlock;
import dan200.computercraft.shared.peripheral.redstone.RedstoneRelayBlockEntity;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlock;
import dan200.computercraft.shared.peripheral.speaker.SpeakerBlockEntity;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistrationHelper;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.pocket.peripherals.PocketModem;
import dan200.computercraft.shared.pocket.peripherals.PocketSpeaker;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.recipe.CustomShapedRecipe;
import dan200.computercraft.shared.recipe.CustomShapelessRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapedRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapelessRecipe;
import dan200.computercraft.shared.turtle.FurnaceRefuelHandler;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleAccessInternal;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.turtle.recipes.TurtleOverlayRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleRecipe;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.turtle.upgrades.TurtleCraftingTable;
import dan200.computercraft.shared.turtle.upgrades.TurtleModem;
import dan200.computercraft.shared.turtle.upgrades.TurtleSpeaker;
import dan200.computercraft.shared.turtle.upgrades.TurtleTool;
import dan200.computercraft.shared.turtle.upgrades.TurtleToolSerialiser;
import dan200.computercraft.shared.util.ComponentMap;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class ModRegistry {
    private ModRegistry() {
    }

    public static void register() {
        Blocks.REGISTRY.register();
        BlockEntities.REGISTRY.register();
        Items.REGISTRY.register();
        TurtleSerialisers.REGISTRY.register();
        PocketUpgradeSerialisers.REGISTRY.register();
        Menus.REGISTRY.register();
        ArgumentTypes.REGISTRY.register();
        LootItemConditionTypes.REGISTRY.register();
        RecipeSerializers.REGISTRY.register();
        Permissions.REGISTRY.register();
        CreativeTabs.REGISTRY.register();
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerRefuelHandler(new FurnaceRefuelHandler());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            Item item = stack.m_41720_();
            if (item instanceof IMedia) {
                IMedia media = (IMedia)item;
                return media;
            }
            if (item instanceof RecordItem) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            ITurtleAccess turtle = computer.getComponent(ComputerComponents.TURTLE);
            MetricsObserver metrics = Objects.requireNonNull(computer.getComponent(ComponentMap.METRICS));
            return turtle == null ? null : new TurtleAPI(metrics, (TurtleAccessInternal)turtle);
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            IPocketAccess pocket = computer.getComponent(ComputerComponents.POCKET);
            return pocket == null ? null : new PocketAPI(pocket);
        });
        ComputerCraftAPI.registerAPIFactory(computer -> {
            AdminComputer admin = computer.getComponent(ComputerComponents.ADMIN_COMPUTER);
            return admin == null ? null : new CommandAPI(computer, admin);
        });
        VanillaDetailRegistries.ITEM_STACK.addProvider(ItemDetails::fill);
        VanillaDetailRegistries.BLOCK_IN_WORLD.addProvider(BlockDetails::fill);
    }

    public static void registerMainThread() {
        CauldronInteraction.f_175607_.put((Item)Items.TURTLE_NORMAL.get(), TurtleItem.CAULDRON_INTERACTION);
        CauldronInteraction.f_175607_.put((Item)Items.TURTLE_ADVANCED.get(), TurtleItem.CAULDRON_INTERACTION);
    }

    private static void addTurtle(CreativeModeTab.Output out, TurtleItem turtle) {
        out.m_246342_(turtle.create(-1, null, -1, null, null, 0, null));
        TurtleUpgrades.getVanillaUpgrades().map(x -> turtle.create(-1, null, -1, null, UpgradeData.ofDefault(x), 0, null)).forEach(arg_0 -> ((CreativeModeTab.Output)out).m_246342_(arg_0));
    }

    private static void addPocket(CreativeModeTab.Output out, PocketComputerItem pocket) {
        out.m_246342_(pocket.create(-1, null, -1, null));
        PocketUpgrades.getVanillaUpgrades().map(x -> pocket.create(-1, null, -1, UpgradeData.ofDefault(x))).forEach(arg_0 -> ((CreativeModeTab.Output)out).m_246342_(arg_0));
    }

    public static final class Blocks {
        static final RegistrationHelper<Block> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256747_);
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_NORMAL = REGISTRY.register("computer_normal", () -> new ComputerBlock(Blocks.redstoneConductor().m_284180_(MapColor.f_283947_), BlockEntities.COMPUTER_NORMAL));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_ADVANCED = REGISTRY.register("computer_advanced", () -> new ComputerBlock(Blocks.redstoneConductor().m_284180_(MapColor.f_283757_), BlockEntities.COMPUTER_ADVANCED));
        public static final RegistryEntry<ComputerBlock<ComputerBlockEntity>> COMPUTER_COMMAND = REGISTRY.register("computer_command", () -> new CommandComputerBlock(Blocks.redstoneConductor().m_60913_(-1.0f, 6000000.0f), BlockEntities.COMPUTER_COMMAND));
        public static final RegistryEntry<TurtleBlock> TURTLE_NORMAL = REGISTRY.register("turtle_normal", () -> new TurtleBlock(Blocks.turtleProperties().m_284180_(MapColor.f_283947_), BlockEntities.TURTLE_NORMAL));
        public static final RegistryEntry<TurtleBlock> TURTLE_ADVANCED = REGISTRY.register("turtle_advanced", () -> new TurtleBlock(Blocks.turtleProperties().m_284180_(MapColor.f_283757_).m_155956_(2000.0f), BlockEntities.TURTLE_ADVANCED));
        public static final RegistryEntry<SpeakerBlock> SPEAKER = REGISTRY.register("speaker", () -> new SpeakerBlock(Blocks.properties().m_284180_(MapColor.f_283947_)));
        public static final RegistryEntry<DiskDriveBlock> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new DiskDriveBlock(Blocks.properties().m_284180_(MapColor.f_283947_)));
        public static final RegistryEntry<PrinterBlock> PRINTER = REGISTRY.register("printer", () -> new PrinterBlock(Blocks.properties().m_284180_(MapColor.f_283947_)));
        public static final RegistryEntry<MonitorBlock> MONITOR_NORMAL = REGISTRY.register("monitor_normal", () -> new MonitorBlock(Blocks.properties().m_284180_(MapColor.f_283947_), BlockEntities.MONITOR_NORMAL));
        public static final RegistryEntry<MonitorBlock> MONITOR_ADVANCED = REGISTRY.register("monitor_advanced", () -> new MonitorBlock(Blocks.properties().m_284180_(MapColor.f_283757_), BlockEntities.MONITOR_ADVANCED));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> new WirelessModemBlock(Blocks.properties().m_284180_(MapColor.f_283947_), BlockEntities.WIRELESS_MODEM_NORMAL));
        public static final RegistryEntry<WirelessModemBlock> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> new WirelessModemBlock(Blocks.properties().m_284180_(MapColor.f_283757_), BlockEntities.WIRELESS_MODEM_ADVANCED));
        public static final RegistryEntry<WiredModemFullBlock> WIRED_MODEM_FULL = REGISTRY.register("wired_modem_full", () -> new WiredModemFullBlock(Blocks.modemProperties().m_284180_(MapColor.f_283947_)));
        public static final RegistryEntry<CableBlock> CABLE = REGISTRY.register("cable", () -> new CableBlock(Blocks.modemProperties().m_284180_(MapColor.f_283947_)));
        public static final RegistryEntry<CustomLecternBlock> LECTERN = REGISTRY.register("lectern", () -> new CustomLecternBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_()));
        public static final RegistryEntry<RedstoneRelayBlock> REDSTONE_RELAY = REGISTRY.register("redstone_relay", () -> new RedstoneRelayBlock(Blocks.redstoneConductor().m_284180_(MapColor.f_283947_)));

        private static BlockBehaviour.Properties properties() {
            return BlockBehaviour.Properties.m_284310_().m_60978_(2.0f);
        }

        private static BlockBehaviour.Properties redstoneConductor() {
            return Blocks.properties().m_60924_((block, level, blockPos) -> false);
        }

        private static BlockBehaviour.Properties turtleProperties() {
            return BlockBehaviour.Properties.m_284310_().m_60978_(2.5f);
        }

        private static BlockBehaviour.Properties modemProperties() {
            return BlockBehaviour.Properties.m_284310_().m_60978_(1.5f);
        }
    }

    public static class BlockEntities {
        static final RegistrationHelper<BlockEntityType<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256922_);
        public static final RegistryEntry<BlockEntityType<MonitorBlockEntity>> MONITOR_NORMAL = BlockEntities.ofBlock(Blocks.MONITOR_NORMAL, (p, s) -> new MonitorBlockEntity((BlockEntityType<? extends MonitorBlockEntity>)((BlockEntityType)MONITOR_NORMAL.get()), (BlockPos)p, (BlockState)s, false));
        public static final RegistryEntry<BlockEntityType<MonitorBlockEntity>> MONITOR_ADVANCED = BlockEntities.ofBlock(Blocks.MONITOR_ADVANCED, (p, s) -> new MonitorBlockEntity((BlockEntityType<? extends MonitorBlockEntity>)((BlockEntityType)MONITOR_ADVANCED.get()), (BlockPos)p, (BlockState)s, true));
        public static final RegistryEntry<BlockEntityType<ComputerBlockEntity>> COMPUTER_NORMAL = BlockEntities.ofBlock(Blocks.COMPUTER_NORMAL, (p, s) -> new ComputerBlockEntity((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)COMPUTER_NORMAL.get()), (BlockPos)p, (BlockState)s, ComputerFamily.NORMAL));
        public static final RegistryEntry<BlockEntityType<ComputerBlockEntity>> COMPUTER_ADVANCED = BlockEntities.ofBlock(Blocks.COMPUTER_ADVANCED, (p, s) -> new ComputerBlockEntity((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)COMPUTER_ADVANCED.get()), (BlockPos)p, (BlockState)s, ComputerFamily.ADVANCED));
        public static final RegistryEntry<BlockEntityType<ComputerBlockEntity>> COMPUTER_COMMAND = BlockEntities.ofBlock(Blocks.COMPUTER_COMMAND, (p, s) -> new ComputerBlockEntity((BlockEntityType<? extends ComputerBlockEntity>)((BlockEntityType)COMPUTER_COMMAND.get()), (BlockPos)p, (BlockState)s, ComputerFamily.COMMAND));
        public static final RegistryEntry<BlockEntityType<TurtleBlockEntity>> TURTLE_NORMAL = BlockEntities.ofBlock(Blocks.TURTLE_NORMAL, (p, s) -> new TurtleBlockEntity((BlockEntityType<? extends TurtleBlockEntity>)((BlockEntityType)TURTLE_NORMAL.get()), (BlockPos)p, (BlockState)s, () -> Config.turtleFuelLimit, ComputerFamily.NORMAL));
        public static final RegistryEntry<BlockEntityType<TurtleBlockEntity>> TURTLE_ADVANCED = BlockEntities.ofBlock(Blocks.TURTLE_ADVANCED, (p, s) -> new TurtleBlockEntity((BlockEntityType<? extends TurtleBlockEntity>)((BlockEntityType)TURTLE_ADVANCED.get()), (BlockPos)p, (BlockState)s, () -> Config.advancedTurtleFuelLimit, ComputerFamily.ADVANCED));
        public static final RegistryEntry<BlockEntityType<SpeakerBlockEntity>> SPEAKER = BlockEntities.ofBlock(Blocks.SPEAKER, (p, s) -> new SpeakerBlockEntity((BlockEntityType<SpeakerBlockEntity>)((BlockEntityType)SPEAKER.get()), (BlockPos)p, (BlockState)s));
        public static final RegistryEntry<BlockEntityType<DiskDriveBlockEntity>> DISK_DRIVE = BlockEntities.ofBlock(Blocks.DISK_DRIVE, (p, s) -> new DiskDriveBlockEntity((BlockEntityType<DiskDriveBlockEntity>)((BlockEntityType)DISK_DRIVE.get()), (BlockPos)p, (BlockState)s));
        public static final RegistryEntry<BlockEntityType<PrinterBlockEntity>> PRINTER = BlockEntities.ofBlock(Blocks.PRINTER, (p, s) -> new PrinterBlockEntity((BlockEntityType<PrinterBlockEntity>)((BlockEntityType)PRINTER.get()), (BlockPos)p, (BlockState)s));
        public static final RegistryEntry<BlockEntityType<WiredModemFullBlockEntity>> WIRED_MODEM_FULL = BlockEntities.ofBlock(Blocks.WIRED_MODEM_FULL, (p, s) -> new WiredModemFullBlockEntity((BlockEntityType<WiredModemFullBlockEntity>)((BlockEntityType)WIRED_MODEM_FULL.get()), (BlockPos)p, (BlockState)s));
        public static final RegistryEntry<BlockEntityType<CableBlockEntity>> CABLE = BlockEntities.ofBlock(Blocks.CABLE, (p, s) -> new CableBlockEntity((BlockEntityType<? extends CableBlockEntity>)((BlockEntityType)CABLE.get()), (BlockPos)p, (BlockState)s));
        public static final RegistryEntry<BlockEntityType<WirelessModemBlockEntity>> WIRELESS_MODEM_NORMAL = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, (p, s) -> new WirelessModemBlockEntity((BlockEntityType<? extends WirelessModemBlockEntity>)((BlockEntityType)WIRELESS_MODEM_NORMAL.get()), (BlockPos)p, (BlockState)s, false));
        public static final RegistryEntry<BlockEntityType<WirelessModemBlockEntity>> WIRELESS_MODEM_ADVANCED = BlockEntities.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, (p, s) -> new WirelessModemBlockEntity((BlockEntityType<? extends WirelessModemBlockEntity>)((BlockEntityType)WIRELESS_MODEM_ADVANCED.get()), (BlockPos)p, (BlockState)s, true));
        public static final RegistryEntry<BlockEntityType<CustomLecternBlockEntity>> LECTERN = BlockEntities.ofBlock(Blocks.LECTERN, CustomLecternBlockEntity::new);
        public static final RegistryEntry<BlockEntityType<RedstoneRelayBlockEntity>> REDSTONE_RELAY = BlockEntities.ofBlock(Blocks.REDSTONE_RELAY, RedstoneRelayBlockEntity::new);

        private static <T extends BlockEntity> RegistryEntry<BlockEntityType<T>> ofBlock(RegistryEntry<? extends Block> block, BiFunction<BlockPos, BlockState, T> factory) {
            return REGISTRY.register(block.id().m_135815_(), () -> PlatformHelper.get().createBlockEntityType(factory, (Block)block.get()));
        }
    }

    public static final class Items {
        static final RegistrationHelper<Item> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256913_);
        public static final RegistryEntry<ComputerItem> COMPUTER_NORMAL = Items.ofBlock(Blocks.COMPUTER_NORMAL, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_ADVANCED = Items.ofBlock(Blocks.COMPUTER_ADVANCED, ComputerItem::new);
        public static final RegistryEntry<ComputerItem> COMPUTER_COMMAND = Items.ofBlock(Blocks.COMPUTER_COMMAND, CommandComputerItem::new);
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_NORMAL = REGISTRY.register("pocket_computer_normal", () -> new PocketComputerItem(Items.properties().m_41487_(1), ComputerFamily.NORMAL));
        public static final RegistryEntry<PocketComputerItem> POCKET_COMPUTER_ADVANCED = REGISTRY.register("pocket_computer_advanced", () -> new PocketComputerItem(Items.properties().m_41487_(1), ComputerFamily.ADVANCED));
        public static final RegistryEntry<TurtleItem> TURTLE_NORMAL = Items.ofBlock(Blocks.TURTLE_NORMAL, TurtleItem::new);
        public static final RegistryEntry<TurtleItem> TURTLE_ADVANCED = Items.ofBlock(Blocks.TURTLE_ADVANCED, TurtleItem::new);
        public static final RegistryEntry<DiskItem> DISK = REGISTRY.register("disk", () -> new DiskItem(Items.properties().m_41487_(1)));
        public static final RegistryEntry<TreasureDiskItem> TREASURE_DISK = REGISTRY.register("treasure_disk", () -> new TreasureDiskItem(Items.properties().m_41487_(1)));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGE = REGISTRY.register("printed_page", () -> new PrintoutItem(Items.properties().m_41487_(1), PrintoutItem.Type.PAGE));
        public static final RegistryEntry<PrintoutItem> PRINTED_PAGES = REGISTRY.register("printed_pages", () -> new PrintoutItem(Items.properties().m_41487_(1), PrintoutItem.Type.PAGES));
        public static final RegistryEntry<PrintoutItem> PRINTED_BOOK = REGISTRY.register("printed_book", () -> new PrintoutItem(Items.properties().m_41487_(1), PrintoutItem.Type.BOOK));
        public static final RegistryEntry<BlockItem> SPEAKER = Items.ofBlock(Blocks.SPEAKER, BlockItem::new);
        public static final RegistryEntry<BlockItem> DISK_DRIVE = Items.ofBlock(Blocks.DISK_DRIVE, BlockItem::new);
        public static final RegistryEntry<BlockItem> PRINTER = Items.ofBlock(Blocks.PRINTER, BlockItem::new);
        public static final RegistryEntry<BlockItem> MONITOR_NORMAL = Items.ofBlock(Blocks.MONITOR_NORMAL, BlockItem::new);
        public static final RegistryEntry<BlockItem> MONITOR_ADVANCED = Items.ofBlock(Blocks.MONITOR_ADVANCED, BlockItem::new);
        public static final RegistryEntry<BlockItem> WIRELESS_MODEM_NORMAL = Items.ofBlock(Blocks.WIRELESS_MODEM_NORMAL, BlockItem::new);
        public static final RegistryEntry<BlockItem> WIRELESS_MODEM_ADVANCED = Items.ofBlock(Blocks.WIRELESS_MODEM_ADVANCED, BlockItem::new);
        public static final RegistryEntry<BlockItem> WIRED_MODEM_FULL = Items.ofBlock(Blocks.WIRED_MODEM_FULL, BlockItem::new);
        public static final RegistryEntry<BlockItem> REDSTONE_RELAY = Items.ofBlock(Blocks.REDSTONE_RELAY, BlockItem::new);
        public static final RegistryEntry<CableBlockItem.Cable> CABLE = REGISTRY.register("cable", () -> new CableBlockItem.Cable((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));
        public static final RegistryEntry<CableBlockItem.WiredModem> WIRED_MODEM = REGISTRY.register("wired_modem", () -> new CableBlockItem.WiredModem((CableBlock)((Object)((Object)Blocks.CABLE.get())), Items.properties()));

        private static Item.Properties properties() {
            return new Item.Properties();
        }

        private static <B extends Block, I extends Item> RegistryEntry<I> ofBlock(RegistryEntry<B> parent, BiFunction<B, Item.Properties, I> supplier) {
            return REGISTRY.register(parent.id().m_135815_(), () -> (Item)supplier.apply((Block)parent.get(), Items.properties()));
        }
    }

    public static class TurtleSerialisers {
        static final RegistrationHelper<TurtleUpgradeSerialiser<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(TurtleUpgradeSerialiser.registryId());
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleSpeaker::new));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleCraftingTable>> WORKBENCH = REGISTRY.register("workbench", () -> TurtleUpgradeSerialiser.simpleWithCustomItem(TurtleCraftingTable::new));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleModem>> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> TurtleUpgradeSerialiser.simpleWithCustomItem((id, item) -> new TurtleModem((ResourceLocation)id, (ItemStack)item, false)));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleModem>> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> TurtleUpgradeSerialiser.simpleWithCustomItem((id, item) -> new TurtleModem((ResourceLocation)id, (ItemStack)item, true)));
        public static final RegistryEntry<TurtleUpgradeSerialiser<TurtleTool>> TOOL = REGISTRY.register("tool", () -> TurtleToolSerialiser.INSTANCE);
    }

    public static class PocketUpgradeSerialisers {
        static final RegistrationHelper<PocketUpgradeSerialiser<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(PocketUpgradeSerialiser.registryId());
        public static final RegistryEntry<PocketUpgradeSerialiser<PocketSpeaker>> SPEAKER = REGISTRY.register("speaker", () -> PocketUpgradeSerialiser.simpleWithCustomItem(PocketSpeaker::new));
        public static final RegistryEntry<PocketUpgradeSerialiser<PocketModem>> WIRELESS_MODEM_NORMAL = REGISTRY.register("wireless_modem_normal", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketModem((ResourceLocation)id, (ItemStack)item, false)));
        public static final RegistryEntry<PocketUpgradeSerialiser<PocketModem>> WIRELESS_MODEM_ADVANCED = REGISTRY.register("wireless_modem_advanced", () -> PocketUpgradeSerialiser.simpleWithCustomItem((id, item) -> new PocketModem((ResourceLocation)id, (ItemStack)item, true)));
    }

    public static class Menus {
        static final RegistrationHelper<MenuType<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256798_);
        public static final RegistryEntry<MenuType<ComputerMenuWithoutInventory>> COMPUTER = REGISTRY.register("computer", () -> ContainerData.toType(ComputerContainerData::new, (id, inv, data) -> new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)COMPUTER.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<MenuType<ComputerMenuWithoutInventory>> POCKET_COMPUTER_NO_TERM = REGISTRY.register("pocket_computer_no_term", () -> ContainerData.toType(ComputerContainerData::new, (id, inv, data) -> new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)POCKET_COMPUTER_NO_TERM.get()), id, inv, (ComputerContainerData)data)));
        public static final RegistryEntry<MenuType<TurtleMenu>> TURTLE = REGISTRY.register("turtle", () -> ContainerData.toType(ComputerContainerData::new, TurtleMenu::ofMenuData));
        public static final RegistryEntry<MenuType<DiskDriveMenu>> DISK_DRIVE = REGISTRY.register("disk_drive", () -> new MenuType(DiskDriveMenu::new, FeatureFlags.f_244377_));
        public static final RegistryEntry<MenuType<PrinterMenu>> PRINTER = REGISTRY.register("printer", () -> new MenuType(PrinterMenu::new, FeatureFlags.f_244377_));
        public static final RegistryEntry<MenuType<PrintoutMenu>> PRINTOUT = REGISTRY.register("printout", () -> new MenuType((i, c) -> PrintoutMenu.createRemote(i), FeatureFlags.f_244377_));
    }

    static class ArgumentTypes {
        static final RegistrationHelper<ArgumentTypeInfo<?, ?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256982_);

        ArgumentTypes() {
        }

        private static <T extends ArgumentType<?>> void registerUnsafe(String name, Class<T> type, ArgumentTypeInfo<?, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, ArgumentTypeInfo<T, ?> serializer) {
            REGISTRY.register(name, () -> PlatformHelper.get().registerArgumentTypeInfo(type, serializer));
        }

        private static <T extends ArgumentType<?>> void register(String name, Class<T> type, T instance) {
            ArgumentTypes.register(name, type, SingletonArgumentInfo.m_235451_(() -> instance));
        }

        static {
            ArgumentTypes.register("tracking_field", TrackingFieldArgumentType.class, TrackingFieldArgumentType.metric());
            ArgumentTypes.register("computer", ComputerArgumentType.class, ComputerArgumentType.get());
            ArgumentTypes.registerUnsafe("repeat", RepeatArgumentType.class, new RepeatArgumentType.Info());
        }
    }

    public static class LootItemConditionTypes {
        static final RegistrationHelper<LootItemConditionType> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256976_);
        public static final RegistryEntry<LootItemConditionType> BLOCK_NAMED = REGISTRY.register("block_named", () -> ConstantLootConditionSerializer.type(BlockNamedEntityLootCondition.INSTANCE));
        public static final RegistryEntry<LootItemConditionType> PLAYER_CREATIVE = REGISTRY.register("player_creative", () -> ConstantLootConditionSerializer.type(PlayerCreativeLootCondition.INSTANCE));
        public static final RegistryEntry<LootItemConditionType> HAS_ID = REGISTRY.register("has_id", () -> ConstantLootConditionSerializer.type(HasComputerIdLootCondition.INSTANCE));
    }

    public static class RecipeSerializers {
        static final RegistrationHelper<RecipeSerializer<?>> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_256764_);
        public static final RegistryEntry<RecipeSerializer<CustomShapedRecipe>> SHAPED = REGISTRY.register("shaped", () -> CustomShapedRecipe.serialiser(CustomShapedRecipe::new));
        public static final RegistryEntry<RecipeSerializer<CustomShapelessRecipe>> SHAPELESS = REGISTRY.register("shapeless", () -> CustomShapelessRecipe.serialiser(CustomShapelessRecipe::new));
        public static final RegistryEntry<RecipeSerializer<ImpostorShapedRecipe>> IMPOSTOR_SHAPED = REGISTRY.register("impostor_shaped", () -> CustomShapedRecipe.serialiser(ImpostorShapedRecipe::new));
        public static final RegistryEntry<RecipeSerializer<ImpostorShapelessRecipe>> IMPOSTOR_SHAPELESS = REGISTRY.register("impostor_shapeless", () -> CustomShapelessRecipe.serialiser(ImpostorShapelessRecipe::new));
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<ColourableRecipe>> DYEABLE_ITEM = RecipeSerializers.simple("colour", ColourableRecipe::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<ClearColourRecipe>> DYEABLE_ITEM_CLEAR = RecipeSerializers.simple("clear_colour", ClearColourRecipe::new);
        public static final RegistryEntry<RecipeSerializer<TurtleRecipe>> TURTLE = REGISTRY.register("turtle", () -> TurtleRecipe.validatingSerialiser(TurtleRecipe::of));
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<TurtleUpgradeRecipe>> TURTLE_UPGRADE = RecipeSerializers.simple("turtle_upgrade", TurtleUpgradeRecipe::new);
        public static final RegistryEntry<RecipeSerializer<TurtleOverlayRecipe>> TURTLE_OVERLAY = REGISTRY.register("turtle_overlay", TurtleOverlayRecipe.Serialiser::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<PocketComputerUpgradeRecipe>> POCKET_COMPUTER_UPGRADE = RecipeSerializers.simple("pocket_computer_upgrade", PocketComputerUpgradeRecipe::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<PrintoutRecipe>> PRINTOUT = RecipeSerializers.simple("printout", PrintoutRecipe::new);
        public static final RegistryEntry<SimpleCraftingRecipeSerializer<DiskRecipe>> DISK = RecipeSerializers.simple("disk", DiskRecipe::new);
        public static final RegistryEntry<RecipeSerializer<ComputerUpgradeRecipe>> COMPUTER_UPGRADE = REGISTRY.register("computer_upgrade", () -> CustomShapedRecipe.validatingSerialiser(ComputerUpgradeRecipe::of));

        private static <T extends CustomRecipe> RegistryEntry<SimpleCraftingRecipeSerializer<T>> simple(String name, SimpleCraftingRecipeSerializer.Factory<T> factory) {
            return REGISTRY.register(name, () -> new SimpleCraftingRecipeSerializer(factory));
        }
    }

    public static class Permissions {
        static final PermissionRegistry REGISTRY = PermissionRegistry.create();
        public static final Predicate<CommandSourceStack> PERMISSION_DUMP = REGISTRY.registerCommand("dump", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_SHUTDOWN = REGISTRY.registerCommand("shutdown", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_TURN_ON = REGISTRY.registerCommand("turn_on", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_TP = REGISTRY.registerCommand("tp", UserLevel.OP);
        public static final Predicate<CommandSourceStack> PERMISSION_TRACK = REGISTRY.registerCommand("track", UserLevel.OWNER_OP);
        public static final Predicate<CommandSourceStack> PERMISSION_QUEUE = REGISTRY.registerCommand("queue", UserLevel.ANYONE);
        public static final Predicate<CommandSourceStack> PERMISSION_VIEW = REGISTRY.registerCommand("view", UserLevel.OP);
    }

    static class CreativeTabs {
        static final RegistrationHelper<CreativeModeTab> REGISTRY = PlatformHelper.get().createRegistrationHelper(Registries.f_279569_);
        private static final RegistryEntry<CreativeModeTab> TAB = REGISTRY.register("tab", () -> PlatformHelper.get().newCreativeModeTab().m_257737_(() -> new ItemStack((ItemLike)Items.COMPUTER_NORMAL.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.computercraft")).m_257501_((context, out) -> {
            out.m_246342_(new ItemStack((ItemLike)Items.COMPUTER_NORMAL.get()));
            out.m_246342_(new ItemStack((ItemLike)Items.COMPUTER_ADVANCED.get()));
            if (context.f_268429_()) {
                out.m_246342_(new ItemStack((ItemLike)Items.COMPUTER_COMMAND.get()));
            }
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_NORMAL.get());
            ModRegistry.addTurtle(out, (TurtleItem)Items.TURTLE_ADVANCED.get());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_NORMAL.get());
            ModRegistry.addPocket(out, (PocketComputerItem)Items.POCKET_COMPUTER_ADVANCED.get());
            out.m_246326_((ItemLike)Items.WIRELESS_MODEM_NORMAL.get());
            out.m_246326_((ItemLike)Items.WIRELESS_MODEM_ADVANCED.get());
            out.m_246326_((ItemLike)Items.CABLE.get());
            out.m_246326_((ItemLike)Items.WIRED_MODEM.get());
            out.m_246326_((ItemLike)Items.WIRED_MODEM_FULL.get());
            out.m_246326_((ItemLike)Items.REDSTONE_RELAY.get());
            out.m_246326_((ItemLike)Items.MONITOR_NORMAL.get());
            out.m_246326_((ItemLike)Items.MONITOR_ADVANCED.get());
            out.m_246326_((ItemLike)Items.SPEAKER.get());
            out.m_246326_((ItemLike)Items.PRINTER.get());
            out.m_246326_((ItemLike)Items.PRINTED_PAGE.get());
            out.m_246326_((ItemLike)Items.PRINTED_PAGES.get());
            out.m_246326_((ItemLike)Items.PRINTED_BOOK.get());
            out.m_246326_((ItemLike)Items.DISK_DRIVE.get());
            for (int colour = 0; colour < 16; ++colour) {
                out.m_246342_(DiskItem.createFromIDAndColour(-1, null, Colour.VALUES[colour].getHex()));
            }
        }).m_257652_());

        CreativeTabs() {
        }
    }
}

