/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.network.s_to_c;

import com.legacy.blue_skies.capability.SkiesPlayer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class SetInvisiblePacket {
    private boolean value;
    private byte mode;
    private UUID uuid;

    public SetInvisiblePacket(boolean valueIn, byte mode, UUID uuid) {
        this.value = valueIn;
        this.mode = mode;
        this.uuid = uuid;
    }

    public static void encoder(SetInvisiblePacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.value);
        buff.writeByte((int)packet.mode);
        buff.m_130077_(packet.uuid);
    }

    public static SetInvisiblePacket decoder(FriendlyByteBuf buff) {
        return new SetInvisiblePacket(buff.readBoolean(), buff.readByte(), buff.m_130259_());
    }

    public static void handler(SetInvisiblePacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> SetInvisiblePacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(SetInvisiblePacket packet) {
        Player player = Minecraft.m_91087_().f_91074_.m_9236_().m_46003_(packet.uuid);
        if (packet.mode == 0) {
            if (player != null) {
                player.m_6842_(packet.value);
            }
        } else if (packet.mode == 1) {
            SkiesPlayer.ifPresent(player, skiesPlayer -> skiesPlayer.setFullDuskInvis(packet.value));
        }
    }
}

