/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.passive;

import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.entities.passive.AzulfoEntity;
import java.util.List;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AzulfoModel<T extends AzulfoEntity>
extends QuadrupedModel<T> {
    protected final ModelPart f_103493_;
    protected final ModelPart f_170853_;
    protected final ModelPart f_170855_;
    protected final ModelPart f_170852_;
    protected final ModelPart f_170854_;
    protected final ModelPart bodyBack;
    protected final ModelPart rightShoulder;
    protected final ModelPart leftShoulder;
    protected final ModelPart tail;
    protected final ModelPart f_103492_;
    protected final ModelPart hornTopRight;
    protected final ModelPart hornTopLeft;
    protected final ModelPart hornBaseLeft;
    protected final ModelPart snootTop;
    protected final ModelPart hornBaseRight;
    protected final ModelPart snootBottom;
    protected final ModelPart helmet;

    public AzulfoModel(ModelPart model) {
        super(model, false, 12.0f, 8.0f, 2.0f, 2.0f, 24);
        this.f_103492_ = model.m_171324_("head");
        this.snootTop = this.f_103492_.m_171324_("snoot_top");
        this.snootBottom = this.f_103492_.m_171324_("snoot_bottom");
        this.hornTopRight = this.f_103492_.m_171324_("horn_top_right");
        this.hornBaseRight = this.f_103492_.m_171324_("horn_base_right");
        this.hornTopLeft = this.f_103492_.m_171324_("horn_top_left");
        this.hornBaseLeft = this.f_103492_.m_171324_("horn_base_left");
        this.f_103493_ = model.m_171324_("body");
        this.bodyBack = model.m_171324_("body_back");
        this.tail = model.m_171324_("tail");
        this.f_170854_ = model.m_171324_("right_front_leg");
        this.rightShoulder = this.f_170854_.m_171324_("right_shoulder");
        this.f_170855_ = model.m_171324_("left_front_leg");
        this.leftShoulder = this.f_170855_.m_171324_("left_shoulder");
        this.f_170852_ = model.m_171324_("right_hind_leg");
        this.f_170853_ = model.m_171324_("left_hind_leg");
        this.helmet = model.m_171324_("helmet");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 102).m_171488_(-5.0f, -7.0f, -12.0f, 10.0f, 14.0f, 12.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-17.0f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 79).m_171488_(-4.5f, -6.0f, -8.0f, 9.0f, 12.0f, 9.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-17.0f));
        head.m_171599_("snoot_top", CubeListBuilder.m_171558_().m_171514_(37, 79).m_171488_(-3.0f, 1.0f, -18.0f, 6.0f, 3.0f, 3.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        head.m_171599_("snoot_bottom", CubeListBuilder.m_171558_().m_171514_(37, 85).m_171488_(-2.5f, 3.0f, -17.0f, 5.0f, 2.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.0f));
        head.m_171599_("horn_top_right", CubeListBuilder.m_171558_().m_171514_(36, 89).m_171480_().m_171488_(-9.5f, -10.0f, -12.0f, 2.0f, 5.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        head.m_171599_("horn_base_right", CubeListBuilder.m_171558_().m_171514_(36, 96).m_171480_().m_171488_(-9.5f, -5.0f, -12.0f, 5.0f, 2.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        head.m_171599_("horn_top_left", CubeListBuilder.m_171558_().m_171514_(36, 89).m_171488_(7.5f, -10.0f, -12.0f, 2.0f, 5.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        head.m_171599_("horn_base_left", CubeListBuilder.m_171558_().m_171514_(36, 96).m_171488_(4.5f, -5.0f, -12.0f, 5.0f, 2.0f, 2.0f, size), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -19.0f, -7.0f, 18.0f, 23.0f, 19.0f, size), PartPose.m_171423_((float)-3.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        root.m_171599_("body_back", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(0.0f, -8.9421f, -1.0188f, 15.0f, 20.0f, 17.0f, size), PartPose.m_171423_((float)-8.0f, (float)11.0f, (float)7.2f, (float)1.4573f, (float)0.0f, (float)0.0f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 100).m_171488_(-1.5f, -0.2071f, -0.9783f, 3.0f, 12.0f, 2.0f, size), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)19.3f, (float)0.2086f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(75, 0).m_171480_().m_171488_(-2.0f, 2.0f, -2.4f, 5.0f, 14.0f, 5.0f, size), PartPose.m_171419_((float)-8.0f, (float)8.0f, (float)-12.1f));
        rightLeg.m_171599_("right_shoulder", CubeListBuilder.m_171558_().m_171514_(55, 3).m_171480_().m_171488_(0.0f, -4.0f, -13.0f, 2.0f, 8.0f, 8.0f, size), PartPose.m_171419_((float)-3.0f, (float)0.0f, (float)9.0f));
        PartDefinition leftLeg = root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(75, 0).m_171488_(-3.0f, 2.0f, -2.4f, 5.0f, 14.0f, 5.0f, size), PartPose.m_171419_((float)8.0f, (float)8.0f, (float)-12.1f));
        leftLeg.m_171599_("left_shoulder", CubeListBuilder.m_171558_().m_171514_(55, 3).m_171488_(-2.0f, -4.0f, -13.0f, 2.0f, 8.0f, 8.0f, size), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)9.0f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(47, 42).m_171480_().m_171488_(-2.7f, 0.0f, -2.0f, 5.0f, 12.0f, 5.0f, size), PartPose.m_171419_((float)-5.0f, (float)12.0f, (float)13.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(47, 42).m_171488_(-2.3f, 0.0f, -3.0f, 5.0f, 12.0f, 5.0f, size), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)14.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    public Iterable<ModelPart> m_5608_() {
        return List.of(this.f_103493_, this.bodyBack, this.f_170855_, this.f_170854_, this.f_170853_, this.f_170852_, this.tail);
    }

    public Iterable<ModelPart> m_5607_() {
        return List.of(this.f_103492_, this.helmet);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.helmet.f_104207_ = entityIn.m_8077_() && "alf".equals(entityIn.m_7755_().m_214077_());
        this.f_170855_.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        this.f_170854_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_170853_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_170852_.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        if (((AzulfoEntity)((Object)entityIn)).attackTimer >= 11) {
            this.f_103492_.f_104203_ = headPitch * ((float)Math.PI / 180);
        }
        this.f_103492_.f_104204_ = SkiesClientUtil.lockNum(netHeadYaw * ((float)Math.PI / 180), 1.0f);
        this.helmet.f_104203_ = this.f_103492_.f_104203_;
        this.helmet.f_104204_ = this.f_103492_.f_104204_;
        this.tail.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTicks) {
        if (((AzulfoEntity)((Object)entityIn)).attackTimer < 11) {
            float i = (float)((AzulfoEntity)((Object)entityIn)).attackTimer + partialTicks;
            this.f_103492_.f_104203_ = (float)(((AzulfoEntity)((Object)entityIn)).attackTimer > 8 ? Math.min((double)(entityIn.m_146909_() * ((float)Math.PI / 180)), Math.sin(i * 0.58f)) : Math.sin(i * 0.58f));
        }
    }
}

