/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.gson.Serializers;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonRoomRegistry;

public class DungeonRoomLoader {
    public static List<String> lootPoolRoomSchematics = new ArrayList<String>();

    public static void saveNewDungeons() {
    }

    public static void saveDungeons() {
        for (DungeonRoom room : DungeonRoomRegistry.dungeonWeightMap.keySet()) {
            DungeonRoomLoader.saveSingleDungeon(room);
        }
    }

    public static void saveSingleDungeon(DungeonRoom room) {
        String json = Serializers.GSON.toJson((Object)room);
        try {
            File file = new File("config/BloodMagic/schematics");
            file.mkdirs();
            FileWriter writer = new FileWriter("config/BloodMagic/schematics/" + new Random().nextInt() + ".json");
            writer.write(json);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeTestPool(List<Pair<String, Integer>> roomPool) {
        ArrayList<CallSite> reducedRoomPool = new ArrayList<CallSite>();
        for (Pair<String, Integer> entry : roomPool) {
            reducedRoomPool.add((CallSite)((Object)(entry.getRight() + ";" + (String)entry.getLeft())));
        }
        String json = Serializers.GSON.toJson(roomPool);
        try {
            File file = new File("config/BloodMagic/schematics");
            file.mkdirs();
            FileWriter writer = new FileWriter("config/BloodMagic/schematics/" + Math.abs(new Random().nextInt()) + ".json");
            writer.write(json);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadRoomPools() {
        try {
            for (ResourceLocation schematic : DungeonRoomRegistry.unloadedDungeonRoomPools) {
                URL roomPoolURL = DungeonRoomLoader.class.getResource(DungeonRoomLoader.resLocToResourcePath(schematic));
                List roomPoolList = (List)Serializers.GSON.fromJson(Resources.toString((URL)roomPoolURL, (Charset)Charsets.UTF_8), new TypeToken<List<String>>(){}.getType());
                ArrayList<Pair<ResourceLocation, Integer>> roomPool = new ArrayList<Pair<ResourceLocation, Integer>>();
                for (String roomEntryString : roomPoolList) {
                    Pair<ResourceLocation, Integer> roomEntry = DungeonRoomLoader.parseRoomEntryString(roomEntryString);
                    if (roomEntry == null) continue;
                    roomPool.add(roomEntry);
                }
                DungeonRoomRegistry.registerDungeomRoomPool(schematic, roomPool);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Pair<ResourceLocation, Integer> parseRoomEntryString(String str) {
        String[] splitString = str.split(";");
        if (splitString.length == 2) {
            try {
                Integer weight = Integer.parseInt(splitString[0]);
                ResourceLocation resLoc = new ResourceLocation(splitString[1]);
                return Pair.of((Object)resLoc, (Object)weight);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public static void loadDungeons() {
        try {
            for (ResourceLocation schematic : DungeonRoomRegistry.unloadedDungeonRooms) {
                URL dungeonURL = DungeonRoomLoader.class.getResource(DungeonRoomLoader.resLocToResourcePath(schematic));
                System.out.println("Loading schematic: " + schematic);
                DungeonRoom dungeonRoom = (DungeonRoom)Serializers.GSON.fromJson(Resources.toString((URL)dungeonURL, (Charset)Charsets.UTF_8), DungeonRoom.class);
                System.out.println("Resulting dungeon: " + dungeonRoom);
                DungeonRoomRegistry.registerDungeonRoom(schematic, dungeonRoom, Math.max(1, dungeonRoom.dungeonWeight));
            }
            System.out.println("# schematics: " + DungeonRoomRegistry.unloadedDungeonRooms.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DungeonRoomLoader.saveNewDungeons();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void test() {
        ResourceLocation id = new ResourceLocation("bloodmagic", "testGson");
        String s = id.m_135827_();
        String s1 = id.m_135815_();
        InputStream inputstream = null;
        try {
            inputstream = DungeonRoomLoader.class.getResourceAsStream("/assets/" + s + "/schematics/" + s1 + ".nbt");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputstream);
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(inputstream);
                throw throwable2;
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return;
    }

    public static String resLocToResourcePath(ResourceLocation resourceLocation) {
        return "/assets/" + resourceLocation.m_135827_() + "/schematics/" + resourceLocation.m_135815_() + ".json";
    }
}

