/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile.routing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.common.container.tile.ContainerItemRoutingNode;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.common.routing.IOutputItemRoutingNode;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.routing.TileFilteredRoutingNode;
import wayoftime.bloodmagic.util.Utils;

public class TileOutputRoutingNode
extends TileFilteredRoutingNode
implements IOutputItemRoutingNode,
MenuProvider {
    public TileOutputRoutingNode(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 6, "outputnode", pos, state);
    }

    public TileOutputRoutingNode(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.OUTPUT_ROUTING_NODE_TYPE.get(), pos, state);
    }

    @Override
    public boolean isOutput(Direction side) {
        return true;
    }

    @Override
    public IItemFilter getOutputFilterForSide(Direction side) {
        IItemHandler handler;
        BlockEntity tile = this.m_58904_().m_7702_(this.f_58858_.m_121945_(side));
        if (tile != null && (handler = Utils.getInventory(tile, side.m_122424_())) != null) {
            ItemStack filterStack = this.getFilterStack(side);
            if (filterStack.m_41619_() || !(filterStack.m_41720_() instanceof IItemFilterProvider)) {
                return null;
            }
            IItemFilterProvider filter = (IItemFilterProvider)filterStack.m_41720_();
            return filter.getOutputItemFilter(filterStack, tile, handler);
        }
        return null;
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        assert (this.f_58857_ != null);
        return new ContainerItemRoutingNode(this, p_createMenu_1_, p_createMenu_2_);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Output Routing Node");
    }
}

