/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.BiggerReactors;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.data.DatapackLoader;
import net.roguelogix.phosphophyllite.robn.ROBNObject;
import org.apache.commons.lang3.NotImplementedException;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidTransitionRegistry {
    private static final Map<Fluid, FluidTransition> liquidTransitions = new HashMap<Fluid, FluidTransition>();
    private static final Map<Fluid, FluidTransition> gasTransitions = new HashMap<Fluid, FluidTransition>();
    private static final DatapackLoader<FluidTransitionJsonData> loader = new DatapackLoader(FluidTransitionJsonData::new);

    @Nullable
    public static FluidTransition liquidTransition(Fluid liquid) {
        return liquidTransitions.get(liquid);
    }

    @Nullable
    public static FluidTransition gasTransition(Fluid gas) {
        return gasTransitions.get(gas);
    }

    public static void loadRegistry() {
        BiggerReactors.LOGGER.info("Loading fluid transitions");
        liquidTransitions.clear();
        gasTransitions.clear();
        List data = loader.loadAll(new ResourceLocation("biggerreactors:transitions"));
        BiggerReactors.LOGGER.info("Loaded " + data.size() + " transitions data entries");
        for (FluidTransitionJsonData transitionData : data) {
            ArrayList<Fluid> liquids = new ArrayList<Fluid>();
            if (transitionData.liquidType == RegistryType.tag) {
                Optional fluidTagOptional = BuiltInRegistries.f_257020_.m_203431_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257020_.m_123023_(), (ResourceLocation)transitionData.liquid));
                fluidTagOptional.ifPresent(holders -> holders.forEach(fluidHolder -> {
                    Fluid fluid = (Fluid)fluidHolder.m_203334_();
                    if (fluid.m_7444_(fluid.m_76145_())) {
                        liquids.add(fluid);
                    }
                }));
            } else if (ForgeRegistries.FLUIDS.containsKey(transitionData.liquid)) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(transitionData.liquid);
                liquids.add(fluid);
            }
            if (liquids.isEmpty()) continue;
            ArrayList<Fluid> gases = new ArrayList<Fluid>();
            if (transitionData.gasType == RegistryType.tag) {
                Optional fluidTagOptional = BuiltInRegistries.f_257020_.m_203431_(TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257020_.m_123023_(), (ResourceLocation)transitionData.gas));
                fluidTagOptional.ifPresent(holders -> holders.forEach(fluidHolder -> {
                    Fluid fluid = (Fluid)fluidHolder.m_203334_();
                    if (fluid.m_7444_(fluid.m_76145_())) {
                        gases.add(fluid);
                    }
                }));
            } else if (ForgeRegistries.FLUIDS.containsKey(transitionData.gas)) {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(transitionData.gas);
                gases.add(fluid);
            }
            if (gases.isEmpty()) continue;
            FluidTransition transition = new FluidTransition(liquids, gases, transitionData.latentHeat, transitionData.boilingPoint, transitionData.liquidThermalConductivity, transitionData.gasThermalConductivity, transitionData.turbineMultiplier);
            for (Fluid liquid : transition.liquids) {
                if (liquidTransitions.put(liquid, transition) == null) continue;
                BiggerReactors.LOGGER.error("Duplicate transitions given for liquid fluid " + ForgeRegistries.FLUIDS.getKey((Object)liquid).toString());
            }
            for (Fluid gas : transition.gases) {
                if (gasTransitions.put(gas, transition) == null) continue;
                BiggerReactors.LOGGER.error("Duplicate transitions given for gas fluid " + ForgeRegistries.FLUIDS.getKey((Object)gas).toString());
            }
        }
        BiggerReactors.LOGGER.info("Loaded " + liquidTransitions.size() + " liquid transition entries");
        BiggerReactors.LOGGER.info("Loaded " + gasTransitions.size() + " gas transition entries");
    }

    public static class FluidTransition
    implements ITransitionProperties {
        public final List<Fluid> liquids;
        public final List<Fluid> gases;
        public final double latentHeat;
        public final double boilingPoint;
        public final double liquidRFMKT;
        public final double gasRFMKT;
        public final double turbineMultiplier;

        public FluidTransition(List<Fluid> liquids, List<Fluid> gases, double latentHeat, double boilingPoint, double liquidRFMKT, double gasRFMKT, double turbineMultiplier) {
            this.liquids = Collections.unmodifiableList(liquids);
            this.gases = Collections.unmodifiableList(gases);
            this.latentHeat = latentHeat;
            this.boilingPoint = boilingPoint;
            this.liquidRFMKT = liquidRFMKT;
            this.gasRFMKT = gasRFMKT;
            this.turbineMultiplier = turbineMultiplier;
        }

        @Override
        public double latentHeat() {
            return this.latentHeat;
        }

        @Override
        public double boilingPoint() {
            return this.boilingPoint;
        }

        @Override
        public double liquidRFMKT() {
            return this.liquidRFMKT;
        }

        @Override
        public double gasRFMKT() {
            return this.gasRFMKT;
        }

        @Override
        public double turbineMultiplier() {
            return this.turbineMultiplier;
        }
    }

    private static class FluidTransitionJsonData {
        @ConfigValue
        public RegistryType liquidType = RegistryType.tag;
        @ConfigValue
        public ResourceLocation liquid = new ResourceLocation("dirt");
        @ConfigValue
        public RegistryType gasType = RegistryType.tag;
        @ConfigValue
        public ResourceLocation gas = new ResourceLocation("dirt");
        @ConfigValue(range="(0,)")
        public double latentHeat;
        @ConfigValue(range="(0,)")
        public double boilingPoint;
        @ConfigValue(range="(0,)")
        public double liquidThermalConductivity;
        @ConfigValue(range="(0,)")
        public double gasThermalConductivity;
        @ConfigValue(range="[0,)")
        public double turbineMultiplier;

        private FluidTransitionJsonData() {
        }
    }

    private static enum RegistryType {
        tag,
        registry;

    }

    public static interface ITransitionProperties
    extends ROBNObject {
        public double latentHeat();

        public double boilingPoint();

        public double liquidRFMKT();

        public double gasRFMKT();

        public double turbineMultiplier();

        default public Map<String, Object> toROBNMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("latentHeat", this.latentHeat());
            map.put("boilingPoint", this.boilingPoint());
            map.put("liquidRFMKT", this.liquidRFMKT());
            map.put("gasRFMKT", this.gasRFMKT());
            map.put("turbineMultiplier", this.turbineMultiplier());
            return map;
        }

        default public void fromROBNMap(Map<String, Object> map) {
            throw new NotImplementedException("");
        }
    }
}

