/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.simulation.base;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.roguelogix.biggerreactors.multiblocks.reactor.simulation.IReactorSimulation;
import net.roguelogix.phosphophyllite.serialization.IPhosphophylliteSerializable;
import net.roguelogix.phosphophyllite.serialization.PhosphophylliteCompound;

public class FuelTank
implements IReactorSimulation.IFuelTank,
IPhosphophylliteSerializable {
    private final long capacity;
    private long fuel = 0L;
    private long waste = 0L;
    private double partialUsed = 0.0;
    private double burnedLastTick = 0.0;

    public FuelTank(long capacity) {
        this.capacity = capacity;
    }

    public void burn(double amount) {
        if (Double.isInfinite(amount) || Double.isNaN(amount) || amount == 0.0) {
            this.burnedLastTick = 0.0;
            return;
        }
        double toProcess = this.partialUsed + amount;
        toProcess = Math.min(toProcess, (double)this.fuel);
        this.burnedLastTick = toProcess - this.partialUsed;
        this.partialUsed = toProcess;
        if (toProcess >= 1.0) {
            long toBurn = (long)toProcess;
            this.fuel -= toBurn;
            this.waste += toBurn;
            this.partialUsed -= (double)toBurn;
        }
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long totalStored() {
        return this.fuel + this.waste;
    }

    @Override
    public long fuel() {
        return this.fuel;
    }

    @Override
    public long waste() {
        return this.waste;
    }

    @Override
    public long insertFuel(long amount, boolean simulated) {
        if (this.totalStored() >= this.capacity) {
            return 0L;
        }
        amount = Math.min(amount, this.capacity - this.totalStored());
        if (!simulated) {
            this.fuel += amount;
        }
        return amount;
    }

    @Override
    public long insertWaste(long amount, boolean simulated) {
        if (this.totalStored() >= this.capacity) {
            return 0L;
        }
        amount = Math.min(amount, this.capacity - this.totalStored());
        if (!simulated) {
            this.waste += amount;
        }
        return amount;
    }

    @Override
    public long extractFuel(long amount, boolean simulated) {
        amount = Math.min(this.fuel, amount);
        if (!simulated) {
            this.fuel -= amount;
        }
        return amount;
    }

    @Override
    public long extractWaste(long amount, boolean simulated) {
        amount = Math.min(this.waste, amount);
        if (!simulated) {
            this.waste -= amount;
        }
        return amount;
    }

    @Override
    public double burnedLastTick() {
        return this.burnedLastTick;
    }

    @Nullable
    public PhosphophylliteCompound save() {
        PhosphophylliteCompound compound = new PhosphophylliteCompound();
        compound.put("fuel", this.fuel);
        compound.put("waste", this.waste);
        compound.put("partialUsed", this.partialUsed);
        return compound;
    }

    public void load(@Nonnull PhosphophylliteCompound compound) {
        this.fuel = compound.getLong("fuel");
        this.waste = compound.getLong("waste");
        this.partialUsed = compound.getDouble("partialUsed");
    }
}

