/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.roguelogix.biggerreactors.Config;
import net.roguelogix.biggerreactors.client.CommonRender;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.containers.HeatExchangerTerminalContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.state.HeatExchangerState;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.elements.TooltipElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class HeatExchangerTerminalScreen
extends PhosphophylliteScreen<HeatExchangerTerminalContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/heat_exchanger_terminal.png");
    private HeatExchangerState heatExchangerState;
    private Fluid condenserIntakeFluid = Fluids.f_76191_;
    private Fluid condenserExhaustFluid = Fluids.f_76191_;
    private Fluid evaporatorIntakeFluid = Fluids.f_76191_;
    private Fluid evaporatorExhaustFluid = Fluids.f_76191_;

    public HeatExchangerTerminalScreen(HeatExchangerTerminalContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal"), DEFAULT_TEXTURE, 144, 144);
        this.heatExchangerState = (HeatExchangerState)((HeatExchangerTerminalContainer)this.m_6262_()).getGuiPacket();
        this.condenserIntakeFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.condenserIntakeFluid));
        this.condenserExhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.condenserExhaustFluid));
        this.evaporatorIntakeFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.evaporatorIntakeFluid));
        this.evaporatorExhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.evaporatorExhaustFluid));
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2;
        this.initTooltips();
        this.initGauges();
    }

    private void initTooltips() {
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 9, 103, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.temperature.condenser.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 9, 122, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.temperature.evaporator.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 75, 103, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.flow_rate.condenser.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 75, 122, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.flow_rate.evaporator.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 9, 17, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.intake_gauge.condenser.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 31, 17, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.intake_gauge.evaporator.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 53, 17, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.temperature.condenser.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 75, 17, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.temperature.evaporator.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 97, 17, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.exhaust_gauge.condenser.tooltip")));
        this.addScreenElement((AbstractElement)new TooltipElement((PhosphophylliteScreen)this, 119, 17, 16, 16, (Component)Component.m_237115_((String)"screen.biggerreactors.heat_exchanger_terminal.exhaust_gauge.evaporator.tooltip")));
    }

    private void initGauges() {
        RenderedElement condenserIntakeTank = new RenderedElement((PhosphophylliteScreen)this, 8, 36, 18, 64, 0, 144, (Component)Component.m_237119_());
        condenserIntakeTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, condenserIntakeTank, this.heatExchangerState.condenserIntakeFluidAmount, this.heatExchangerState.condenserTankSize, this.condenserIntakeFluid);
        this.addScreenElement((AbstractElement)condenserIntakeTank);
        RenderedElement evaporatorIntakeTank = new RenderedElement((PhosphophylliteScreen)this, 30, 36, 18, 64, 0, 144, (Component)Component.m_237119_());
        evaporatorIntakeTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, evaporatorIntakeTank, this.heatExchangerState.evaporatorIntakeFluidAmount, this.heatExchangerState.evaporatorTankSize, this.evaporatorIntakeFluid);
        this.addScreenElement((AbstractElement)evaporatorIntakeTank);
        RenderedElement condenserHeatGauge = new RenderedElement((PhosphophylliteScreen)this, 52, 36, 18, 64, 0, 144, (Component)Component.m_237119_());
        condenserHeatGauge.onRender = (graphics, mX, mY) -> HeatExchangerTerminalScreen.renderHeatGauge(graphics, (RenderedElement<HeatExchangerTerminalContainer>)condenserHeatGauge, this.heatExchangerState.condenserChannelTemperature, Config.CONFIG.HeatExchanger.gui.HeatDisplayMax);
        this.addScreenElement((AbstractElement)condenserHeatGauge);
        RenderedElement evaporatorHeatGauge = new RenderedElement((PhosphophylliteScreen)this, 74, 36, 18, 64, 0, 144, (Component)Component.m_237119_());
        evaporatorHeatGauge.onRender = (graphics, mX, mY) -> HeatExchangerTerminalScreen.renderHeatGauge(graphics, (RenderedElement<HeatExchangerTerminalContainer>)evaporatorHeatGauge, this.heatExchangerState.evaporatorChannelTemperature, Config.CONFIG.HeatExchanger.gui.HeatDisplayMax);
        this.addScreenElement((AbstractElement)evaporatorHeatGauge);
        RenderedElement condenserExhaustTank = new RenderedElement((PhosphophylliteScreen)this, 96, 36, 18, 64, 0, 144, (Component)Component.m_237119_());
        condenserExhaustTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, condenserExhaustTank, this.heatExchangerState.condenserExhaustFluidAmount, this.heatExchangerState.condenserTankSize, this.condenserExhaustFluid);
        this.addScreenElement((AbstractElement)condenserExhaustTank);
        RenderedElement evaporatorExhaustTank = new RenderedElement((PhosphophylliteScreen)this, 118, 36, 18, 64, 0, 144, (Component)Component.m_237119_());
        evaporatorExhaustTank.onRender = (graphics, mX, mY) -> CommonRender.renderFluidGauge(graphics, evaporatorExhaustTank, this.heatExchangerState.evaporatorExhaustFluidAmount, this.heatExchangerState.evaporatorTankSize, this.evaporatorExhaustFluid);
        this.addScreenElement((AbstractElement)evaporatorExhaustTank);
    }

    public void m_181908_() {
        if (!this.heatExchangerState.condenserIntakeFluid.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.condenserIntakeFluid)).toString())) {
            this.condenserIntakeFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.condenserIntakeFluid));
        }
        if (!this.heatExchangerState.evaporatorIntakeFluid.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.evaporatorIntakeFluid)).toString())) {
            this.evaporatorIntakeFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.evaporatorIntakeFluid));
        }
        if (!this.heatExchangerState.condenserExhaustFluid.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.condenserExhaustFluid)).toString())) {
            this.condenserExhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.condenserExhaustFluid));
        }
        if (!this.heatExchangerState.evaporatorExhaustFluid.equals(Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)this.evaporatorExhaustFluid)).toString())) {
            this.evaporatorExhaustFluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(this.heatExchangerState.evaporatorExhaustFluid));
        }
    }

    public static void renderHeatGauge(@Nonnull GuiGraphics graphics, @Nonnull RenderedElement<HeatExchangerTerminalContainer> symbol, double heatStored, double heatCapacity) {
        if (heatStored > 0.0 && heatCapacity > 0.0) {
            int renderSize = (int)((double)symbol.height * heatStored / heatCapacity);
            symbol.blit(graphics, symbol.u + 36, symbol.v);
            symbol.blit(graphics, symbol.width, symbol.height - renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(graphics);
        symbol.tooltip = Component.m_237113_((String)String.format("%.1f/%.1f K", heatStored, heatCapacity));
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280056_(this.getFont(), String.format("%.0f K", this.heatExchangerState.condenserChannelTemperature), this.getGuiLeft() + 27, this.getGuiTop() + 107, 0x404040, false);
        graphics.m_280056_(this.getFont(), String.format("%.0f K", this.heatExchangerState.evaporatorChannelTemperature), this.getGuiLeft() + 27, this.getGuiTop() + 127, 0x404040, false);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)(this.heatExchangerState.condenserChannelFlowRate / 1000.0), (int)1, (String)"B/t", (boolean)true), this.getGuiLeft() + 93, this.getGuiTop() + 107, 0x404040, false);
        graphics.m_280056_(this.getFont(), RenderHelper.formatValue((double)(this.heatExchangerState.evaporatorChannelFlowRate / 1000.0), (int)1, (String)"B/t", (boolean)true), this.getGuiLeft() + 93, this.getGuiTop() + 127, 0x404040, false);
    }
}

