/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;

public class HangingPot
extends LanternBlock {
    private static final List<Item> validFlowers = Arrays.asList(Items.f_41852_, Items.f_42208_, Items.f_42207_, Items.f_41941_, Items.f_42029_, Items.f_42206_, Items.f_42209_, Items.f_41943_, Items.f_41944_, Items.f_41945_, Items.f_41946_, Items.f_41947_, Items.f_41942_, Items.f_41939_, Items.f_41940_, Items.f_151025_, Items.f_41948_, Items.f_41950_, Items.f_41949_, Items.f_41907_, Items.f_41908_, Items.f_41951_, Items.f_151079_, Items.f_42780_, Items.f_41864_, Items.f_41865_);
    public static final IntegerProperty POTFLOWER = IntegerProperty.m_61631_((String)"potflower", (int)0, (int)(validFlowers.size() - 1));
    public static final BooleanProperty GROWN = BooleanProperty.m_61465_((String)"grown");
    private static final VoxelShape HANGING_SHAPE = Shapes.m_83124_((VoxelShape)HangingPot.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), (VoxelShape[])new VoxelShape[]{HangingPot.m_49796_((double)3.75, (double)4.0, (double)3.75, (double)12.25, (double)8.0, (double)12.25), HangingPot.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});
    private static final VoxelShape STANDING_SHAPE = Shapes.m_83110_((VoxelShape)HangingPot.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (VoxelShape)HangingPot.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));

    public HangingPot(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POTFLOWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)f_153459_)).booleanValue()) {
            return HANGING_SHAPE;
        }
        return STANDING_SHAPE;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos blockPos, boolean bool) {
        if (((Boolean)state.m_61143_((Property)GROWN)).booleanValue() && blockPos.equals((Object)pos.m_7495_()) && level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
            ItemEntity Item2 = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)validFlowers.get((Integer)state.m_61143_((Property)POTFLOWER))));
            level.m_7967_((Entity)Item2);
            level.m_5594_(null, pos, SoundEvents.f_144152_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_6861_(state, level, pos, block, blockPos, bool);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (pHand == InteractionHand.MAIN_HAND) {
            ItemStack playerStack = pPlayer.m_21120_(pHand);
            if (playerStack.m_41720_().equals(Items.f_42499_) && (Integer)pState.m_61143_((Property)POTFLOWER) != 0 && !pLevel.m_8055_(pPos.m_7495_()).m_60783_((BlockGetter)pLevel, pPos.m_7495_(), Direction.UP) && !((Boolean)pState.m_61143_((Property)GROWN)).booleanValue()) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_144074_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!pPlayer.m_7500_()) {
                    playerStack.m_41774_(1);
                }
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(true)), 3);
                return InteractionResult.SUCCESS;
            }
            if (playerStack.canPerformAction(ToolAction.get((String)"shears_harvest")) && (Integer)pState.m_61143_((Property)POTFLOWER) != 0 && ((Boolean)pState.m_61143_((Property)GROWN)).booleanValue()) {
                pLevel.m_5594_(null, pPos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
                ItemEntity Item2 = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), new ItemStack((ItemLike)validFlowers.get((Integer)pState.m_61143_((Property)POTFLOWER))));
                pLevel.m_7967_((Entity)Item2);
                return InteractionResult.SUCCESS;
            }
            if ((Integer)pState.m_61143_((Property)POTFLOWER) != 0) {
                if (playerStack.m_41619_()) {
                    pPlayer.m_21008_(pHand, new ItemStack((ItemLike)validFlowers.get((Integer)pState.m_61143_((Property)POTFLOWER)), (Boolean)pState.m_61143_((Property)GROWN) != false ? 2 : 1));
                    pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)POTFLOWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_11766_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (playerStack.m_150930_(validFlowers.get((Integer)pState.m_61143_((Property)POTFLOWER))) && playerStack.m_41613_() < playerStack.m_41741_()) {
                    playerStack.m_41769_((Boolean)pState.m_61143_((Property)GROWN) != false ? 2 : 1);
                    pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)POTFLOWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false)), 3);
                    pLevel.m_5594_(null, pPos, SoundEvents.f_144073_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            for (Item flower : validFlowers) {
                if (!playerStack.m_41720_().equals(flower)) continue;
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POTFLOWER, (Comparable)Integer.valueOf(validFlowers.indexOf(flower))), 3);
                if (!flower.equals(Items.f_41852_)) {
                    pLevel.m_5594_(null, pPos, SoundEvents.f_144071_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!pPlayer.m_7500_()) {
                    playerStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{POTFLOWER, GROWN});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter getter, List<Component> component, TooltipFlag flag) {
        if (!Screen.m_96638_() && !Screen.m_96637_()) {
            component.add((Component)Component.m_237115_((String)"tooltip.shift").m_130940_(ChatFormatting.YELLOW));
            component.add((Component)Component.m_237115_((String)"tooltip.control").m_130940_(ChatFormatting.YELLOW));
        }
        if (Screen.m_96638_()) {
            component.add((Component)Component.m_237115_((String)"hanging_pot.description1").m_130940_(ChatFormatting.GRAY));
            component.add((Component)Component.m_237115_((String)"hanging_pot.description2").m_130940_(ChatFormatting.GRAY));
            component.add((Component)Component.m_237115_((String)"hanging_pot.description3").m_130940_(ChatFormatting.GRAY));
        }
        if (Screen.m_96637_()) {
            component.add((Component)Component.m_237115_((String)"hanging_pot.list1").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GRAY));
            component.add((Component)Component.m_237115_((String)"hanging_pot.list2").m_130940_(ChatFormatting.GRAY));
        }
        super.m_5871_(stack, getter, component, flag);
    }
}

