/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenSpellBook;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketSetSound {
    int castSlot;
    ConfiguredSpellSound sound;
    boolean mainHand;

    public PacketSetSound(int castSlot, ConfiguredSpellSound sound, boolean mainHand) {
        this.castSlot = castSlot;
        this.sound = sound;
        this.mainHand = mainHand;
    }

    public PacketSetSound(FriendlyByteBuf buf) {
        this.castSlot = buf.readInt();
        CompoundTag tag = buf.m_130260_();
        this.sound = tag == null ? ConfiguredSpellSound.DEFAULT : ConfiguredSpellSound.fromTag(tag);
        this.mainHand = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.castSlot);
        buf.m_130079_(this.sound.serialize());
        buf.writeBoolean(this.mainHand);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            if (((NetworkEvent.Context)ctx.get()).getSender() != null && (stack = ((NetworkEvent.Context)ctx.get()).getSender().m_21120_(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND)).m_41720_() instanceof SpellBook) {
                ISpellCaster caster = CasterUtil.getCaster(stack);
                caster.setSound(this.sound, this.castSlot);
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> PacketSetSound.lambda$handle$0((Supplier)ctx)), (Object)new PacketUpdateBookGUI(stack));
                Networking.INSTANCE.send(PacketDistributor.PLAYER.with(() -> PacketSetSound.lambda$handle$1((Supplier)ctx)), (Object)new PacketOpenSpellBook(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ ServerPlayer lambda$handle$1(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier ctx) {
        return ((NetworkEvent.Context)ctx.get()).getSender();
    }
}

