/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.rei;

import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.items.parts.FacadeItem;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultShapedDisplay;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;

class FacadeRegistryGenerator
implements DynamicDisplayGenerator<DefaultShapedDisplay> {
    private final FacadeItem itemFacade = AEItems.FACADE.m_5456_();
    private final ItemStack cableAnchor = AEParts.CABLE_ANCHOR.stack();

    FacadeRegistryGenerator() {
    }

    public Optional<List<DefaultShapedDisplay>> getRecipeFor(EntryStack<?> entry) {
        if (entry.getType() != VanillaEntryTypes.ITEM) {
            return Optional.empty();
        }
        ItemStack itemStack = (ItemStack)entry.castValue();
        Item item = itemStack.m_41720_();
        if (item instanceof FacadeItem) {
            FacadeItem facadeItem = (FacadeItem)item;
            ItemStack textureItem = facadeItem.getTextureItem(itemStack);
            return Optional.of(Collections.singletonList(this.make(textureItem, this.cableAnchor, itemStack.m_41777_())));
        }
        return Optional.empty();
    }

    public Optional<List<DefaultShapedDisplay>> getUsageFor(EntryStack<?> entry) {
        if (entry.getType() != VanillaEntryTypes.ITEM) {
            return Optional.empty();
        }
        ItemStack itemStack = (ItemStack)entry.castValue();
        itemStack = itemStack.m_41777_();
        itemStack.m_41764_(1);
        ItemStack facade = this.itemFacade.createFacadeForItem(itemStack, false);
        if (!facade.m_41619_()) {
            return Optional.of(Collections.singletonList(this.make(itemStack, this.cableAnchor, facade)));
        }
        return Optional.empty();
    }

    private DefaultShapedDisplay make(ItemStack textureItem, ItemStack cableAnchor, ItemStack result) {
        ResourceLocation id = AppEng.makeId("facade/" + Item.m_41393_((Item)textureItem.m_41720_()));
        NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        ingredients.set(1, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(3, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(5, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(7, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{cableAnchor}));
        ingredients.set(4, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{textureItem}));
        result.m_41764_(4);
        return new DefaultShapedDisplay(new ShapedRecipe(id, "", CraftingBookCategory.MISC, 3, 3, ingredients, result));
    }
}

