/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.parts;

import appeng.api.parts.IPart;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface IPartItem<P extends IPart>
extends ItemLike {
    public Class<P> getPartClass();

    public P createPart();

    public static ResourceLocation getId(IPartItem<?> item) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
        if (id == BuiltInRegistries.f_257033_.m_122315_()) {
            throw new IllegalStateException("Part item " + item + " is not registered");
        }
        return id;
    }

    public static int getNetworkId(IPartItem<?> item) {
        int id = BuiltInRegistries.f_257033_.m_7447_((Object)item.m_5456_());
        if (id == 0) {
            throw new IllegalStateException("Part item " + item + " is not registered");
        }
        return id;
    }

    @Nullable
    public static IPartItem<?> byId(ResourceLocation id) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
        if (item instanceof IPartItem) {
            IPartItem partItem = (IPartItem)item;
            return partItem;
        }
        return null;
    }

    @Nullable
    public static IPartItem<?> byNetworkId(int id) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7942_(id);
        if (item instanceof IPartItem) {
            IPartItem partItem = (IPartItem)item;
            return partItem;
        }
        return null;
    }
}

