/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.builderdog.ancient_aether.world.structure.AncientAetherStructureTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;

public class BuriedJigsawStructure
extends Structure {
    public static final Codec<BuriedJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuriedJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.optionalFieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)-4096, (int)4096).fieldOf("above_bottom").forGetter(structure -> structure.aboveBottom), (App)Codec.intRange((int)-4096, (int)4096).fieldOf("below_top").forGetter(structure -> structure.belowTop)).apply((Applicative)instance, BuriedJigsawStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final Optional<HeightProvider> startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final int aboveBottom;
    private final int belowTop;

    public BuriedJigsawStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, Optional<HeightProvider> startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, int aboveBottom, int belowTop) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.aboveBottom = aboveBottom;
        this.belowTop = belowTop;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        StructureTemplateManager templateManager;
        RandomState randomState;
        LevelHeightAccessor heightAccessor;
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        int height = BuriedJigsawStructure.findStartingHeight(chunkGenerator, heightAccessor = context.f_226629_(), chunkPos, randomState = context.f_226624_(), templateManager = context.f_226625_(), this.aboveBottom, this.belowTop);
        if (height <= heightAccessor.m_141937_()) {
            MutableInt y = new MutableInt(height);
            chunkPos = BuriedJigsawStructure.searchNearbyChunks(chunkPos, y, chunkGenerator, heightAccessor, randomState, templateManager, this.aboveBottom, this.belowTop);
            height = y.getValue();
            if (height <= heightAccessor.m_141937_()) {
                return Optional.empty();
            }
        }
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), height, chunkPos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    private static ChunkPos searchNearbyChunks(ChunkPos chunkPos, MutableInt height, ChunkGenerator generator, LevelHeightAccessor heightAccessor, RandomState randomState, StructureTemplateManager templateManager, int aboveBottom, int belowTop) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                ChunkPos offset;
                int y;
                if (x == 0 && z == 0 || (y = BuriedJigsawStructure.findStartingHeight(generator, heightAccessor, offset = new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z), randomState, templateManager, aboveBottom, belowTop)) <= heightAccessor.m_141937_()) continue;
                height.setValue(y);
                return offset;
            }
        }
        return chunkPos;
    }

    private static int findStartingHeight(ChunkGenerator generator, LevelHeightAccessor heightAccessor, ChunkPos chunkPos, RandomState random, StructureTemplateManager templateManager, int aboveBottom, int belowTop) {
        int minX = chunkPos.m_45604_() - 1;
        int minZ = chunkPos.m_45605_() - 1;
        int maxX = chunkPos.m_45608_() + 1;
        int maxZ = chunkPos.m_45609_() + 1;
        NoiseColumn[] columns = new NoiseColumn[]{generator.m_214184_(minX, minZ, heightAccessor, random), generator.m_214184_(minX, maxZ, heightAccessor, random), generator.m_214184_(maxX, minZ, heightAccessor, random), generator.m_214184_(maxX, maxZ, heightAccessor, random)};
        int roomHeight = BuriedJigsawStructure.checkRoomHeight(templateManager, new ResourceLocation("ancient_aether", "buried_jigsaw_spawn_radius"));
        int height = heightAccessor.m_141937_();
        int maxHeight = heightAccessor.m_151558_() - belowTop;
        int thickness = roomHeight + 16;
        int currentThickness = 0;
        for (int y = height + aboveBottom; y <= maxHeight; ++y) {
            if (BuriedJigsawStructure.checkEachCornerAtY(columns, y)) {
                ++currentThickness;
                continue;
            }
            if (currentThickness > thickness) {
                thickness = currentThickness;
                height = y;
            }
            currentThickness = 0;
        }
        int offset = (thickness + roomHeight) / 2;
        return height -= offset;
    }

    private static int checkRoomHeight(StructureTemplateManager manager, ResourceLocation roomName) {
        StructureTemplate template = manager.m_230359_(roomName);
        return template.m_163801_().m_123342_();
    }

    private static boolean checkEachCornerAtY(NoiseColumn[] columns, int y) {
        for (NoiseColumn column : columns) {
            if (!column.m_183556_(y).m_60795_() && !column.m_183556_(y).m_204336_(AetherTags.Blocks.NON_BRONZE_DUNGEON_SPAWNABLE)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public BoundingBox m_226569_(@NotNull BoundingBox box) {
        return box;
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return (StructureType)AncientAetherStructureTypes.BURIED_JIGSAW.get();
    }
}

