/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.entity.monster.boss;

import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.PacketRelay;
import net.builderdog.ancient_aether.AncientAetherConfig;
import net.builderdog.ancient_aether.block.AncientAetherBlocks;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.builderdog.ancient_aether.entity.monster.boss.AncientAetherBossNameGenerator;
import net.builderdog.ancient_aether.entity.projectile.MutatedAechorNeedle;
import net.builderdog.ancient_aether.entity.projectile.RemedyCrystal;
import net.builderdog.ancient_aether.entity.projectile.SporeBomb;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutatedAechorPlant
extends PathfinderMob
implements AetherBossMob<MutatedAechorPlant>,
Enemy,
IEntityAdditionalSpawnData,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE_ID = SynchedEntityData.m_135353_(MutatedAechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SIZE_ID = SynchedEntityData.m_135353_(MutatedAechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Component> DATA_BOSS_NAME_ID = SynchedEntityData.m_135353_(MutatedAechorPlant.class, (EntityDataSerializer)EntityDataSerializers.f_135031_);
    private float sinage;
    private float sinageAdd;
    private final ServerBossEvent bossFight;
    @Nullable
    private BossRoomTracker<MutatedAechorPlant> laboratoryDungeon;

    public MutatedAechorPlant(EntityType<? extends MutatedAechorPlant> type, Level level) {
        super(type, level);
        this.f_21364_ = 50;
        this.bossFight = new ServerBossEvent(this.getBossName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.setBossFight(false);
        this.m_21530_();
        if (level.m_5776_()) {
            this.sinage = this.m_217043_().m_188501_() * 6.0f;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 16.0f));
        this.f_21345_.m_25352_(1, (Goal)new SpawnEntityGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> this.isBossFight()));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6135_() {
    }

    public boolean m_6573_(@NotNull Player player) {
        return false;
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_();
    }

    protected boolean m_7341_(@NotNull Entity vehicle) {
        return false;
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(DATA_SIZE_ID);
    }

    public void setSize(int size) {
        this.m_20088_().m_135381_(DATA_SIZE_ID, (Object)size);
    }

    public float getSinage() {
        return this.sinage;
    }

    public float getSinageAdd() {
        return this.sinageAdd;
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return size.f_20378_ / 1.15f;
    }

    public double m_6049_() {
        return this.m_20202_() != null && this.m_20202_().m_6047_() ? 0.1 : 0.275;
    }

    public void m_6043_() {
    }

    public boolean isCritical() {
        return this.m_21223_() < 250.0f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8119_();
        if (!this.isActive() || (livingEntity = this.m_5448_()) instanceof Player && (!(player = (Player)livingEntity).m_7500_() || !player.m_5833_())) {
            this.m_6710_(null);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_()) {
            this.sinage += this.sinageAdd;
            this.sinageAdd = this.f_20916_ > 0 ? 0.45f : (this.isActive() ? 0.3f : 0.15f);
            if (this.sinage >= (float)Math.PI * 2) {
                this.sinage -= (float)Math.PI * 2;
            }
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            super.m_6469_(source, amount);
        } else {
            Entity entity = source.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                if (this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                    if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((Entity)attacker)) {
                        if (super.m_6469_(source, amount) && this.m_21223_() > 0.0f) {
                            if (!this.isBossFight()) {
                                this.start();
                            }
                            return true;
                        }
                    } else if (!this.m_9236_().m_5776_() && attacker instanceof Player) {
                        Player player = (Player)attacker;
                        this.displayTooFarMessage(player);
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public void m_6667_(@NotNull DamageSource source) {
        this.m_20256_(Vec3.f_82478_);
        if (this.m_9236_() instanceof ServerLevel) {
            this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.m_6667_(source);
    }

    public void m_6504_(@NotNull LivingEntity target, float distanceFactor) {
        SporeBomb sporeBomb = new SporeBomb(this.m_9236_(), (LivingEntity)this);
        MutatedAechorNeedle needle = new MutatedAechorNeedle(this.m_9236_(), (LivingEntity)this);
        if (this.isActive()) {
            if (RandomSource.m_216327_().m_188503_(2) == 0) {
                this.shootProjectile(target, (Projectile)sporeBomb, (SoundEvent)AncientAetherSoundEvents.ENTITY_MUTATED_AECHOR_PLANT_SHOOT_SPORE_BOMB.get());
            } else {
                this.shootProjectile(target, (Projectile)needle, (SoundEvent)AncientAetherSoundEvents.ENTITY_MUTATED_AECHOR_PLANT_SHOOT_NEEDLE.get());
            }
        }
    }

    private void shootProjectile(@NotNull LivingEntity target, Projectile projectile, SoundEvent sound) {
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.75) - projectile.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(Mth.m_144952_((double)d0) + Mth.m_144952_((double)d2))));
        projectile.m_6686_(d0, d1 + d3 * 0.2, d2, 1.0f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(sound, 2.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)projectile);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.setBossName((Component)AncientAetherBossNameGenerator.generateMutatedAechorName(this.m_217043_()));
        this.m_146884_(Vec3.m_82539_((Vec3i)this.m_20183_()));
        return spawnData;
    }

    public boolean m_142582_(@NotNull Entity entity) {
        return (double)this.m_20270_(entity) <= 8.0 && super.m_142582_(entity);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() != AetherEffects.INEBRIATION.get() && super.m_7301_(effect);
    }

    public void evaporateEffects(MutatedAechorPlant entity, BlockPos pos) {
        super.evaporateEffects((Mob)entity, pos);
    }

    public boolean isActive() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ACTIVE_ID);
    }

    public void setActive(boolean active) {
        this.m_20088_().m_135381_(DATA_ACTIVE_ID, (Object)active);
    }

    @Nullable
    public ResourceLocation getBossBarTexture() {
        return (Boolean)AncientAetherConfig.CLIENT.custom_boss_bars.get() != false ? new ResourceLocation("ancient_aether", "textures/gui/boss_bar_mutated_aechor_plant_custom.png") : new ResourceLocation("ancient_aether", "textures/gui/boss_bar_mutated_aechor_plant.png");
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossFight.m_142711_(this.m_21223_() / this.m_21233_());
        this.trackDungeon();
    }

    public Component getBossName() {
        return (Component)this.m_20088_().m_135370_(DATA_BOSS_NAME_ID);
    }

    public void setBossName(Component component) {
        this.m_20088_().m_135381_(DATA_BOSS_NAME_ID, (Object)component);
        this.bossFight.m_6456_(component);
    }

    public boolean isBossFight() {
        return this.bossFight.m_8323_();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.m_8321_(isFighting);
    }

    @Nullable
    public BossRoomTracker<MutatedAechorPlant> getDungeon() {
        return this.laboratoryDungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<MutatedAechorPlant> dungeon) {
        this.laboratoryDungeon = dungeon;
    }

    public int getDeathScore() {
        return this.f_20897_;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.setBossName(name);
    }

    private void start() {
        this.setActive(true);
        this.setBossFight(true);
        if (this.getDungeon() != null) {
            this.closeRoom();
        }
        AetherEventDispatch.onBossFightStart((Entity)this, this.getDungeon());
    }

    public void reset() {
        this.setActive(false);
        this.setBossFight(false);
        this.m_6710_(null);
        this.m_21153_(this.m_21233_());
        if (this.getDungeon() != null) {
            this.m_146884_(this.getDungeon().originCoordinates());
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((Entity)this, this.getDungeon());
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Display(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((Player)player)) {
            this.bossFight.m_6543_(player);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), (ServerPlayer)player);
        }
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new BossInfoPacket.Remove(this.bossFight.m_18860_(), this.m_19879_()), (ServerPlayer)player);
        this.bossFight.m_6539_(player);
        AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), (ServerPlayer)player);
    }

    public void onDungeonPlayerAdded(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6543_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((Entity)this, this.getDungeon(), (ServerPlayer)serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.bossFight.m_6539_(serverPlayer);
            AetherEventDispatch.onBossFightPlayerRemove((Entity)this, this.getDungeon(), (ServerPlayer)serverPlayer);
        }
    }

    public void tearDownRoom() {
        super.tearDownRoom();
    }

    @Nullable
    public BlockState convertBlock(BlockState state) {
        if (state.m_60713_((Block)AetherBlocks.LOCKED_CARVED_STONE.get())) {
            return ((Block)AetherBlocks.CARVED_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AncientAetherBlocks.LOCKED_CARVED_STONE_MOSAIC.get())) {
            return (BlockState)((RotatedPillarBlock)AncientAetherBlocks.CARVED_STONE_MOSAIC.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)));
        }
        if (state.m_60713_((Block)AncientAetherBlocks.LOCKED_WYND_SENTRY_STONE.get())) {
            return ((Block)AncientAetherBlocks.WYND_SENTRY_STONE.get()).m_49966_();
        }
        if (state.m_60713_((Block)AncientAetherBlocks.BOSS_DOORWAY_CARVED_STONE.get()) || state.m_60713_((Block)AetherBlocks.TREASURE_DOORWAY_CARVED_STONE.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        if (state.m_60713_((Block)AncientAetherBlocks.BOSS_DOORWAY_WYND_SENTRY_STONE.get()) || state.m_60713_((Block)AncientAetherBlocks.TREASURE_DOORWAY_WYND_SENTRY_STONE.get())) {
            return Blocks.f_50016_.m_49966_();
        }
        return null;
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Active", this.isActive());
        tag.m_128405_("Size", this.getSize());
        this.addBossSaveData(tag);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Active")) {
            this.setActive(tag.m_128471_("Active"));
        }
        if (tag.m_128441_("Size")) {
            this.setSize(tag.m_128451_("Size"));
        }
        this.readBossSaveData(tag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_ACTIVE_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_BOSS_NAME_ID, (Object)Component.m_237113_((String)"Mutated Aechor Plant"));
        this.m_20088_().m_135372_(DATA_SIZE_ID, (Object)0);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> dataAccessor) {
        if (DATA_SIZE_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        CompoundTag tag = new CompoundTag();
        this.addBossSaveData(tag);
        buffer.m_130079_(tag);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        CompoundTag tag = additionalData.m_130260_();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_MUTATED_AECHOR_PLANT_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_MUTATED_AECHOR_PLANT_DEATH.get();
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public static class SpawnEntityGoal
    extends Goal {
        private final MutatedAechorPlant aechor;
        private int spawnInterval;

        public SpawnEntityGoal(MutatedAechorPlant mutatedAechorPlant) {
            this.aechor = mutatedAechorPlant;
            this.spawnInterval = (int)((float)this.spawnDelay() + mutatedAechorPlant.m_21223_() / 2.0f);
        }

        public int spawnDelay() {
            return this.aechor.isCritical() ? 20 : 40;
        }

        public boolean m_8036_() {
            return this.aechor.isBossFight() && --this.spawnInterval <= 0;
        }

        public void m_8056_() {
            if (this.aechor.isCritical()) {
                this.spawnEntityCritical();
            } else {
                this.spawnEntity();
            }
            this.spawnInterval = (int)(15.0f + this.aechor.m_21223_() / 2.0f);
        }

        public void spawnEntity() {
            RemedyCrystal crystal = new RemedyCrystal(this.aechor.m_9236_(), (Entity)this.aechor);
            this.aechor.m_9236_().m_7967_((Entity)crystal);
        }

        public void spawnEntityCritical() {
            if (RandomSource.m_216327_().m_188503_(2) == 0) {
                Cockatrice cockatrice = new Cockatrice((EntityType)AetherEntityTypes.COCKATRICE.get(), this.aechor.m_9236_());
                cockatrice.m_6034_(this.aechor.m_20185_(), this.aechor.m_20186_() + 3.0, this.aechor.m_20189_());
                this.aechor.m_9236_().m_7967_((Entity)cockatrice);
            } else {
                this.spawnEntity();
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

