/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.entity.monster;

import com.aetherteam.aether.block.AetherBlocks;
import javax.annotation.Nonnull;
import net.builderdog.ancient_aether.AncientAetherTags;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.builderdog.ancient_aether.entity.monster.AeronauticLeaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Slammroot
extends Slime {
    public Slammroot(EntityType<? extends Slammroot> entity, Level level) {
        super(entity, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Slime.SlimeFloatGoal((Slime)this));
        this.f_21345_.m_25352_(2, (Goal)new Slime.SlimeAttackGoal((Slime)this));
        this.f_21345_.m_25352_(3, (Goal)new Slime.SlimeRandomDirectionGoal((Slime)this));
        this.f_21345_.m_25352_(5, (Goal)new Slime.SlimeKeepOnJumpingGoal((Slime)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0));
    }

    @Nonnull
    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    public void m_7839_(int size, boolean resetHealth) {
    }

    public void m_142687_(@Nonnull Entity.RemovalReason reason) {
        this.m_142467_(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            this.m_146850_(GameEvent.f_223707_);
        }
        this.invalidateCaps();
    }

    protected boolean m_7483_() {
        return this.m_21515_();
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnData, @javax.annotation.Nullable CompoundTag tag) {
        this.m_7839_(1, true);
        this.m_21559_(false);
        return spawnData;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, 0.75, vec3.f_82481_);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = level.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.m_6018_().m_46470_() ? level.m_46849_(pos, 10) : level.m_46803_(pos);
        return j <= dimensiontype.m_223569_().m_214085_(random);
    }

    public void m_6123_(@NotNull Player entity) {
        if (this.m_7483_()) {
            this.m_33637_((LivingEntity)entity);
        }
    }

    protected void m_33637_(@NotNull LivingEntity entity) {
        if (this.m_6084_()) {
            int i = this.m_33632_();
            if (this.m_20280_((Entity)entity) < 1.2 * (double)i * 1.2 * (double)i && this.m_142582_((Entity)entity) && entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.m_7566_())) {
                this.m_19970_((LivingEntity)this, (Entity)entity);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                return;
            }
            for (int i = 0; i < 4; ++i) {
                Level level;
                int j = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(i % 2 * 2 - 1) * 0.25f)));
                int k = Mth.m_14107_((double)this.m_20186_());
                int l = Mth.m_14107_((double)(this.m_20189_() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f)));
                BlockPos pos = new BlockPos(j, k, l);
                BlockPos posBelow = new BlockPos(j, k - 1, l);
                Block block = this.m_9236_().m_8055_(posBelow).m_60734_();
                if (!(block instanceof BonemealableBlock) || !this.m_9236_().m_46859_(pos) || !((level = this.m_9236_()) instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                ((BonemealableBlock)block).m_214148_(serverLevel, this.m_9236_().m_213780_(), posBelow, this.m_9236_().m_8055_(posBelow));
            }
        }
    }

    public static boolean checkSlammrootSpawnRules(EntityType<? extends Slammroot> slammroot, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(slammroot, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && Slammroot.isDarkEnoughToSpawn(level, pos, random) && !level.m_8055_(pos.m_7495_()).m_204336_(AncientAetherTags.Blocks.SLAMMROOT_SPAWNABLE_BLACKLIST) && level.m_46791_() != Difficulty.PEACEFUL && (reason != MobSpawnType.NATURAL || random.m_188503_(3) == 0);
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_SLAMMROOT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_SLAMMROOT_DEATH.get();
    }

    @NotNull
    protected SoundEvent m_7905_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_SLAMMROOT_JUMP.get();
    }

    @NotNull
    protected SoundEvent m_7903_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_SLAMMROOT_JUMP.get();
    }

    @Nonnull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return super.m_6972_(pose).m_20388_(1.758f);
    }

    @NotNull
    protected ParticleOptions m_6300_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, ((Block)AetherBlocks.AETHER_DIRT.get()).m_49966_());
    }

    @Nonnull
    public EntityType<? extends AeronauticLeaper> m_6095_() {
        return super.m_6095_();
    }

    protected boolean m_8028_() {
        return true;
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return this.m_6095_().m_20677_();
    }
}

