/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.capability.player;

import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.builderdog.ancient_aether.capability.player.AncientAetherPlayer;
import net.builderdog.ancient_aether.item.EquipmentUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Triple;

public class AncientAetherPlayerCapability
implements AncientAetherPlayer {
    private final Player player;
    private int aeronauticDartCount;
    private int wingRotationO;
    private int wingRotation;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setGravititeDartCount", Triple.of((Object)INBTSynchable.Type.INT, object -> this.setAeronauticDartCount((Integer)object), this::getAeronauticDartCount)));

    public AncientAetherPlayerCapability(Player player) {
        this.player = player;
    }

    @Override
    public void onUpdate() {
        this.handleWingRotation();
    }

    private void handleWingRotation() {
        if (this.getPlayer().m_9236_().m_5776_()) {
            this.wingRotationO = this.getWingRotation();
            this.wingRotation = EquipmentUtil.hasFullValkyrumSet((LivingEntity)this.getPlayer()) ? this.getPlayer().f_19797_ : 0;
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public int getWingRotationO() {
        return this.wingRotationO;
    }

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    @Override
    public void setAeronauticDartCount(int count) {
        this.aeronauticDartCount = count;
    }

    @Override
    public int getAeronauticDartCount() {
        return this.aeronauticDartCount;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new AetherPlayerSyncPacket(this.getPlayer().m_19879_(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return AetherPacketHandler.INSTANCE;
    }
}

