/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.block.blocktype;

import javax.annotation.Nullable;
import net.builderdog.ancient_aether.block.blockstate.AncientAetherBlockStateProperties;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.builderdog.ancient_aether.item.AncientAetherItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;

public class GrapeVineBlock
extends Block
implements BonemealableBlock {
    public static final BooleanProperty CROPPED = AncientAetherBlockStateProperties.CROPPED;
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final DirectionProperty FACING = LadderBlock.f_54337_;
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public GrapeVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CROPPED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            default -> EAST_AABB;
        };
    }

    private boolean canAttachTo(BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState blockstate = getter.m_8055_(pos);
        return blockstate.m_60783_(getter, pos, direction);
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)level, pos.m_121945_(direction.m_122424_()), direction);
    }

    @NotNull
    public BlockState m_7417_(BlockState thisState, Direction direction, @NotNull BlockState state, @NotNull LevelAccessor accessor, @NotNull BlockPos thisPos, @NotNull BlockPos pos) {
        if (direction.m_122424_() == thisState.m_61143_((Property)FACING) && !thisState.m_60710_((LevelReader)accessor, thisPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(thisState, direction, state, accessor, thisPos, pos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state;
        if (!context.m_7058_() && (state = context.m_43725_().m_8055_(context.m_8083_().m_121945_(context.m_43719_().m_122424_()))).m_60713_((Block)this) && state.m_61143_((Property)FACING) == context.m_43719_()) {
            return null;
        }
        state = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction direction : context.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 2 && (Boolean)state.m_61143_((Property)CROPPED) == false;
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)AncientAetherItems.GRAPES.get());
    }

    public void m_213898_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 2 && level.m_45524_(pos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, blockstate, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl = flag = i == 2;
        if (!flag && player.m_21120_(hand).m_150930_(Items.f_42499_) && player.m_21120_(hand).canPerformAction(ToolActions.SHEARS_CARVE)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.f_46441_.m_188503_(1);
            GrapeVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)AncientAetherItems.GRAPES.get(), j + (flag ? 1 : 0)));
            BlockState age = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, age, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)age));
            level.m_5594_(null, pos, (SoundEvent)AncientAetherSoundEvents.BLOCK_GRAPE_VINE_PICK_GRAPES.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (player.m_21120_(hand).canPerformAction(ToolActions.SHEARS_CARVE) && !((Boolean)state.m_61143_((Property)CROPPED)).booleanValue()) {
            level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
            BlockState cut = (BlockState)state.m_61124_((Property)CROPPED, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, cut, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)cut));
            level.m_5594_(null, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public boolean m_7370_(@NotNull LevelReader reader, @NotNull BlockPos pos, BlockState state, boolean p_57263_) {
        return (Integer)state.m_61143_((Property)AGE) < 2;
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        int i = Math.min(2, (Integer)state.m_61143_((Property)AGE) + 1);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CROPPED}).m_61104_(new Property[]{AGE}).m_61104_(new Property[]{FACING});
    }
}

