/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether;

import com.aetherteam.aether.AetherConfig;
import java.nio.file.Path;
import net.builderdog.ancient_aether.AncientAetherConfig;
import net.builderdog.ancient_aether.advancement.AncientAetherAdvancementTriggers;
import net.builderdog.ancient_aether.block.AncientAetherBlocks;
import net.builderdog.ancient_aether.block.dispenser.DispenseAncientAetherBoatBehaviour;
import net.builderdog.ancient_aether.blockentity.AncientAetherBlockEntityTypes;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.builderdog.ancient_aether.client.gui.AncientAetherMenus;
import net.builderdog.ancient_aether.client.particle.AncientAetherParticleTypes;
import net.builderdog.ancient_aether.data.AncientAetherData;
import net.builderdog.ancient_aether.effect.AncientAetherEffects;
import net.builderdog.ancient_aether.entity.AncientAetherEntityTypes;
import net.builderdog.ancient_aether.entity.AncientAetherMoaTypes;
import net.builderdog.ancient_aether.item.AncientAetherItems;
import net.builderdog.ancient_aether.world.biome.AncientAetherRegion;
import net.builderdog.ancient_aether.world.biome.AncientAetherSurfaceRules;
import net.builderdog.ancient_aether.world.biomemodifier.AncientAetherBiomeModifierSerializers;
import net.builderdog.ancient_aether.world.feature.AncientAetherFeatures;
import net.builderdog.ancient_aether.world.foliageplacer.AncientAetherFoliagePlacers;
import net.builderdog.ancient_aether.world.processor.AncientAetherStructureProcessors;
import net.builderdog.ancient_aether.world.structure.AncientAetherStructureTypes;
import net.builderdog.ancient_aether.world.treedecorator.AncientAetherTreeDecoratorTypes;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import teamrazor.aeroblender.aether.AetherRuleCategory;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="ancient_aether")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AncientAether {
    public static final String MODID = "ancient_aether";

    public AncientAether() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(AncientAetherData::dataSetup);
        DeferredRegister[] registers = new DeferredRegister[]{AncientAetherBlocks.BLOCKS, AncientAetherItems.ITEMS, AncientAetherBlockEntityTypes.BLOCK_ENTITY_TYPES, AncientAetherEntityTypes.ENTITY_TYPES, AncientAetherMoaTypes.MOA_TYPES, AncientAetherEffects.EFFECTS, AncientAetherFeatures.FEATURES, AncientAetherFoliagePlacers.FOLIAGE_PLACERS, AncientAetherTreeDecoratorTypes.TREE_DECORATORS, AncientAetherBiomeModifierSerializers.BIOME_MODIFIER_SERIALIZERS, AncientAetherStructureTypes.STRUCTURE_TYPES, AncientAetherStructureProcessors.STRUCTURE_PROCESSOR_TYPES, AncientAetherSoundEvents.SOUNDS, AncientAetherParticleTypes.PARTICLES};
        MinecraftForge.EVENT_BUS.register((Object)this);
        for (DeferredRegister register : registers) {
            register.register(modEventBus);
        }
        DistExecutor.unsafeRunForDist(() -> () -> {
            AncientAetherMenus.MENUS.register(modEventBus);
            return true;
        }, () -> () -> false);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)AncientAetherConfig.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AncientAetherConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)AncientAetherConfig.CLIENT_SPEC);
        AncientAetherBlocks.registerWoodTypes();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AncientAetherBlocks.registerFuels();
            AncientAetherBlocks.registerPots();
            AncientAetherBlocks.registerFlammability();
            this.registerComposting();
            this.registerDispenserBehaviors();
            AncientAetherAdvancementTriggers.init();
            Regions.register((Region)new AncientAetherRegion(new ResourceLocation(MODID, MODID), (Integer)AncientAetherConfig.COMMON.ancient_aether_region_weight.get()));
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)AetherRuleCategory.THE_AETHER, (String)MODID, (SurfaceRules.RuleSource)AncientAetherSurfaceRules.makeRules());
        });
    }

    @SubscribeEvent
    public static void addPacks(AddPackFindersEvent event) {
        Pack pack;
        Path resourcePath;
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/ancient_aether_texture_tweaks"});
            pack = Pack.m_245429_((String)"builtin/ancient_aether_texture_tweaks", (Component)Component.m_237115_((String)"pack.ancient_aether.texture_tweaks.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/ancient_aether_programmer_art"});
            pack = Pack.m_245429_((String)"builtin/ancient_aether_programmer_art", (Component)Component.m_237115_((String)"pack.ancient_aether.programmer_art.title"), (boolean)false, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (event.getPackType() == PackType.SERVER_DATA) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/ancient_aether_worldgen_overrides"});
            pack = Pack.m_245429_((String)"builtin/ancient_aether_worldgen_overrides", (Component)Component.m_237115_((String)"pack.ancient_aether.worldgen_overrides.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10530_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (ModList.get().isLoaded("aether_emissivity") && event.getPackType() == PackType.CLIENT_RESOURCES) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compatibility/aether_emissivity"});
            pack = Pack.m_245429_((String)"builtin/compatibility/aether_emissivity", (Component)Component.m_237115_((String)"pack.ancient_aether.compatibility.aether_emissivity.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (ModList.get().isLoaded("aether_genesis") && event.getPackType() == PackType.SERVER_DATA) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compatibility/aether_genesis"});
            pack = Pack.m_245429_((String)"builtin/compatibility/aether_genesis", (Component)Component.m_237115_((String)"pack.ancient_aether.compatibility.aether_genesis.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10530_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (ModList.get().isLoaded("lost_aether_content") && event.getPackType() == PackType.SERVER_DATA) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compatibility/lost_aether_content"});
            pack = Pack.m_245429_((String)"builtin/compatibility/lost_aether_content", (Component)Component.m_237115_((String)"pack.ancient_aether.compatibility.lost_aether_content.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10530_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (ModList.get().isLoaded("aether_redux") && event.getPackType() == PackType.SERVER_DATA) {
            resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compatibility/aether_redux"});
            pack = Pack.m_245429_((String)"builtin/compatibility/aether_redux", (Component)Component.m_237115_((String)"pack.ancient_aether.compatibility.aether_redux.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10530_);
            event.addRepositorySource(consumer -> consumer.accept(pack));
        }
        if (ModList.get().isLoaded("deep_aether")) {
            if (event.getPackType() == PackType.SERVER_DATA) {
                resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compatibility/deep_aether"});
                pack = Pack.m_245429_((String)"builtin/compatibility/deep_aether", (Component)Component.m_237115_((String)"pack.ancient_aether.compatibility.deep_aether.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10530_);
                event.addRepositorySource(consumer -> consumer.accept(pack));
            }
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"packs/compatibility/deep_aether_assets"});
                pack = Pack.m_245429_((String)"builtin/compatibility/deep_aether_assets", (Component)Component.m_237115_((String)"pack.ancient_aether.compatibility.deep_aether_assets.title"), (boolean)true, path -> new PathPackResources(path, resourcePath, true), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                event.addRepositorySource(consumer -> consumer.accept(pack));
            }
        }
    }

    @SubscribeEvent
    public void serverSetup(ServerAboutToStartEvent event) {
        if (((Boolean)AncientAetherConfig.SERVER.server_config_overrides.get()).booleanValue()) {
            AetherConfig.SERVER.disable_eternal_day.set((Object)true);
        }
    }

    private void registerDispenserBehaviors() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AncientAetherItems.HIGHSPROOT_BOAT.get()), (DispenseItemBehavior)new DispenseAncientAetherBoatBehaviour());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AncientAetherItems.HIGHSPROOT_CHEST_BOAT.get()), (DispenseItemBehavior)new DispenseAncientAetherBoatBehaviour(true));
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AncientAetherItems.SAKURA_BOAT.get()), (DispenseItemBehavior)new DispenseAncientAetherBoatBehaviour());
        DispenserBlock.m_52672_((ItemLike)((ItemLike)AncientAetherItems.SAKURA_CHEST_BOAT.get()), (DispenseItemBehavior)new DispenseAncientAetherBoatBehaviour(true));
    }

    private void registerComposting() {
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.CRYSTAL_SKYROOT_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.ENCHANTED_SKYROOT_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.SKYROOT_PINE_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.BLUE_SKYROOT_PINE_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.HIGHSPROOT_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.SAKURA_LEAVES.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)AncientAetherBlocks.CRYSTAL_SKYROOT_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)AncientAetherBlocks.ENCHANTED_SKYROOT_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)AncientAetherBlocks.SKYROOT_PINE_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)((Block)AncientAetherBlocks.BLUE_SKYROOT_PINE_SAPLING.get()).m_5456_());
        this.addCompost(0.3f, (ItemLike)AncientAetherBlocks.HIGHSPROOT_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)AncientAetherBlocks.SAKURA_SAPLING.get());
        this.addCompost(0.3f, (ItemLike)AncientAetherBlocks.SKY_GRASS.get());
        this.addCompost(0.5f, (ItemLike)AncientAetherItems.GRAPES.get());
        this.addCompost(0.65f, (ItemLike)AncientAetherBlocks.SUNSET_ROSE.get());
        this.addCompost(0.65f, (ItemLike)AncientAetherBlocks.SKY_BLUES.get());
        this.addCompost(0.65f, (ItemLike)AncientAetherBlocks.WYND_THISTLE.get());
        this.addCompost(0.65f, (ItemLike)AncientAetherBlocks.ELEVETIA.get());
        this.addCompost(0.85f, (ItemLike)AncientAetherItems.SLAMMBERRY.get());
    }

    private void addCompost(float chance, ItemLike item) {
        ComposterBlock.f_51914_.put((Object)item.m_5456_(), chance);
    }
}

