/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.capability.lightning.LightningTracker;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public final class EntityUtil {
    public static void copyRotations(Entity entity, Entity source) {
        entity.m_146922_(Mth.m_14189_((float)0.33333334f, (float)source.m_146908_(), (float)source.f_19859_));
        entity.m_146926_(Mth.m_14189_((float)0.33333334f, (float)source.m_146909_(), (float)source.f_19860_));
        entity.m_5618_(Mth.m_14189_((float)0.33333334f, (float)source.m_146908_(), (float)source.f_19859_));
        entity.m_5616_(Mth.m_14189_((float)0.33333334f, (float)source.m_146908_(), (float)source.f_19859_));
    }

    public static void spawnMovementExplosionParticles(Entity entity) {
        RandomSource random = ((EntityAccessor)entity).aether$getRandom();
        double d0 = random.m_188583_() * 0.02;
        double d1 = random.m_188583_() * 0.02;
        double d2 = random.m_188583_() * 0.02;
        double d3 = 10.0;
        double x = entity.m_20185_() + (double)random.m_188501_() * (double)entity.m_20205_() * 2.0 - (double)entity.m_20205_() - d0 * d3;
        double y = entity.m_20186_() + (double)random.m_188501_() * (double)entity.m_20206_() - d1 * d3;
        double z = entity.m_20189_() + (double)random.m_188501_() * (double)entity.m_20205_() * 2.0 - (double)entity.m_20205_() - d2 * d3;
        entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, d0, d1, d2);
    }

    public static void spawnSummoningExplosionParticles(Entity entity) {
        RandomSource random = ((EntityAccessor)entity).aether$getRandom();
        for (int i = 0; i < 20; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            double d3 = 10.0;
            double x = entity.m_20165_(0.0) - d0 * d3;
            double y = entity.m_20187_() - d1 * d3;
            double z = entity.m_20262_(1.0) - d2 * d3;
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, d0, d1, d2);
        }
    }

    public static void spawnRemovalParticles(Level level, BlockPos pos) {
        double a = (double)pos.m_123341_() + 0.5 + (double)(level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.375;
        double b = (double)pos.m_123342_() + 0.5 + (double)(level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.375;
        double c = (double)pos.m_123343_() + 0.5 + (double)(level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.375;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, a, b, c, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void summonLightningFromProjectile(Projectile projectile) {
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(projectile.m_9236_());
        if (lightningBolt != null) {
            LightningTracker.get(lightningBolt).ifPresent(lightningTracker -> lightningTracker.setOwner(projectile.m_19749_()));
            lightningBolt.m_6034_(projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_());
            projectile.m_9236_().m_7967_((Entity)lightningBolt);
        }
    }

    public static boolean wholeHitboxCanSeeSky(LevelAccessor level, BlockPos pos, int hitboxRadius) {
        boolean flag = true;
        for (int xOffset = -hitboxRadius; xOffset <= hitboxRadius; ++xOffset) {
            for (int zOffset = -hitboxRadius; zOffset <= hitboxRadius; ++zOffset) {
                flag = flag && level.m_45527_(pos.m_7918_(xOffset, 0, zOffset));
            }
        }
        return flag;
    }
}

