/*
 * Decompiled with CFR 0.152.
 */
package teamrazor.aeroblender.mixin;

import java.util.function.LongFunction;
import net.minecraft.core.RegistryAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import teamrazor.aeroblender.AeroBlenderConfig;
import teamrazor.aeroblender.aether.AetherRegionType;
import terrablender.api.RegionType;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.InitialLayer;
import terrablender.worldgen.noise.LayeredNoiseUtil;
import terrablender.worldgen.noise.ZoomLayer;

@Mixin(value={LayeredNoiseUtil.class}, remap=false)
public abstract class LayeredNoiseUtilMixin {
    @Inject(at={@At(value="HEAD")}, method={"uniqueness"}, cancellable=true)
    private static void uniqueness(RegistryAccess registryAccess, RegionType regionType, long worldSeed, CallbackInfoReturnable<Area> cir) {
        if (regionType == AetherRegionType.THE_AETHER) {
            int numZooms1 = (Integer)AeroBlenderConfig.COMMON.aetherRegionSize.get();
            LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, worldSeed, seedModifier);
            AreaFactory factory = new InitialLayer(registryAccess, regionType).run(contextFactory.apply(1L));
            factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
            factory = LayeredNoiseUtilMixin.zoom(2001L, (AreaTransformer1)ZoomLayer.NORMAL, factory, 3, contextFactory);
            factory = LayeredNoiseUtilMixin.zoom(1001L, (AreaTransformer1)ZoomLayer.NORMAL, factory, numZooms1, contextFactory);
            cir.setReturnValue((Object)factory.make());
            cir.cancel();
        }
    }

    @Shadow
    public static AreaFactory zoom(long seedModifier, AreaTransformer1 transformer, AreaFactory initialAreaFactory, int times, LongFunction<AreaContext> contextFactory) {
        AreaFactory areaFactory = initialAreaFactory;
        for (int i = 0; i < times; ++i) {
            areaFactory = transformer.run(contextFactory.apply(seedModifier + (long)i), areaFactory);
        }
        return areaFactory;
    }
}

