/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.item;

import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.item.IZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.BooleanSuppliers;

public abstract class ZetaArrowItem
extends ArrowItem
implements IZetaItem {
    @Nullable
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public ZetaArrowItem(String name, @Nullable ZetaModule module) {
        super(new Item.Properties());
        this.module = module;
        if (module == null) {
            return;
        }
        module.zeta.registry.registerItem((Item)this, name);
        CreativeTabManager.addToCreativeTab((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256797_, (ItemLike)this);
    }

    @Override
    public ZetaArrowItem setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    public static class Impl
    extends ZetaArrowItem {
        private final ArrowCreator creator;

        public Impl(String name, ZetaModule module, ArrowCreator creator) {
            super(name, module);
            this.creator = creator;
        }

        public AbstractArrow m_6394_(Level p_40513_, ItemStack p_40514_, LivingEntity p_40515_) {
            return this.creator.createArrow(p_40513_, p_40514_, p_40515_);
        }

        public static interface ArrowCreator {
            public AbstractArrow createArrow(Level var1, ItemStack var2, LivingEntity var3);
        }
    }
}

