/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.module.ZetaModule;

public class BalancedDietModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET = new ResourceLocation("husbandry/balanced_diet");
    private final Set<ItemLike> items;

    public BalancedDietModifier(ZetaModule module, Set<ItemLike> items) {
        super(module);
        this.items = items;
        Preconditions.checkArgument((!items.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv) {
        ItemLike[] array = (ItemLike[])this.items.toArray(ItemLike[]::new);
        Criterion criterion = new Criterion((CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_148081_((ItemPredicate)ItemPredicate.Builder.m_45068_().m_151445_(array).m_45077_()));
        String name = BuiltInRegistries.f_257033_.m_7981_((Object)array[0].m_5456_()).toString();
        adv.addRequiredCriterion(name, criterion);
        return true;
    }
}

