/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.world.modifiers;

import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.RegistryLookups;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class VEAndedMultiBiomeModifier
implements BiomeModifier {
    private AtomicReference<List<TagKey<Biome>>> whitelistedBiomeKeycache = new AtomicReference(new ArrayList());
    private AtomicReference<List<TagKey<Biome>>> blacklistedBiomeKeycache = new AtomicReference(new ArrayList());
    private String whitelistedBiome;
    private String blacklistedBiome;
    private Holder<ConfiguredFeature<?, ?>> feature;
    private boolean isTriangualar;
    private int count;
    private int bottomAnchor;
    private int topAnchor;
    private int rarity;
    private String generationStep;

    public VEAndedMultiBiomeModifier(String whitelistedBiome, String blacklistedBiome, Holder<ConfiguredFeature<?, ?>> feature, boolean isTriangualar, int count, int bottomAnchor, int topAnchor, int rarity, String generationStep) {
        this.whitelistedBiome = whitelistedBiome;
        this.blacklistedBiome = blacklistedBiome;
        this.feature = feature;
        this.isTriangualar = isTriangualar;
        this.count = count;
        this.bottomAnchor = bottomAnchor;
        this.topAnchor = topAnchor;
        this.rarity = rarity;
        this.generationStep = generationStep;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.ADD) {
            return;
        }
        if (this.whitelistedBiomeKeycache.get().isEmpty()) {
            this.whitelistCacheBuilder();
        }
        if (this.blacklistedBiomeKeycache.get().isEmpty()) {
            this.blacklistCacheBuilder();
        }
        if (biome.getTagKeys().filter(b -> this.whitelistedBiomeKeycache.get().contains(b)).count() != (long)this.whitelistedBiomeKeycache.get().size()) {
            return;
        }
        if (biome.getTagKeys().anyMatch(b -> this.blacklistedBiomeKeycache.get().contains(b))) {
            return;
        }
        if (((Boolean)Config.WORLD_GEN_LOGGING.get()).booleanValue()) {
            VoluminousEnergy.LOGGER.info("Voluminous Energy has received a successful biome modify event. ");
            VoluminousEnergy.LOGGER.info("Biome is: " + RegistryLookups.lookupBiome((Biome)biome.m_203334_()));
            VoluminousEnergy.LOGGER.info("Biome Keys of biome in question: ");
            biome.getTagKeys().forEach(key -> System.out.print(key.toString() + ", "));
            VoluminousEnergy.LOGGER.info("\nWhitelisted Keys for this AND rule: ");
            this.whitelistedBiomeKeycache.get().forEach(key -> System.out.print(key.toString() + ", "));
            System.out.println();
        }
        List oreConfiguration = ((ConfiguredFeature)this.feature.get()).m_65398_().toList();
        Holder modifiedFeature = this.isTriangualar ? Holder.m_205709_((Object)new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)oreConfiguration.get(0))), List.of(HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)this.bottomAnchor), (VerticalAnchor)VerticalAnchor.m_158922_((int)this.topAnchor)), CountPlacement.m_191628_((int)this.count), RarityFilter.m_191900_((int)this.rarity), InSquarePlacement.m_191715_()))) : Holder.m_205709_((Object)new PlacedFeature(Holder.m_205709_((Object)((ConfiguredFeature)oreConfiguration.get(0))), List.of(HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)this.bottomAnchor), (VerticalAnchor)VerticalAnchor.m_158922_((int)this.topAnchor)), CountPlacement.m_191628_((int)this.count), RarityFilter.m_191900_((int)this.rarity), InSquarePlacement.m_191715_())));
        builder.getGenerationSettings().m_255419_(this.getGenerationStepDecoration(), modifiedFeature);
    }

    public void whitelistCacheBuilder() {
        if (this.whitelistedBiome.contains(",")) {
            ((Stream)Arrays.stream(this.whitelistedBiome.split(",")).sequential()).forEach(greenBiome -> {
                TagKey biomeTag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation(greenBiome));
                this.whitelistedBiomeKeycache.get().add((TagKey<Biome>)biomeTag);
            });
        } else if (!this.whitelistedBiome.isEmpty()) {
            TagKey biomeTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation(this.whitelistedBiome));
            this.whitelistedBiomeKeycache.get().add((TagKey<Biome>)biomeTagKey);
        }
    }

    public void blacklistCacheBuilder() {
        if (this.blacklistedBiome.contains(",")) {
            ((Stream)Arrays.stream(this.blacklistedBiome.split(",")).sequential()).forEach(redBiome -> {
                TagKey biomeTag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation(redBiome));
                this.blacklistedBiomeKeycache.get().add((TagKey<Biome>)biomeTag);
            });
        } else if (!this.blacklistedBiome.isEmpty()) {
            TagKey biomeTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)new ResourceLocation(this.blacklistedBiome));
            this.blacklistedBiomeKeycache.get().add((TagKey<Biome>)biomeTagKey);
        }
    }

    public String getWhitelistedBiome() {
        return this.whitelistedBiome;
    }

    public String getBlacklistedBiome() {
        return this.blacklistedBiome;
    }

    public Holder<ConfiguredFeature<?, ?>> getFeature() {
        return this.feature;
    }

    public boolean getIsTriangular() {
        return this.isTriangualar;
    }

    public int getCount() {
        return this.count;
    }

    public int getBottomAnchor() {
        return this.bottomAnchor;
    }

    public int getTopAnchor() {
        return this.topAnchor;
    }

    public int getRarity() {
        return this.rarity;
    }

    public String getGenerationStep() {
        return this.generationStep;
    }

    public GenerationStep.Decoration getGenerationStepDecoration() {
        if (this.generationStep.equals("raw_generation")) {
            return GenerationStep.Decoration.RAW_GENERATION;
        }
        if (this.generationStep.equals("lakes")) {
            return GenerationStep.Decoration.LAKES;
        }
        if (this.generationStep.equals("local_modifications")) {
            return GenerationStep.Decoration.LOCAL_MODIFICATIONS;
        }
        if (this.generationStep.equals("underground_structures")) {
            return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
        }
        if (this.generationStep.equals("surface_structures")) {
            return GenerationStep.Decoration.SURFACE_STRUCTURES;
        }
        if (this.generationStep.equals("strongholds")) {
            return GenerationStep.Decoration.STRONGHOLDS;
        }
        if (this.generationStep.equals("underground_ores")) {
            return GenerationStep.Decoration.UNDERGROUND_ORES;
        }
        if (this.generationStep.equals("underground_decoration")) {
            return GenerationStep.Decoration.UNDERGROUND_DECORATION;
        }
        if (this.generationStep.equals("fluid_springs")) {
            return GenerationStep.Decoration.FLUID_SPRINGS;
        }
        if (this.generationStep.equals("vegetal_decoration")) {
            return GenerationStep.Decoration.VEGETAL_DECORATION;
        }
        if (this.generationStep.equals("top_layer_modification")) {
            return GenerationStep.Decoration.TOP_LAYER_MODIFICATION;
        }
        throw new JsonSyntaxException("Invalid JSON syntax for generation step: " + this.generationStep + ". Generation step can only be: " + GenerationStep.Decoration.values());
    }

    public Codec<? extends BiomeModifier> codec() {
        return null;
    }
}

