/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.veteam.voluminousenergy.tools.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class VEOreDepositFeature
extends Feature<Configuration> {
    public VEOreDepositFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        return this.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), context.m_159777_(), (Configuration)context.m_159778_());
    }

    protected boolean place(WorldGenLevel worldIn, ChunkGenerator generator, RandomSource rand, BlockPos pos, Configuration conf) {
        if (worldIn.m_45527_(pos) && ((Boolean)Config.PREVENT_SURFACE_ORE_DEPOSITS.get()).booleanValue()) {
            return false;
        }
        BlockState rawState = conf.raw_block_state().m_213972_(rand, pos);
        BlockState oreState = conf.ore_block_state.m_213972_(rand, pos);
        pos = pos.m_6625_(4);
        boolean[] aboolean = new boolean[2048];
        int i = rand.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.m_188500_() * 6.0 + 3.0;
            double d1 = rand.m_188500_() * 4.0 + 2.0;
            double d2 = rand.m_188500_() * 6.0 + 3.0;
            double d3 = rand.m_188500_() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.m_188500_() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.m_188500_() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    BlockState material = worldIn.m_8055_(pos.m_7918_(k1, k, l2));
                    if (k >= 4 && material.m_278721_()) {
                        return false;
                    }
                    if (k >= 4 || material.m_280296_() || worldIn.m_8055_(pos.m_7918_(k1, k, l2)) == rawState) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    worldIn.m_7731_(pos.m_7918_(l1, i4, i3), rawState, 2);
                }
            }
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int j4 = 4; j4 < 8; ++j4) {
                    BlockPos blockpos;
                    if (!aboolean[(i2 * 16 + j3) * 8 + j4] || !VEOreDepositFeature.m_159759_((BlockState)worldIn.m_8055_(blockpos = pos.m_7918_(i2, j4 - 1, j3))) || worldIn.m_45517_(LightLayer.SKY, pos.m_7918_(i2, j4, j3)) <= 0) continue;
                    Holder biome = worldIn.m_204166_(blockpos);
                    if (biome.m_203565_(Biomes.f_48215_)) {
                        worldIn.m_7731_(blockpos, Blocks.f_50195_.m_49966_(), 2);
                        continue;
                    }
                    worldIn.m_7731_(blockpos, Blocks.f_50440_.m_49966_(), 2);
                }
            }
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int k3 = 0; k3 < 16; ++k3) {
                for (int k4 = 0; k4 < 8; ++k4) {
                    boolean flag1;
                    boolean bl = flag1 = !aboolean[(j2 * 16 + k3) * 8 + k4] && (j2 < 15 && aboolean[((j2 + 1) * 16 + k3) * 8 + k4] || j2 > 0 && aboolean[((j2 - 1) * 16 + k3) * 8 + k4] || k3 < 15 && aboolean[(j2 * 16 + k3 + 1) * 8 + k4] || k3 > 0 && aboolean[(j2 * 16 + (k3 - 1)) * 8 + k4] || k4 < 7 && aboolean[(j2 * 16 + k3) * 8 + k4 + 1] || k4 > 0 && aboolean[(j2 * 16 + k3) * 8 + (k4 - 1)]);
                    if (!flag1 || k4 >= 4 && rand.m_188503_(2) == 0 || !worldIn.m_8055_(pos.m_7918_(j2, k4, k3)).m_280296_()) continue;
                    worldIn.m_7731_(pos.m_7918_(j2, k4, k3), oreState, 2);
                }
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider ore_block_state, BlockStateProvider raw_block_state) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(configurationInstance -> configurationInstance.group((App)BlockStateProvider.f_68747_.fieldOf("ore_block_state").forGetter(Configuration::ore_block_state), (App)BlockStateProvider.f_68747_.fieldOf("raw_block_state").forGetter(Configuration::raw_block_state)).apply((Applicative)configurationInstance, Configuration::new));
    }
}

