/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util.randoms;

import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.apache.commons.io.Charsets;

public class JavaSecureRandomSource
implements RandomSource {
    private SecureRandom randomNumberGenerator;
    private final MarsagliaPolarGaussian gaussianSource = new MarsagliaPolarGaussian((RandomSource)this);

    public JavaSecureRandomSource(byte[] seed) {
        this.randomNumberGenerator = new SecureRandom(seed);
    }

    public JavaSecureRandomSource(long seed) {
        this.randomNumberGenerator = new SecureRandom(JavaSecureRandomSource.longToByte(seed));
    }

    public RandomSource m_213769_() {
        return new JavaSecureRandomSource(this.randomNumberGenerator.nextLong());
    }

    public PositionalRandomFactory m_188582_() {
        return new JavaSecureRandomPositionalRandomFactory(this.randomNumberGenerator.nextLong());
    }

    public void m_188584_(long seed) {
        this.randomNumberGenerator = new SecureRandom(JavaSecureRandomSource.longToByte(seed));
        this.gaussianSource.m_188602_();
    }

    public int m_188502_() {
        return this.randomNumberGenerator.nextInt();
    }

    public int m_188503_(int bound) {
        return this.randomNumberGenerator.nextInt(bound);
    }

    public long m_188505_() {
        return this.randomNumberGenerator.nextLong();
    }

    public boolean m_188499_() {
        return this.randomNumberGenerator.nextBoolean();
    }

    public float m_188501_() {
        return this.randomNumberGenerator.nextFloat();
    }

    public double m_188500_() {
        return this.randomNumberGenerator.nextDouble();
    }

    public double m_188583_() {
        return this.gaussianSource.m_188603_();
    }

    public static byte[] longToByte(long seed) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(seed);
        return buffer.array();
    }

    public static class JavaSecureRandomPositionalRandomFactory
    implements PositionalRandomFactory {
        private final long seed;

        public JavaSecureRandomPositionalRandomFactory(long seed) {
            this.seed = seed;
        }

        public RandomSource m_214111_(String string) {
            byte[] abyte = Hashing.goodFastHash((int)128).hashString((CharSequence)string, Charsets.UTF_8).asBytes();
            long i = Longs.fromBytes((byte)abyte[0], (byte)abyte[1], (byte)abyte[2], (byte)abyte[3], (byte)abyte[4], (byte)abyte[5], (byte)abyte[6], (byte)abyte[7]);
            return new JavaSecureRandomSource(i ^ this.seed);
        }

        public RandomSource m_213715_(int one, int two, int three) {
            return new JavaSecureRandomSource(Mth.m_14130_((int)one, (int)two, (int)three));
        }

        public void m_183502_(StringBuilder stringBuilder) {
            stringBuilder.append("seed: ").append(this.seed);
        }
    }
}

