/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util.climate;

import com.veteam.voluminousenergy.util.WorldUtil;
import com.veteam.voluminousenergy.util.climate.ClimateSpawn;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import oshi.util.tuples.Pair;

public class FluidClimateSpawn
extends ClimateSpawn {
    final Fluid fluid;
    final int maxAmount;
    final int minAmount;

    public FluidClimateSpawn(Pair<Float, Float> continentalness, Pair<Float, Float> erosion, Pair<Float, Float> humidity, Pair<Float, Float> temperature, Fluid fluid, int minimumDepositFluidAmount, int maximumDepositFluidAmount) {
        super(continentalness, erosion, humidity, temperature);
        this.fluid = fluid;
        this.minAmount = minimumDepositFluidAmount;
        this.maxAmount = maximumDepositFluidAmount;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getMaximumFluidAmount() {
        return this.maxAmount;
    }

    public int getMinimumFluidAmount() {
        return this.minAmount;
    }

    public int calculateDepositAmount(HashMap<WorldUtil.ClimateParameters, Double> sampledClimate, BlockPos blockPos, Level level) {
        return this.calculateDepositAmount(sampledClimate.get((Object)WorldUtil.ClimateParameters.CONTINENTALNESS), sampledClimate.get((Object)WorldUtil.ClimateParameters.EROSION), sampledClimate.get((Object)WorldUtil.ClimateParameters.HUMIDITY), sampledClimate.get((Object)WorldUtil.ClimateParameters.TEMPERATURE), blockPos, level);
    }

    public int calculateDepositAmount(double continentalness, double erosion, double humidity, double temperature, BlockPos blockPos, Level level) {
        if (!this.checkValidity(continentalness, erosion, humidity, temperature) || level.m_5776_()) {
            return 0;
        }
        int amount2Return = 0;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PerlinSimplexNoise noise = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(serverLevel.m_7328_()), List.of(Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(-2), Integer.valueOf(-3), Integer.valueOf(-4), Integer.valueOf(-5), Integer.valueOf(-6), Integer.valueOf(-7)));
            double amount = noise.m_75449_((double)blockPos.m_123341_(), (double)blockPos.m_123343_(), true);
            amount = (double)this.getMinimumFluidAmount() + amount * (double)(this.getMaximumFluidAmount() - this.getMinimumFluidAmount());
            amount2Return = Mth.m_14165_((double)amount);
        }
        return amount2Return;
    }
}

