/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util.climate;

import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.WorldUtil;
import java.util.HashMap;
import java.util.Random;
import oshi.util.tuples.Pair;

public class ClimateSpawn {
    final Pair<Float, Float> CONTINENTALNESS_PARAMETER;
    final Pair<Float, Float> EROSION_PARAMETER;
    final Pair<Float, Float> HUMIDITY_PARAMETER;
    final Pair<Float, Float> TEMPERATURE_PARAMATER;

    public ClimateSpawn(Pair<Float, Float> continentalness, Pair<Float, Float> erosion, Pair<Float, Float> humidity, Pair<Float, Float> temperature) {
        this.CONTINENTALNESS_PARAMETER = continentalness;
        this.EROSION_PARAMETER = erosion;
        this.HUMIDITY_PARAMETER = humidity;
        this.TEMPERATURE_PARAMATER = temperature;
    }

    public Pair<Float, Float> getContinentalnessClimateParameter() {
        return this.CONTINENTALNESS_PARAMETER;
    }

    public Pair<Float, Float> getErosionClimateParameter() {
        return this.EROSION_PARAMETER;
    }

    public Pair<Float, Float> getHumidityClimateParameter() {
        return this.HUMIDITY_PARAMETER;
    }

    public Pair<Float, Float> getTemperatureClimateParameter() {
        return this.TEMPERATURE_PARAMATER;
    }

    public boolean isWithinContinentalnessRange(double value) {
        return value >= (double)((Float)this.CONTINENTALNESS_PARAMETER.getA()).floatValue() && value <= (double)((Float)this.CONTINENTALNESS_PARAMETER.getB()).floatValue();
    }

    public boolean isWithinErosionRange(double value) {
        return value >= (double)((Float)this.EROSION_PARAMETER.getA()).floatValue() && value <= (double)((Float)this.EROSION_PARAMETER.getB()).floatValue();
    }

    public boolean isWithinHumidityRange(double value) {
        return value >= (double)((Float)this.HUMIDITY_PARAMETER.getA()).floatValue() && value <= (double)((Float)this.HUMIDITY_PARAMETER.getB()).floatValue();
    }

    public boolean isWithinTemperatureRange(double value) {
        return value >= (double)((Float)this.TEMPERATURE_PARAMATER.getA()).floatValue() && value <= (double)((Float)this.TEMPERATURE_PARAMATER.getB()).floatValue();
    }

    public boolean checkValidity(HashMap<WorldUtil.ClimateParameters, Double> sampledClimate) {
        return this.checkValidity(sampledClimate.get((Object)WorldUtil.ClimateParameters.CONTINENTALNESS), sampledClimate.get((Object)WorldUtil.ClimateParameters.EROSION), sampledClimate.get((Object)WorldUtil.ClimateParameters.HUMIDITY), sampledClimate.get((Object)WorldUtil.ClimateParameters.TEMPERATURE));
    }

    public boolean checkValidity(double continentalness, double erosion, double humidity, double temperature) {
        double cumulativeClimateValue;
        Random random;
        int inty;
        if (((Boolean)Config.PUNCH_HOLES_IN_CLIMATE_SPAWNS.get()).booleanValue() && (inty = (random = new Random((int)((cumulativeClimateValue = continentalness + erosion + humidity + temperature) * (double)((Integer)Config.CLIMATE_SPAWNS_HOLE_PUNCH_MULTIPLIER.get()).intValue()))).nextInt((Integer)Config.CLIMATE_SPAWNS_HOLE_PUNCH_BOUNDING.get())) > (Integer)Config.CLIMATE_SPAWNS_HOLE_PUNCH_RNG_MUST_BE_LARGER.get()) {
            return false;
        }
        return this.isWithinContinentalnessRange(continentalness) && this.isWithinErosionRange(erosion) && this.isWithinHumidityRange(humidity) && this.isWithinTemperatureRange(temperature);
    }
}

