/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import com.veteam.voluminousenergy.persistence.ChunkFluid;
import com.veteam.voluminousenergy.persistence.ChunkFluids;
import com.veteam.voluminousenergy.recipe.DimensionalLaserRecipe;
import com.veteam.voluminousenergy.util.climate.FluidClimateSpawn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import oshi.util.tuples.Pair;

public class WorldUtil {
    public static HashMap<ClimateParameters, Double> sampleClimate(Level level, BlockPos pos) {
        if (level.f_46443_) {
            new HashMap();
        }
        ServerLevel serverLevel = level.m_7654_().m_129880_(level.m_46472_());
        ServerChunkCache serverchunkcache = serverLevel.m_7726_();
        RandomState randomState = serverchunkcache.m_214994_();
        NoiseRouter noiseRouter = randomState.m_224578_();
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        double continentalness = noiseRouter.f_209386_().m_207386_((DensityFunction.FunctionContext)context);
        double erosion = noiseRouter.f_209387_().m_207386_((DensityFunction.FunctionContext)context);
        double humidity = noiseRouter.f_224392_().m_207386_((DensityFunction.FunctionContext)context);
        double temperature = noiseRouter.f_209384_().m_207386_((DensityFunction.FunctionContext)context);
        HashMap<ClimateParameters, Double> climateMap = new HashMap<ClimateParameters, Double>();
        climateMap.put(ClimateParameters.CONTINENTALNESS, continentalness);
        climateMap.put(ClimateParameters.EROSION, erosion);
        climateMap.put(ClimateParameters.HUMIDITY, humidity);
        climateMap.put(ClimateParameters.TEMPERATURE, temperature);
        return climateMap;
    }

    public static ChunkFluid getFluidFromPosition(Level level, BlockPos pos) {
        ChunkFluid chunkFluid;
        ServerLevel serverLevel = level.m_7654_().m_129880_(level.m_46472_());
        ArrayList<Pair<Fluid, Integer>> fluidsList = WorldUtil.queryForFluids(level, pos);
        ChunkAccess chunkAccess = level.m_46865_(pos);
        ChunkFluids chunkFluids = ChunkFluids.getInstance();
        if (!chunkFluids.hasChunkFluid(chunkFluid = chunkFluids.getOrElse(new ChunkFluid(chunkAccess.m_7697_(), fluidsList)))) {
            chunkFluids.add(chunkFluid);
            chunkFluids.m_77762_();
            DimensionDataStorage storage = serverLevel.m_8895_();
            storage.m_164855_("chunk_fluids", (SavedData)chunkFluids);
            storage.m_78151_();
        }
        return chunkFluid;
    }

    public static ArrayList<Pair<Fluid, Integer>> queryForFluids(Level level, BlockPos pos) {
        AtomicReference fluidsAtLocation = new AtomicReference(new ArrayList());
        HashMap<ClimateParameters, Double> sampledClimate = WorldUtil.sampleClimate(level, pos);
        if (sampledClimate.isEmpty()) {
            return fluidsAtLocation.get();
        }
        level.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            DimensionalLaserRecipe dimensionalLaserRecipe;
            FluidClimateSpawn spawn;
            if (recipe instanceof DimensionalLaserRecipe && (spawn = (dimensionalLaserRecipe = (DimensionalLaserRecipe)recipe).getFluidClimateSpawn()).checkValidity(sampledClimate)) {
                ((ArrayList)fluidsAtLocation.get()).add(new Pair((Object)spawn.getFluid(), (Object)spawn.calculateDepositAmount(sampledClimate, pos, level)));
            }
        });
        if (fluidsAtLocation.get().size() == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Random random = new Random(WorldUtil.randomSeedFromClimate(sampledClimate));
            if (random.nextInt(10) > 4) {
                fluidsAtLocation.get().add(new Pair((Object)Fluids.f_76193_, (Object)WorldUtil.fallbackFluidAmount(serverLevel, (Fluid)Fluids.f_76193_, sampledClimate, pos)));
            } else {
                fluidsAtLocation.get().add(new Pair((Object)Fluids.f_76195_, (Object)WorldUtil.fallbackFluidAmount(serverLevel, (Fluid)Fluids.f_76195_, sampledClimate, pos)));
            }
        }
        return fluidsAtLocation.get();
    }

    public static int randomSeedFromClimate(HashMap<ClimateParameters, Double> sampledClimate) {
        return (int)(10000.0 * (sampledClimate.get((Object)ClimateParameters.CONTINENTALNESS) + sampledClimate.get((Object)ClimateParameters.EROSION) + sampledClimate.get((Object)ClimateParameters.HUMIDITY) + sampledClimate.get((Object)ClimateParameters.TEMPERATURE)));
    }

    private static int fallbackFluidAmount(ServerLevel serverLevel, Fluid fluid, HashMap<ClimateParameters, Double> sampledClimate, BlockPos pos) {
        PerlinSimplexNoise noise = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(serverLevel.m_7328_()), List.of(Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(-2), Integer.valueOf(-3), Integer.valueOf(-4), Integer.valueOf(-5), Integer.valueOf(-6), Integer.valueOf(-7)));
        if (fluid.m_6212_((Fluid)Fluids.f_76193_) || fluid.m_6212_((Fluid)Fluids.f_76192_)) {
            return Mth.m_14040_((int)Mth.m_14165_((double)((double)((float)noise.m_75449_((double)pos.m_123341_(), (double)pos.m_123343_(), true) + 1000.0f) * sampledClimate.get((Object)ClimateParameters.HUMIDITY))));
        }
        if (fluid.m_6212_((Fluid)Fluids.f_76195_) || fluid.m_6212_((Fluid)Fluids.f_76194_)) {
            return Mth.m_14040_((int)Mth.m_14165_((double)((double)((float)noise.m_75449_((double)pos.m_123341_(), (double)pos.m_123343_(), true) + 1000.0f) * sampledClimate.get((Object)ClimateParameters.TEMPERATURE))));
        }
        return 250;
    }

    public static enum ClimateParameters {
        CONTINENTALNESS,
        EROSION,
        HUMIDITY,
        TEMPERATURE;

    }
}

