/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import com.veteam.voluminousenergy.persistence.SingleChunkFluid;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.energy.VEEnergyStorage;
import com.veteam.voluminousenergy.util.NumberUtil;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TextUtil {
    public static Component TRANSLATED_INPUT_SLOT = TextUtil.translateString("slot.voluminousenergy.input_slot");
    public static Component TRANSLATED_OUTPUT_SLOT = TextUtil.translateString("slot.voluminousenergy.output_slot");
    public static Component TRANSLATED_RNG_SLOT = TextUtil.translateString("slot.voluminousenergy.rng_slot");
    public static Component TRANSLATED_BUCKET_SLOT = TextUtil.translateString("slot.voluminousenergy.bucket_slot");
    public static Component TRANSLATED_INPUT_TANK = TextUtil.translateString("tank.voluminousenergy.input_tank");
    public static Component TRANSLATED_OUTPUT_TANK = TextUtil.translateString("tank.voluminousenergy.output_tank");
    public static Component TRANSLATED_BOTH_TANK = TextUtil.translateString("tank.voluminousenergy.both_tank");

    public static Component tankTooltip(String fluidName, int amount, int tankCapacity) {
        if (((Boolean)Config.SHORTEN_TANK_GUI_VALUES.get()).booleanValue()) {
            return TextUtil.translateString(fluidName).m_6881_().m_130946_(": " + NumberUtil.numberToString4Fluids(amount) + " / " + NumberUtil.numberToString4Fluids(tankCapacity));
        }
        String stringAmount = String.valueOf(amount);
        String stringTankCapacity = String.valueOf(tankCapacity);
        if (amount >= 1000) {
            stringAmount = NumberUtil.formatNumber(stringAmount);
        }
        if (tankCapacity >= 1000) {
            stringTankCapacity = NumberUtil.formatNumber(stringTankCapacity);
        }
        return Component.m_237115_((String)fluidName).m_7220_(Component.m_130674_((String)(": " + stringAmount + " mB / " + stringTankCapacity + " mB")));
    }

    public static Component powerBarTooltip(VEEnergyStorage veEnergyStorage, int configuredMaxPower) {
        return (Boolean)Config.SHORTEN_POWER_BAR_VALUES.get() != false ? Component.m_130674_((String)(NumberUtil.numberToString4FE(veEnergyStorage.getEnergyStored()) + " / " + NumberUtil.numberToString4FE(configuredMaxPower))) : Component.m_130674_((String)(NumberUtil.formatNumber(veEnergyStorage.getEnergyStored()) + " FE / " + NumberUtil.formatNumber(configuredMaxPower) + " FE"));
    }

    public static Component slotName(String slotName) {
        return Component.m_237115_((String)slotName);
    }

    public static Component translateDirection(Direction direction) {
        return Component.m_237115_((String)("direction.voluminousenergy." + TextUtil.directionToLocalDirection(direction)));
    }

    public static String directionToLocalDirection(Direction direction) {
        switch (direction) {
            case UP: {
                return "up";
            }
            case DOWN: {
                return "down";
            }
            case NORTH: {
                return "back";
            }
            case EAST: {
                return "right";
            }
            case SOUTH: {
                return "front";
            }
        }
        return "left";
    }

    public static Component slotNameWithDirection(String slotName, Direction direction, int ordinal) {
        Component translatedSlot = TextUtil.slotName(slotName);
        Component translatedDirection = TextUtil.translateDirection(direction);
        return Component.m_130674_((String)(translatedSlot.getString() + " " + ordinal + " " + translatedDirection.getString()));
    }

    public static Component translateString(String toTranslate) {
        return Component.m_237115_((String)toTranslate);
    }

    public static Component translateString(ChatFormatting chatFormatting, String toTranslate) {
        return TextUtil.translateString(toTranslate).m_6881_().m_130940_(chatFormatting);
    }

    public static Component translateVEBlock(String block) {
        return Component.m_237115_((String)("block.voluminousenergy." + block));
    }

    public static Component fluidNameAndAmountWithUnitsAndColours(FluidStack fluidStack) {
        return TextUtil.fluidNameAndAmountWithUnitsAndColours(fluidStack.getTranslationKey(), fluidStack.getAmount());
    }

    public static Component fluidNameAndAmountWithUnitsAndColours(SingleChunkFluid singleChunkFluid) {
        return TextUtil.fluidNameAndAmountWithUnitsAndColours(singleChunkFluid.getFluid(), singleChunkFluid.getAmount());
    }

    public static Component fluidNameAndAmountWithUnitsAndColours(Fluid fluid, int amount) {
        return TextUtil.fluidNameAndAmountWithUnitsAndColours(new FluidStack(fluid, amount).getTranslationKey(), amount);
    }

    public static Component fluidNameAndAmountWithUnitsAndColours(String fluidTranslationKey, int amount) {
        String translateString = TextUtil.translateString(fluidTranslationKey).getString();
        if (((Boolean)Config.SHORTEN_ITEM_TOOLTIP_VALUES.get()).booleanValue()) {
            return Component.m_130674_((String)(ChatFormatting.DARK_PURPLE + translateString + ": " + ChatFormatting.LIGHT_PURPLE + NumberUtil.numberToString4Fluids((float)amount / (float)((Integer)Config.DIMENSIONAL_LASER_PROCESS_TIME.get()).intValue()) + "/t"));
        }
        return Component.m_130674_((String)(ChatFormatting.DARK_PURPLE + translateString + ": " + ChatFormatting.LIGHT_PURPLE + NumberUtil.formatNumber((float)amount / (float)((Integer)Config.DIMENSIONAL_LASER_PROCESS_TIME.get()).intValue()) + " mB/t"));
    }

    public static int computeTextRenderWidth(int imageWidth, Font font, Component component) {
        return imageWidth - 8 - font.m_92852_((FormattedText)component) - 2;
    }

    public static void renderShadowedText(GuiGraphics graphics, Font font, Component component, int x, int y, @Nullable Style styleOptional) {
        TextUtil.veRenderGuiText(graphics, font, component, x, y, styleOptional, true);
    }

    public static void renderShadowedText(GuiGraphics graphics, Font font, String string, int x, int y, @Nullable Style styleOptional) {
        TextUtil.renderShadowedText(graphics, font, Component.m_130674_((String)string), x, y, styleOptional);
    }

    public static void renderUnshadowedText(GuiGraphics graphics, Font font, Component component, int x, int y, @Nullable Style styleOptional) {
        TextUtil.veRenderGuiText(graphics, font, component, x, y, styleOptional, false);
    }

    public static void renderUnshadowedText(GuiGraphics graphics, Font font, String string, int x, int y, @Nullable Style styleOptional) {
        TextUtil.renderUnshadowedText(graphics, font, Component.m_130674_((String)string), x, y, styleOptional);
    }

    private static void veRenderGuiText(GuiGraphics graphics, Font font, Component component, int x, int y, @Nullable Style styleOptional, boolean shouldShadow) {
        MutableComponent componentToRender = component.m_6881_();
        if (styleOptional != null) {
            componentToRender = componentToRender.m_6881_().m_130948_(styleOptional);
        }
        graphics.m_280614_(font, (Component)componentToRender, x, y, 0, shouldShadow);
    }
}

