/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class TagUtil {
    private static ArrayList<Item> cachedUpgrades;

    public static Lazy<ArrayList<Fluid>> getLazyFluids(ResourceLocation fluidTagLocation) {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)fluidTagLocation);
        return Lazy.of(() -> {
            HolderSet.Named holderSet = BuiltInRegistries.f_257020_.m_203561_(tag);
            AtomicReference fluidSet = new AtomicReference(new ArrayList());
            holderSet.m_203614_().forEach(fluidHolder -> ((ArrayList)fluidSet.get()).add((Fluid)fluidHolder.m_203334_()));
            return fluidSet.get();
        });
    }

    public static Lazy<ArrayList<FluidStack>> getLazyFluidStacks(ResourceLocation fluidTagLocation, int amount) {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)fluidTagLocation);
        return Lazy.of(() -> {
            HolderSet.Named holderSet = BuiltInRegistries.f_257020_.m_203561_(tag);
            AtomicReference fluidSet = new AtomicReference(new ArrayList());
            holderSet.m_203614_().forEach(fluidHolder -> ((ArrayList)fluidSet.get()).add(new FluidStack((Fluid)fluidHolder.m_203334_(), amount)));
            return fluidSet.get();
        });
    }

    public static Lazy<ArrayList<Item>> getLazyItems(ResourceLocation itemTagLocation) {
        TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)itemTagLocation);
        return Lazy.of(() -> {
            HolderSet.Named holderSet = BuiltInRegistries.f_257033_.m_203561_(tag);
            AtomicReference itemSet = new AtomicReference(new ArrayList());
            holderSet.m_203614_().forEach(itemHolder -> ((ArrayList)itemSet.get()).add((Item)itemHolder.m_203334_()));
            return itemSet.get();
        });
    }

    public static ArrayList<Fluid> getFluidListFromTagResourceLocationAlternative(String fluidTagLocation) {
        TagKey fluidTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation(fluidTagLocation));
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        AtomicReference atomicFluids = new AtomicReference(fluids);
        ForgeRegistries.FLUIDS.getKeys().forEach(fluidKey -> {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey);
            if (fluid.m_205067_(fluidTagKey)) {
                ((ArrayList)atomicFluids.get()).add(fluid);
            }
        });
        return fluids;
    }

    public static ArrayList<Fluid> getFluidListFromTagResourceLocationAlternative(ResourceLocation fluidTagLocation) {
        TagKey fluidTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)fluidTagLocation);
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        AtomicReference atomicFluids = new AtomicReference(fluids);
        ForgeRegistries.FLUIDS.getKeys().forEach(fluidKey -> {
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey);
            if (fluid.m_205067_(fluidTagKey)) {
                ((ArrayList)atomicFluids.get()).add(fluid);
            }
        });
        return fluids;
    }

    public static ArrayList<Fluid> getFluidListFromTagResourceLocation(String fluidTagLocation) {
        TagKey fluidTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)new ResourceLocation(fluidTagLocation));
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(fluidTagKey)) {
            fluids.add((Fluid)holder.m_203334_());
        }
        return fluids;
    }

    public static ArrayList<Fluid> getFluidListFromTagResourceLocation(ResourceLocation fluidTagLocation) {
        TagKey fluidTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)fluidTagLocation);
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(fluidTagKey)) {
            fluids.add((Fluid)holder.m_203334_());
        }
        return fluids;
    }

    public static ArrayList<Item> getItemListFromTagResourceLocation(String itemTagLocation) {
        TagKey itemTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(itemTagLocation));
        ArrayList<Item> items = new ArrayList<Item>();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(itemTagKey)) {
            items.add((Item)holder.m_203334_());
        }
        return items;
    }

    public static ArrayList<Item> getItemListFromTagResourceLocation(ResourceLocation itemTagLocation) {
        TagKey itemTagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)itemTagLocation);
        ArrayList<Item> items = new ArrayList<Item>();
        for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(itemTagKey)) {
            items.add((Item)holder.m_203334_());
        }
        return items;
    }

    public static ArrayList<Item> getTaggedMachineUpgradeItems() {
        if (cachedUpgrades == null || cachedUpgrades.isEmpty()) {
            cachedUpgrades = TagUtil.getItemListFromTagResourceLocation(new ResourceLocation("voluminousenergy", "machine_upgrades"));
        }
        return cachedUpgrades;
    }

    public static boolean isTaggedMachineUpgradeItem(Item item) {
        return TagUtil.getTaggedMachineUpgradeItems().contains(item);
    }

    public static boolean isTaggedMachineUpgradeItem(ItemStack itemStack) {
        return TagUtil.getTaggedMachineUpgradeItems().contains(itemStack.m_41720_());
    }
}

