/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import com.veteam.voluminousenergy.util.IntToDirection;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.NotImplementedException;

public class RelationalTank {
    FluidTank tank;
    int id;
    int outputID;
    ItemStack input;
    ItemStack output;
    TankType tankType;
    List<Fluid> validFluids = new ArrayList<Fluid>();
    private boolean sideStatus = false;
    private Direction sideDirection = Direction.DOWN;
    private boolean allowAny = false;
    private boolean ignoreDirection = false;
    private String nbt;

    public RelationalTank() {
    }

    public RelationalTank(FluidTank tank, int id, ItemStack input, ItemStack output, TankType tankType, String nbt) {
        this.tank = tank;
        this.id = id;
        this.input = input;
        this.output = output;
        this.tankType = tankType;
        this.nbt = nbt;
    }

    public RelationalTank(FluidTank tank, int id, ItemStack input, ItemStack output, TankType tankType, int outputID, String nbt) {
        this.tank = tank;
        this.id = id;
        this.input = input;
        this.output = output;
        this.tankType = tankType;
        this.outputID = outputID;
        this.nbt = nbt;
    }

    public void setIOItemstack(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public boolean isIgnoreDirection() {
        return this.ignoreDirection;
    }

    public void setIgnoreDirection(boolean ignoreDirection) {
        this.ignoreDirection = ignoreDirection;
    }

    public void setAllowAny(boolean allowAny) {
        this.allowAny = allowAny;
    }

    public boolean isAllowAny() {
        return this.allowAny;
    }

    public List<Fluid> getValidFluids() {
        return this.validFluids;
    }

    public void setValidFluids(List<Fluid> validFluids) {
        this.validFluids = validFluids;
    }

    public boolean isFluidValid(Fluid fluid) {
        if (this.allowAny) {
            return true;
        }
        return this.validFluids.contains(fluid);
    }

    public TankType getTankType() {
        return this.tankType;
    }

    public void setTankType(TankType tankType) {
        this.tankType = tankType;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void setTank(FluidTank tank) {
        this.tank = tank;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public void setInput(ItemStack input) {
        this.input = input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public void setOutput(ItemStack output) {
        this.output = output;
    }

    public int getOutputID() {
        return this.outputID;
    }

    public void setOutputID(int outputID) {
        this.outputID = outputID;
    }

    public boolean getSideStatus() {
        return this.sideStatus;
    }

    public void setSideStatus(boolean status) {
        this.sideStatus = status;
    }

    public Direction getSideDirection() {
        return this.sideDirection;
    }

    public void setSideDirection(Direction direction) {
        this.sideDirection = direction;
    }

    public String getTankName() {
        return this.nbt.split(":")[0];
    }

    public String getNBTPrefix() {
        return this.nbt.split(":")[1];
    }

    public String getTranslationKey() {
        if (this.tankType != null) {
            return switch (this.tankType) {
                case TankType.INPUT -> "tank.voluminousenergy.input_tank";
                case TankType.OUTPUT -> "tank.voluminousenergy.output_tank";
                case TankType.BOTH -> "tank.voluminousenergy.both_tank";
                default -> throw new NotImplementedException("Warning! Tank type " + this.tankType + " does not have a valid key!");
            };
        }
        return "tank.voluminousenergy.null";
    }

    public void writeGuiProperties(CompoundTag nbt) {
        nbt.m_128379_(this.getNBTPrefix() + "_enabled", this.getSideStatus());
        nbt.m_128405_(this.getNBTPrefix() + "_direction", this.getSideDirection().m_122411_());
    }

    public void readGuiProperties(CompoundTag nbt) {
        this.setSideStatus(nbt.m_128471_(this.getNBTPrefix() + "_enabled"));
        int sideInt = nbt.m_128451_(this.getNBTPrefix() + "_direction");
        this.setSideDirection(IntToDirection.IntegerToDirection(sideInt));
    }

    public boolean isValidFluidsSet() {
        return this.allowAny || !this.validFluids.isEmpty();
    }
}

