/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import com.veteam.voluminousenergy.recipe.AqueoulizerRecipe;
import com.veteam.voluminousenergy.recipe.CentrifugalAgitatorRecipe;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorFuelRecipe;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorOxidizerRecipe;
import com.veteam.voluminousenergy.recipe.CrusherRecipe;
import com.veteam.voluminousenergy.recipe.DistillationRecipe;
import com.veteam.voluminousenergy.recipe.FluidElectrolyzerRecipe;
import com.veteam.voluminousenergy.recipe.FluidMixerRecipe;
import com.veteam.voluminousenergy.recipe.HydroponicIncubatorRecipe;
import com.veteam.voluminousenergy.recipe.IndustrialBlastingRecipe;
import com.veteam.voluminousenergy.recipe.SawmillingRecipe;
import com.veteam.voluminousenergy.recipe.StirlingGeneratorRecipe;
import com.veteam.voluminousenergy.recipe.ToolingRecipe;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.recipe.VERecipe;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.RegistryLookups;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import oshi.util.tuples.Pair;

public class RecipeUtil {
    private static final HashMap<Integer, AqueoulizerRecipe> aqueoulizerRecipeHashMap = new HashMap();
    private static final HashMap<Integer, ArrayList<AqueoulizerRecipe>> aqueoulizerItemMap = new HashMap();
    private static final HashMap<Integer, CentrifugalAgitatorRecipe> CentrifugalAgitatorMap = new HashMap();
    private static final HashMap<Integer, DistillationRecipe> distillationRecipeMap = new HashMap();
    private static final HashMap<Integer, CombustionGeneratorFuelRecipe> combustionGeneratorFuelRecipeMap = new HashMap();
    private static final HashMap<Integer, CombustionGeneratorOxidizerRecipe> combustionOxidizerMap = new HashMap();
    private static final HashMap<Integer, IndustrialBlastingRecipe> industrialBlastingRecipeMap = new HashMap();
    private static final HashMap<Integer, StirlingGeneratorRecipe> stirlingGeneratorRecipeMap = new HashMap();
    private static ArrayList<CrusherRecipe> cachedCrusherRecipes = new ArrayList();
    private static HashMap<Integer, CrusherRecipe> CrusherIORecipeCache = new HashMap();
    private static final HashMap<Integer, FluidElectrolyzerRecipe> FluidElectrolyzerMap = new HashMap();
    private static final HashMap<Integer, FluidMixerRecipe> FluidMixerMap = new HashMap();
    private static final HashMap<Integer, HydroponicIncubatorRecipe> hydroponicIncubatorRecipeHashMap = new HashMap();
    private static final HashMap<Integer, ArrayList<HydroponicIncubatorRecipe>> hydroponicIncubatorItemMap = new HashMap();
    private static final HashMap<Integer, ArrayList<HydroponicIncubatorRecipe>> hydroponicIncubatorOutputCache = new HashMap();

    public static boolean isAqueoulizerInputFluidEqual(Level world, Fluid fluid) {
        for (Recipe iRecipe : world.m_7465_().m_44051_()) {
            if (!(iRecipe instanceof AqueoulizerRecipe)) continue;
            for (FluidStack stack : (ArrayList)((AqueoulizerRecipe)iRecipe).fluidInputList.get()) {
                if (!stack.getFluid().m_6212_(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAqueoulizerInputFluidEqual(AqueoulizerRecipe recipe, Fluid fluid) {
        for (FluidStack stack : (ArrayList)recipe.fluidInputList.get()) {
            if (!stack.getFluid().m_6212_(fluid)) continue;
            return true;
        }
        return false;
    }

    public static AqueoulizerRecipe getAqueoulizerRecipe(Level world, FluidStack inputFluid, ItemStack inputItem) {
        if (aqueoulizerRecipeHashMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof AqueoulizerRecipe)) continue;
                AqueoulizerRecipe aqueoulizerRecipe = (AqueoulizerRecipe)recipe;
                for (FluidStack recipeFluid : (ArrayList)aqueoulizerRecipe.fluidInputList.get()) {
                    for (Item ingredient : (ArrayList)aqueoulizerRecipe.ingredientList.get()) {
                        String hash = RegistryLookups.lookupItem(ingredient) + recipeFluid.getTranslationKey();
                        aqueoulizerRecipeHashMap.put(hash.hashCode(), aqueoulizerRecipe);
                    }
                }
            }
        }
        String hash = RegistryLookups.lookupItem(inputItem.m_41720_()) + inputFluid.getTranslationKey();
        return aqueoulizerRecipeHashMap.get(hash.hashCode());
    }

    public static ArrayList<AqueoulizerRecipe> getAqueoulizerRecipesFromItemInput(Level level, ItemStack inputStack) {
        return RecipeUtil.getAqueoulizerRecipesFromItemInput(level, inputStack.m_41720_());
    }

    public static ArrayList<AqueoulizerRecipe> getAqueoulizerRecipesFromFluidInput(Level level, FluidStack fluidStack) {
        return RecipeUtil.getAqueoulizerRecipesFromFluidInput(level, fluidStack.getRawFluid());
    }

    public static boolean isAqueoulizerOutput(Level level, FluidStack fluidStack) {
        return RecipeUtil.isAqueoulizerOutput(level, fluidStack.getRawFluid());
    }

    public static ArrayList<AqueoulizerRecipe> getAqueoulizerRecipesFromItemInput(Level level, Item inputItem) {
        for (Recipe recipe : level.m_7465_().m_44051_()) {
            if (!(recipe instanceof AqueoulizerRecipe)) continue;
            AqueoulizerRecipe aqueoulizerRecipe = (AqueoulizerRecipe)recipe;
            for (Item item : (ArrayList)aqueoulizerRecipe.ingredientList.get()) {
                if (RegistryLookups.lookupItem(item) == null) continue;
                int code = RegistryLookups.lookupItem(item).hashCode();
                if (!aqueoulizerItemMap.containsKey(code)) {
                    aqueoulizerItemMap.put(code, new ArrayList());
                }
                aqueoulizerItemMap.get(code).add(aqueoulizerRecipe);
            }
        }
        if (RegistryLookups.lookupItem(inputItem) == null) {
            return new ArrayList<AqueoulizerRecipe>();
        }
        return aqueoulizerItemMap.getOrDefault(RegistryLookups.lookupItem(inputItem).hashCode(), new ArrayList());
    }

    public static ArrayList<AqueoulizerRecipe> getAqueoulizerRecipesFromFluidInput(Level level, Fluid fluid) {
        ArrayList validRecipes = new ArrayList();
        AtomicReference atomicValidRecipes = new AtomicReference(validRecipes);
        level.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof AqueoulizerRecipe) {
                AqueoulizerRecipe aqueoulizerRecipe = (AqueoulizerRecipe)recipe;
                if (((ArrayList)aqueoulizerRecipe.fluidInputList.get()).contains(fluid)) {
                    ((ArrayList)atomicValidRecipes.get()).add(aqueoulizerRecipe);
                }
            }
        });
        return atomicValidRecipes.get();
    }

    public static boolean isAqueoulizerOutput(Level level, Fluid fluid) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        level.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            AqueoulizerRecipe aqueoulizerRecipe;
            if (recipe instanceof AqueoulizerRecipe && (aqueoulizerRecipe = (AqueoulizerRecipe)recipe).getOutputFluid().getRawFluid().m_6212_(fluid)) {
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    public static CentrifugalAgitatorRecipe getCentrifugalAgitatorRecipe(Level world, FluidStack inputFluid) {
        if (CentrifugalAgitatorMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof CentrifugalAgitatorRecipe)) continue;
                CentrifugalAgitatorRecipe centrifugalAgitatorRecipe = (CentrifugalAgitatorRecipe)recipe;
                for (FluidStack recipeFluid : (ArrayList)centrifugalAgitatorRecipe.fluidInputList.get()) {
                    String hash = recipeFluid.getTranslationKey();
                    CentrifugalAgitatorMap.put(hash.hashCode(), centrifugalAgitatorRecipe);
                }
            }
        }
        String hash = inputFluid.getTranslationKey();
        return CentrifugalAgitatorMap.get(hash.hashCode());
    }

    public static List<Fluid> getCentrifugalAgitatorInputFluids(Level world) {
        ArrayList<Fluid> fluidList = new ArrayList<Fluid>();
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof CentrifugalAgitatorRecipe)) continue;
            CentrifugalAgitatorRecipe centrifugalAgitatorRecipe = (CentrifugalAgitatorRecipe)recipe;
            fluidList.addAll((Collection)centrifugalAgitatorRecipe.rawFluidInputList.get());
        }
        return fluidList;
    }

    public static DistillationRecipe getDistillationRecipe(Level world, FluidStack inputFluid) {
        if (distillationRecipeMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof DistillationRecipe)) continue;
                DistillationRecipe distillationRecipe = (DistillationRecipe)recipe;
                for (FluidStack recipeFluid : (ArrayList)distillationRecipe.fluidInputList.get()) {
                    String hash = recipeFluid.getTranslationKey();
                    distillationRecipeMap.put(hash.hashCode(), distillationRecipe);
                }
            }
        }
        String hash = inputFluid.getTranslationKey();
        return distillationRecipeMap.get(hash.hashCode());
    }

    public static List<Fluid> getDistillationInputFluids(Level world) {
        ArrayList<Fluid> fluidList = new ArrayList<Fluid>();
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof DistillationRecipe)) continue;
            DistillationRecipe distillationRecipe = (DistillationRecipe)recipe;
            fluidList.addAll((Collection)distillationRecipe.rawFluidInputList.get());
        }
        return fluidList;
    }

    public static DistillationRecipe getDistillationRecipeFromResult(Level world, FluidStack resultFluid) {
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof DistillationRecipe) || !((DistillationRecipe)recipe).getOutputFluid().isFluidEqual(resultFluid)) continue;
            return (DistillationRecipe)recipe;
        }
        return null;
    }

    public static DistillationRecipe getDistillationRecipeFromSecondResult(Level world, FluidStack secondResultFluid) {
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof DistillationRecipe) || !((DistillationRecipe)recipe).getSecondResult().isFluidEqual(secondResultFluid)) continue;
            return (DistillationRecipe)recipe;
        }
        return null;
    }

    public static DistillationRecipe getDistillationRecipeFromThirdResult(Level world, ItemStack thirdResultItem) {
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof DistillationRecipe) || !((DistillationRecipe)recipe).getThirdResult().m_150930_(thirdResultItem.m_41720_())) continue;
            return (DistillationRecipe)recipe;
        }
        return null;
    }

    public static CombustionGeneratorFuelRecipe getFuelCombustionRecipe(Level world, FluidStack inputFluid) {
        if (combustionGeneratorFuelRecipeMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof CombustionGeneratorFuelRecipe)) continue;
                CombustionGeneratorFuelRecipe combustionGeneratorFuelRecipe = (CombustionGeneratorFuelRecipe)recipe;
                for (FluidStack fluid : (ArrayList)combustionGeneratorFuelRecipe.fluidInputList.get()) {
                    String hash = fluid.getTranslationKey();
                    combustionGeneratorFuelRecipeMap.put(hash.hashCode(), combustionGeneratorFuelRecipe);
                }
            }
        }
        String hash = inputFluid.getTranslationKey();
        return combustionGeneratorFuelRecipeMap.get(hash.hashCode());
    }

    public static List<Fluid> getFuelCombustionInputFluids(Level world) {
        if (world == null) {
            return new ArrayList<Fluid>();
        }
        ArrayList<Fluid> fluidList = new ArrayList<Fluid>();
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof CombustionGeneratorFuelRecipe)) continue;
            CombustionGeneratorFuelRecipe combustionGeneratorFuelRecipe = (CombustionGeneratorFuelRecipe)recipe;
            fluidList.addAll((Collection)combustionGeneratorFuelRecipe.rawFluidInputList.get());
        }
        return fluidList;
    }

    public static List<Fluid> getFuelCombustionInputFluidsParallel(Level world) {
        if (world == null) {
            return new ArrayList<Fluid>();
        }
        AtomicReference fluidList = new AtomicReference(new ArrayList());
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CombustionGeneratorFuelRecipe) {
                CombustionGeneratorFuelRecipe combustionGeneratorFuelRecipe = (CombustionGeneratorFuelRecipe)recipe;
                ((List)fluidList.get()).addAll((Collection)combustionGeneratorFuelRecipe.rawFluidInputList.get());
            }
        });
        return fluidList.get();
    }

    public static boolean isCombustibleFuel(Fluid fluid, Level world) {
        return RecipeUtil.getFuelCombustionInputFluidsParallel(world).contains(fluid);
    }

    public static boolean isCombustibleFuel(FluidStack fluidStack, Level world) {
        return RecipeUtil.isCombustibleFuel(fluidStack.getFluid(), world);
    }

    public static boolean isCombustibleFuelWithoutLevel(FluidStack fluidStack) {
        return RecipeUtil.isCombustibleFuelWithoutLevel(fluidStack.getRawFluid());
    }

    public static boolean isCombustibleFuelWithoutLevel(Fluid fluid) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        CombustionGeneratorFuelRecipe.lazyFluidsWithVolumetricEnergy.parallelStream().forEach(lazyPair -> {
            if (((ArrayList)((Pair)lazyPair.get()).getA()).contains(fluid)) {
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    public static ArrayList<Fluid> getCombustibleFuelsWithoutLevel() {
        AtomicReference fuels = new AtomicReference(new ArrayList());
        CombustionGeneratorFuelRecipe.lazyFluidsWithVolumetricEnergy.forEach((Consumer<Lazy<Pair<ArrayList<Fluid>, Integer>>>)((Consumer<Lazy>)lazyPair -> ((ArrayList)fuels.get()).addAll((Collection)((Pair)lazyPair.get()).getA())));
        return fuels.get();
    }

    public static int getVolumetricEnergyFromFluid(Fluid fluid, Level level) {
        if (level == null) {
            return 0;
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        level.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CombustionGeneratorFuelRecipe) {
                CombustionGeneratorFuelRecipe combustionGeneratorFuelRecipe = (CombustionGeneratorFuelRecipe)recipe;
                if (((ArrayList)combustionGeneratorFuelRecipe.rawFluidInputList.get()).contains(fluid) && atomicInteger.get() == 0) {
                    atomicInteger.set(combustionGeneratorFuelRecipe.getVolumetricEnergy());
                }
            }
        });
        return atomicInteger.get();
    }

    public static boolean isOxidizer(FluidStack fluidStack, Level level) {
        return RecipeUtil.isOxidizer(fluidStack.getRawFluid(), level);
    }

    public static boolean isOxidizer(Fluid fluid, Level level) {
        if (level == null) {
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        level.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CombustionGeneratorOxidizerRecipe) {
                CombustionGeneratorOxidizerRecipe oxidizerRecipe = (CombustionGeneratorOxidizerRecipe)recipe;
                if (((ArrayList)oxidizerRecipe.rawFluidInputList.get()).contains(fluid)) {
                    atomicBoolean.set(true);
                }
            }
        });
        return atomicBoolean.get();
    }

    public static CombustionGeneratorOxidizerRecipe getOxidizerCombustionRecipe(Level world, FluidStack inputFluid) {
        if (combustionOxidizerMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof CombustionGeneratorOxidizerRecipe)) continue;
                CombustionGeneratorOxidizerRecipe combustionGeneratorOxidizerRecipe = (CombustionGeneratorOxidizerRecipe)recipe;
                for (FluidStack recipeFluid : (ArrayList)combustionGeneratorOxidizerRecipe.fluidInputList.get()) {
                    String hash = recipeFluid.getTranslationKey();
                    combustionOxidizerMap.put(hash.hashCode(), combustionGeneratorOxidizerRecipe);
                }
            }
        }
        String hash = inputFluid.getTranslationKey();
        return combustionOxidizerMap.get(hash.hashCode());
    }

    public static List<Fluid> getOxidizerFluids(Level world) {
        if (world == null) {
            return new ArrayList<Fluid>();
        }
        AtomicReference fluidList = new AtomicReference(new ArrayList());
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CombustionGeneratorOxidizerRecipe) {
                CombustionGeneratorOxidizerRecipe oxidizerRecipe = (CombustionGeneratorOxidizerRecipe)recipe;
                ((List)fluidList.get()).addAll((Collection)oxidizerRecipe.rawFluidInputList.get());
            }
        });
        return fluidList.get();
    }

    public static CombustionGeneratorOxidizerRecipe getOxidizerCombustionRecipeWithoutLevel(FluidStack fluidStack) {
        return RecipeUtil.getOxidizerCombustionRecipeWithoutLevel(fluidStack.getRawFluid());
    }

    public static CombustionGeneratorOxidizerRecipe getOxidizerCombustionRecipeWithoutLevel(Fluid fluid) {
        AtomicReference<Object> recipeToReturn = new AtomicReference<Object>(null);
        CombustionGeneratorOxidizerRecipe.oxidizerRecipes.parallelStream().forEach(oxidizerRecipe -> {
            if (((ArrayList)oxidizerRecipe.rawFluidInputList.get()).contains(fluid)) {
                recipeToReturn.set(oxidizerRecipe);
            }
        });
        return recipeToReturn.get();
    }

    public static IndustrialBlastingRecipe getIndustrialBlastingRecipe(Level world, ItemStack firstInput, ItemStack secondInput) {
        if (industrialBlastingRecipeMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof IndustrialBlastingRecipe)) continue;
                IndustrialBlastingRecipe industrialBlastingRecipe = (IndustrialBlastingRecipe)recipe;
                for (Item firstIn : industrialBlastingRecipe.getFirstInputAsList()) {
                    for (Item secondIn : (ArrayList)industrialBlastingRecipe.onlySecondInput.get()) {
                        String hash = "" + RegistryLookups.lookupItem(firstIn) + RegistryLookups.lookupItem(secondIn);
                        industrialBlastingRecipeMap.put(hash.hashCode(), industrialBlastingRecipe);
                    }
                }
            }
        }
        String hash = "" + RegistryLookups.lookupItem(firstInput.m_41720_()) + RegistryLookups.lookupItem(secondInput.m_41720_());
        return industrialBlastingRecipeMap.get(hash.hashCode());
    }

    public static boolean isFirstIngredientForIndustrialBlastingRecipe(Level world, ItemStack firstInput) {
        if (firstInput.m_41619_()) {
            return false;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof IndustrialBlastingRecipe) || !((IndustrialBlastingRecipe)recipe).getFirstInputAsList().contains(firstInput.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSecondIngredientForIndustrialBlastingRecipe(Level world, ItemStack secondInput) {
        if (secondInput.m_41619_()) {
            return false;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof IndustrialBlastingRecipe) || !((ArrayList)((IndustrialBlastingRecipe)recipe).onlySecondInput.get()).contains(secondInput.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnOutputForIndustrialBlastingRecipe(Level world, ItemStack outputStack) {
        if (outputStack.m_41619_()) {
            return false;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof IndustrialBlastingRecipe) || !((IndustrialBlastingRecipe)recipe).getResult().m_150930_(outputStack.m_41720_())) continue;
            return true;
        }
        return false;
    }

    public static ToolingRecipe getToolingRecipeFromBitAndBase(Level world, ItemStack bitStack, ItemStack baseStack) {
        if (baseStack.m_41619_() || bitStack.m_41619_()) {
            return null;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof ToolingRecipe) || !((ToolingRecipe)recipe).getBits().contains(bitStack.m_41720_()) || !((ToolingRecipe)recipe).getBases().contains(baseStack.m_41720_())) continue;
            return (ToolingRecipe)recipe;
        }
        return null;
    }

    public static ToolingRecipe getToolingRecipeFromResult(Level world, ItemStack resultStack) {
        if (resultStack.m_41619_()) {
            return null;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof ToolingRecipe) || !((ToolingRecipe)recipe).getResult().m_150930_(resultStack.m_41720_())) continue;
            return (ToolingRecipe)recipe;
        }
        return null;
    }

    public static ItemStack getPlankFromLog(Level world, ItemStack logStack) {
        if (logStack.m_41619_()) {
            return null;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof CraftingRecipe) || !ForgeRegistries.ITEMS.getKey((Object)recipe.m_8043_(world.m_9598_()).m_41720_()).toString().contains("plank")) continue;
            AtomicBoolean foundInput = new AtomicBoolean(false);
            recipe.m_7527_().parallelStream().forEach(ingredient -> {
                for (ItemStack itemStack : ingredient.m_43908_()) {
                    if (!itemStack.m_41720_().equals(logStack.m_41720_())) continue;
                    foundInput.set(true);
                }
            });
            if (!foundInput.get()) continue;
            return recipe.m_8043_(world.m_9598_()).m_41777_();
        }
        return null;
    }

    public static CraftingRecipe getRecipeFromLog(Level world, ItemStack logStack) {
        if (logStack.m_41619_()) {
            return null;
        }
        for (Recipe recipe : world.m_7465_().m_44051_()) {
            if (!(recipe instanceof CraftingRecipe) || !RegistryLookups.lookupItem(recipe.m_8043_(world.m_9598_())).toString().contains("plank")) continue;
            AtomicBoolean foundInput = new AtomicBoolean(false);
            recipe.m_7527_().parallelStream().forEach(ingredient -> {
                for (ItemStack itemStack : ingredient.m_43908_()) {
                    if (!itemStack.m_41720_().equals(logStack.m_41720_())) continue;
                    foundInput.set(true);
                }
            });
            if (!foundInput.get()) continue;
            return (CraftingRecipe)recipe;
        }
        return null;
    }

    public static ItemStack getPlankFromLogParallel(Level world, ItemStack logStack) {
        if (logStack.m_41619_()) {
            return null;
        }
        AtomicReference<Object> atomicItemStack = new AtomicReference<Object>(null);
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CraftingRecipe && RegistryLookups.lookupItem(recipe.m_8043_(world.m_9598_())).toString().contains("plank")) {
                recipe.m_7527_().forEach(ingredient -> {
                    for (ItemStack itemStack : ingredient.m_43908_()) {
                        if (!itemStack.m_41720_().equals(logStack.m_41720_())) continue;
                        atomicItemStack.set(recipe.m_8043_(world.m_9598_()).m_41777_());
                    }
                });
            }
        });
        return atomicItemStack.get();
    }

    public static CraftingRecipe getRecipeFromLogParallel(Level world, ItemStack logStack) {
        if (logStack.m_41619_()) {
            return null;
        }
        AtomicReference<Object> atomicRecipe = new AtomicReference<Object>(null);
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CraftingRecipe && RegistryLookups.lookupItem(recipe.m_8043_(world.m_9598_())).toString().contains("plank")) {
                recipe.m_7527_().forEach(ingredient -> {
                    for (ItemStack itemStack : ingredient.m_43908_()) {
                        if (!itemStack.m_41720_().equals(logStack.m_41720_())) continue;
                        atomicRecipe.set(((CraftingRecipe)recipe));
                    }
                });
            }
        });
        return atomicRecipe.get();
    }

    public static ArrayList<ItemStack> getLogFromPlankParallel(Level world, ItemStack plankStack) {
        if (plankStack.m_41619_()) {
            return null;
        }
        AtomicReference atomicItemStackArray = new AtomicReference(new ArrayList());
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof CraftingRecipe && RegistryLookups.lookupItem(recipe.m_8043_(world.m_9598_())).toString().contains("plank") && recipe.m_8043_(world.m_9598_()).m_150930_(plankStack.m_41720_())) {
                recipe.m_7527_().forEach(ingredient -> {
                    for (int i = 0; i < ingredient.m_43908_().length; ++i) {
                        ((ArrayList)atomicItemStackArray.get()).add(ingredient.m_43908_()[i]);
                    }
                });
            }
        });
        return atomicItemStackArray.get();
    }

    public static SawmillingRecipe getSawmillingRecipeFromLog(Level world, ItemStack logStack) {
        if (logStack.m_41619_()) {
            return null;
        }
        AtomicReference<Object> atomicRecipe = new AtomicReference<Object>(null);
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            SawmillingRecipe sawmillingRecipe;
            if (recipe instanceof SawmillingRecipe && !(sawmillingRecipe = (SawmillingRecipe)recipe).isLogRecipe()) {
                for (ItemStack ingredientStack : ((Ingredient)sawmillingRecipe.ingredient.get()).m_43908_()) {
                    if (!ingredientStack.m_41720_().equals(logStack.m_41720_())) continue;
                    atomicRecipe.set(sawmillingRecipe);
                    break;
                }
            }
        });
        return atomicRecipe.get();
    }

    public static SawmillingRecipe getSawmillingRecipeFromPlank(Level world, ItemStack plankStack) {
        if (plankStack.m_41619_()) {
            return null;
        }
        AtomicReference<Object> atomicRecipe = new AtomicReference<Object>(null);
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            SawmillingRecipe sawmillingRecipe;
            if (recipe instanceof SawmillingRecipe && !(sawmillingRecipe = (SawmillingRecipe)recipe).isLogRecipe() && sawmillingRecipe.result.m_41720_().equals(plankStack.m_41720_())) {
                atomicRecipe.set(((SawmillingRecipe)recipe));
            }
        });
        return atomicRecipe.get();
    }

    public static SawmillingRecipe getSawmillingRecipeFromSecondOutput(Level level, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return null;
        }
        AtomicReference<Object> atomicRecipe = new AtomicReference<Object>(null);
        level.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            SawmillingRecipe sawmillingRecipe;
            if (recipe instanceof SawmillingRecipe && !(sawmillingRecipe = (SawmillingRecipe)recipe).isLogRecipe()) {
                Item item = sawmillingRecipe.secondResult.m_41720_();
                if (itemStack.m_41720_().equals(item)) {
                    atomicRecipe.set(sawmillingRecipe);
                }
            }
        });
        return atomicRecipe.get();
    }

    public static StirlingGeneratorRecipe getStirlingGeneratorRecipe(Level world, ItemStack solidFuelStack) {
        if (solidFuelStack.m_41619_()) {
            return null;
        }
        world.m_7465_().m_44051_().parallelStream().forEach(recipe -> {
            if (recipe instanceof StirlingGeneratorRecipe) {
                StirlingGeneratorRecipe stirlingGeneratorRecipe = (StirlingGeneratorRecipe)recipe;
                for (ItemStack itemStack : stirlingGeneratorRecipe.getIngredient().m_43908_()) {
                    if (RegistryLookups.lookupItem(itemStack.m_41720_()) == null) continue;
                    stirlingGeneratorRecipeMap.put(RegistryLookups.lookupItem(itemStack.m_41720_()).hashCode(), stirlingGeneratorRecipe);
                }
            }
        });
        if (RegistryLookups.lookupItem(solidFuelStack.m_41720_()) == null) {
            return null;
        }
        return stirlingGeneratorRecipeMap.get(RegistryLookups.lookupItem(solidFuelStack.m_41720_()).hashCode());
    }

    public static Lazy<ArrayList<Item>> getLazyItemsFromIngredient(VERecipe recipe) {
        return Lazy.of(() -> {
            ArrayList<Item> items = new ArrayList<Item>();
            for (ItemStack stack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                if (items.contains(stack.m_41720_())) continue;
                items.add(stack.m_41720_());
            }
            return items;
        });
    }

    public static Lazy<ArrayList<Item>> getLazyItemsFromIngredient(VEFluidRecipe recipe) {
        return Lazy.of(() -> {
            ArrayList<Item> items = new ArrayList<Item>();
            for (ItemStack stack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                if (items.contains(stack.m_41720_())) continue;
                items.add(stack.m_41720_());
            }
            return items;
        });
    }

    public static void setupFluidLazyArrayInputsUsingTags(VEFluidRecipe recipe, ResourceLocation fluidTagLocation, int fluidAmount) {
        recipe.fluidUsesTagKey = true;
        recipe.tagKeyString = fluidTagLocation.toString();
        recipe.rawFluidInputList = TagUtil.getLazyFluids(fluidTagLocation);
        recipe.fluidInputList = TagUtil.getLazyFluidStacks(fluidTagLocation, fluidAmount);
        recipe.inputArraySize = Lazy.of(() -> ((ArrayList)recipe.fluidInputList.get()).size());
    }

    public static void setupFluidLazyArrayInputsWithFluid(VEFluidRecipe recipe, ResourceLocation fluidResourceLocation, int fluidAmount) {
        recipe.fluidUsesTagKey = false;
        recipe.fluidInputList = Lazy.of(() -> {
            ArrayList<FluidStack> temp = new ArrayList<FluidStack>();
            temp.add(new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation)), fluidAmount));
            return temp;
        });
        recipe.rawFluidInputList = Lazy.of(() -> {
            ArrayList<Fluid> temp = new ArrayList<Fluid>();
            temp.add((Fluid)ForgeRegistries.FLUIDS.getValue(fluidResourceLocation));
            return temp;
        });
        recipe.inputArraySize = Lazy.of(() -> 1);
    }

    public static Lazy<ArrayList<Item>> createLazyAnthology(Lazy<ArrayList<Item>> ... toAnthologize) {
        return Lazy.of(() -> {
            ArrayList anthology = new ArrayList();
            for (Lazy items : toAnthologize) {
                anthology.addAll((Collection)items.get());
            }
            return anthology;
        });
    }

    public static Lazy<ArrayList<Fluid>> createLazyAnthologyFluids(Lazy<ArrayList<Fluid>> ... toAnthologize) {
        return Lazy.of(() -> {
            ArrayList anthology = new ArrayList();
            for (Lazy fluids : toAnthologize) {
                anthology.addAll((Collection)fluids.get());
            }
            return anthology;
        });
    }

    public static int getVolumetricEnergyWithoutLevel(Fluid fluid) {
        AtomicInteger atomicInteger = new AtomicInteger(0);
        CombustionGeneratorFuelRecipe.lazyFluidsWithVolumetricEnergy.parallelStream().forEach(lazyPair -> {
            if (((ArrayList)((Pair)lazyPair.get()).getA()).contains(fluid)) {
                atomicInteger.set((Integer)((Pair)lazyPair.get()).getB());
            }
        });
        return atomicInteger.get();
    }

    public static ArrayList<FluidStack> getFluidsAsHotOrHotterThanIntAsFluidStacks(int minimumTemperatureKelvin, int stackAmount) {
        AtomicReference fluidStacks = new AtomicReference(new ArrayList());
        ForgeRegistries.FLUIDS.getValues().parallelStream().forEach(fluid -> {
            if (fluid.getFluidType().getTemperature() > minimumTemperatureKelvin) {
                ((ArrayList)fluidStacks.get()).add(new FluidStack(fluid, stackAmount));
            }
        });
        return fluidStacks.get();
    }

    public static ArrayList<FluidStack> getFluidsHotEnoughForIndustrialBlastingRecipe(IndustrialBlastingRecipe recipe) {
        return RecipeUtil.getFluidsAsHotOrHotterThanIntAsFluidStacks(recipe.getMinimumHeat(), (Integer)Config.BLAST_FURNACE_HEAT_SOURCE_CONSUMPTION.get());
    }

    public static ArrayList<CrusherRecipe> getCrusherRecipes(Level level) {
        if (cachedCrusherRecipes.isEmpty()) {
            for (Recipe recipe : level.m_7465_().m_44051_()) {
                if (!(recipe instanceof CrusherRecipe)) continue;
                CrusherRecipe crusherRecipe = (CrusherRecipe)recipe;
                cachedCrusherRecipes.add(crusherRecipe);
            }
        }
        return cachedCrusherRecipes;
    }

    public static Optional<CrusherRecipe> getCrusherRecipeFromAnyOutputAndTryInput(Item output, Item potentiallyKnownInput, Level level) {
        int itemPairHash = new Pair((Object)output, (Object)potentiallyKnownInput).hashCode();
        if (CrusherIORecipeCache.containsKey(itemPairHash)) {
            return Optional.of(CrusherIORecipeCache.get(itemPairHash));
        }
        AtomicReference atomicSublist = new AtomicReference(new ArrayList());
        RecipeUtil.getCrusherRecipes(level).forEach(recipe -> {
            if (recipe.result.m_150930_(output) || recipe.rngResult.m_150930_(output)) {
                ((ArrayList)atomicSublist.get()).add(recipe);
            }
        });
        if (potentiallyKnownInput != null && potentiallyKnownInput != Items.f_41852_ && !atomicSublist.get().isEmpty()) {
            for (CrusherRecipe crusherRecipe : atomicSublist.get()) {
                if (crusherRecipe == null) continue;
                for (ItemStack ingredientStack : crusherRecipe.getIngredient().m_43908_()) {
                    if (ingredientStack.m_41720_() != potentiallyKnownInput) continue;
                    CrusherIORecipeCache.put(itemPairHash, crusherRecipe);
                    return Optional.of(crusherRecipe);
                }
            }
        }
        try {
            return Optional.ofNullable((CrusherRecipe)atomicSublist.get().get(0));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static FluidElectrolyzerRecipe getFluidElectrolyzerRecipe(Level world, FluidStack inputFluid) {
        if (FluidElectrolyzerMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof FluidElectrolyzerRecipe)) continue;
                FluidElectrolyzerRecipe fluidElectrolyzerRecipe = (FluidElectrolyzerRecipe)recipe;
                for (FluidStack recipeFluid : (ArrayList)fluidElectrolyzerRecipe.fluidInputList.get()) {
                    String hash = recipeFluid.getTranslationKey();
                    FluidElectrolyzerMap.put(hash.hashCode(), fluidElectrolyzerRecipe);
                }
            }
        }
        String hash = inputFluid.getTranslationKey();
        return FluidElectrolyzerMap.get(hash.hashCode());
    }

    public static FluidMixerRecipe getFluidMixerRecipe(Level world, FluidStack firstInput, FluidStack secondInput) {
        if (FluidMixerMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof FluidMixerRecipe)) continue;
                FluidMixerRecipe fluidMixerRecipe = (FluidMixerRecipe)recipe;
                for (FluidStack firstRecipeInput : (ArrayList)fluidMixerRecipe.fluidInputList.get()) {
                    for (FluidStack secondRecipeInput : (ArrayList)fluidMixerRecipe.secondFluidInputList.get()) {
                        String firstHash = firstRecipeInput.getTranslationKey();
                        String secondHash = secondRecipeInput.getTranslationKey();
                        FluidMixerMap.put((firstHash + secondHash).hashCode(), fluidMixerRecipe);
                    }
                }
            }
        }
        String firstHash = firstInput.getTranslationKey();
        String secondHash = secondInput.getTranslationKey();
        return FluidMixerMap.get((firstHash + secondHash).hashCode());
    }

    public static HydroponicIncubatorRecipe getHydroponicIncubatorRecipe(Level world, FluidStack inputFluid, ItemStack inputItem) {
        if (hydroponicIncubatorRecipeHashMap.isEmpty()) {
            for (Recipe recipe : world.m_7465_().m_44051_()) {
                if (!(recipe instanceof HydroponicIncubatorRecipe)) continue;
                HydroponicIncubatorRecipe hydroponicIncubatorRecipe = (HydroponicIncubatorRecipe)recipe;
                for (FluidStack recipeFluid : (ArrayList)hydroponicIncubatorRecipe.fluidInputList.get()) {
                    for (Item ingredient : (ArrayList)hydroponicIncubatorRecipe.ingredientList.get()) {
                        String hash = RegistryLookups.lookupItem(ingredient).toString() + recipeFluid.getTranslationKey();
                        hydroponicIncubatorRecipeHashMap.put(hash.hashCode(), hydroponicIncubatorRecipe);
                    }
                }
            }
        }
        String hash = RegistryLookups.lookupItem(inputItem.m_41720_()) + inputFluid.getTranslationKey();
        return hydroponicIncubatorRecipeHashMap.get(hash.hashCode());
    }

    public static ArrayList<HydroponicIncubatorRecipe> getHydroponicIncubatorRecipesFromItemInput(Level level, Item inputItem) {
        for (Recipe recipe : level.m_7465_().m_44051_()) {
            if (!(recipe instanceof HydroponicIncubatorRecipe)) continue;
            HydroponicIncubatorRecipe hydroponicIncubatorRecipe = (HydroponicIncubatorRecipe)recipe;
            for (Item item : (ArrayList)hydroponicIncubatorRecipe.ingredientList.get()) {
                if (RegistryLookups.lookupItem(item) == null) continue;
                int code = item.hashCode();
                if (!hydroponicIncubatorItemMap.containsKey(code)) {
                    hydroponicIncubatorItemMap.put(item.hashCode(), new ArrayList());
                }
                hydroponicIncubatorItemMap.get(code).add(hydroponicIncubatorRecipe);
            }
        }
        if (RegistryLookups.lookupItem(inputItem) == null) {
            return new ArrayList<HydroponicIncubatorRecipe>();
        }
        return hydroponicIncubatorItemMap.getOrDefault(inputItem.hashCode(), new ArrayList());
    }

    public static final ArrayList<HydroponicIncubatorRecipe> getHydroponicIncubatorRecipesFromAnyItemOutput(Level level, Item outputItem) {
        if (hydroponicIncubatorOutputCache.isEmpty()) {
            for (Recipe recipe : level.m_7465_().m_44051_()) {
                if (!(recipe instanceof HydroponicIncubatorRecipe)) continue;
                HydroponicIncubatorRecipe hydroponicIncubatorRecipe = (HydroponicIncubatorRecipe)recipe;
                for (Item resultItem : hydroponicIncubatorRecipe.getResultItems()) {
                    ArrayList<Object> arrayList;
                    if (hydroponicIncubatorOutputCache.containsKey(resultItem.hashCode())) {
                        arrayList = hydroponicIncubatorOutputCache.get(resultItem.hashCode());
                        if (arrayList.contains(hydroponicIncubatorRecipe)) continue;
                        arrayList.add(hydroponicIncubatorRecipe);
                        hydroponicIncubatorOutputCache.replace(resultItem.hashCode(), arrayList);
                        continue;
                    }
                    arrayList = new ArrayList<HydroponicIncubatorRecipe>();
                    arrayList.add(hydroponicIncubatorRecipe);
                    hydroponicIncubatorOutputCache.put(resultItem.hashCode(), arrayList);
                }
            }
        }
        return hydroponicIncubatorOutputCache.getOrDefault(outputItem.hashCode(), new ArrayList());
    }
}

