/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;

public class NumberUtil {
    public static String formatNumber(String number) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat.format(Double.parseDouble(number));
    }

    public static String formatNumber(double number) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setGroupingUsed(true);
        decimalFormat.setGroupingSize(3);
        return decimalFormat.format(number);
    }

    private static String removeZeros(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(d);
    }

    public static String numberToString(double num) {
        if (num < 1000000.0) {
            return NumberUtil.formatNumber(NumberUtil.removeZeros(num));
        }
        if (num < 1.0E9) {
            return NumberUtil.removeZeros(num / 1000000.0) + " Million";
        }
        if (num < 1.0E12) {
            return NumberUtil.removeZeros(num / 1.0E9) + " Billion";
        }
        return NumberUtil.removeZeros(num / 1.0E12) + " Trillion";
    }

    public static String numberToString4Fluids(double num) {
        if (num < 1000.0) {
            Object toReturn = String.valueOf(num);
            toReturn = (String)toReturn + " mB";
            return toReturn;
        }
        if (num >= 1000.0 && num < 1000000.0) {
            return NumberUtil.removeZeros(num / 1000.0) + " B";
        }
        if (num < 1.0E9) {
            return NumberUtil.removeZeros(num / 1000000.0) + " kB";
        }
        if (num < 1.0E12) {
            return NumberUtil.removeZeros(num / 1.0E9) + " MB";
        }
        return NumberUtil.removeZeros(num / 1.0E12) + " GB";
    }

    public static String numberToString4FE(double num) {
        if (num < 1000.0) {
            Object toReturn = String.valueOf(num);
            toReturn = (String)toReturn + " FE";
            return toReturn;
        }
        if (num >= 1000.0 && num < 1000000.0) {
            return NumberUtil.removeZeros(num / 1000.0) + " kFE";
        }
        if (num < 1.0E9) {
            return NumberUtil.removeZeros(num / 1000000.0) + " MFE";
        }
        if (num < 1.0E12) {
            return NumberUtil.removeZeros(num / 1.0E9) + " GFE";
        }
        return NumberUtil.removeZeros(num / 1.0E12) + " TFE";
    }

    public static Component numberToTextComponent4FE(double num) {
        return Component.m_130674_((String)NumberUtil.numberToString4FE(num));
    }

    public static Component numberToTextComponent4Fluids(double num) {
        return Component.m_130674_((String)NumberUtil.numberToString4Fluids(num));
    }

    public static Component numberToTextComponent(double num) {
        return Component.m_130674_((String)NumberUtil.numberToString(num));
    }

    public static String numberToString(String numString) {
        double num = Double.parseDouble(numString);
        return NumberUtil.numberToString(num);
    }
}

