/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import com.google.common.base.Preconditions;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.SlotType;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MultiSlotWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable inventory;
    HashMap<Integer, VESlotManager> managerHashMap = new HashMap();

    public MultiSlotWrapper(IItemHandlerModifiable inventory, List<VESlotManager> slotManager) {
        Preconditions.checkArgument((!slotManager.isEmpty() ? 1 : 0) != 0, (Object)"You need to have at least one slot defined!");
        this.inventory = inventory;
        slotManager.forEach(m -> this.managerHashMap.put(m.getSlotNum(), (VESlotManager)m));
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.managerHashMap.containsKey(slot)) {
            return this.inventory.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.managerHashMap.containsKey(slot)) {
            VESlotManager manager = this.managerHashMap.get(slot);
            if (manager.getSlotType() == SlotType.OUTPUT) {
                return stack;
            }
            return this.inventory.insertItem(manager.getSlotNum(), stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.managerHashMap.containsKey(slot)) {
            VESlotManager manager = this.managerHashMap.get(slot);
            if (manager.getSlotType() == SlotType.INPUT) {
                return ItemStack.f_41583_;
            }
            return this.inventory.extractItem(this.managerHashMap.get(slot).getSlotNum(), amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.checkSlot(slot)) {
            this.inventory.setStackInSlot(slot, stack);
        }
    }

    public int getSlotLimit(int slot) {
        if (this.checkSlot(slot)) {
            return this.inventory.getSlotLimit(slot);
        }
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.checkSlot(slot)) {
            return this.inventory.isItemValid(slot, stack);
        }
        return false;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot < this.getSlots();
    }
}

