/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.util;

import com.google.common.base.Preconditions;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MultiFluidSlotWrapper
implements IFluidHandler {
    HashMap<Integer, RelationalTank> tankHashMap = new HashMap();
    List<RelationalTank> tanks = new ArrayList<RelationalTank>();

    public MultiFluidSlotWrapper(List<RelationalTank> tanks) {
        Preconditions.checkArgument((!tanks.isEmpty() ? 1 : 0) != 0, (Object)"You need to have at least one slot defined!");
        this.tanks.addAll(tanks);
        tanks.forEach(t -> this.tankHashMap.put(t.getId(), (RelationalTank)t));
    }

    public int getTanks() {
        return this.tanks.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank >= this.tanks.size()) {
            return FluidStack.EMPTY;
        }
        RelationalTank fluidTank = this.tanks.get(tank);
        return fluidTank.getTank() == null ? FluidStack.EMPTY : fluidTank.getTank().getFluid();
    }

    public int getTankCapacity(int tank) {
        if (tank >= this.tanks.size()) {
            return 0;
        }
        RelationalTank fluidTank = this.tanks.get(tank);
        return fluidTank.getTank() == null ? 0 : fluidTank.getTank().getCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        RelationalTank relationalTank = this.tankHashMap.get(tank);
        if (relationalTank == null) {
            return false;
        }
        if (relationalTank.getValidFluids().stream().noneMatch(fluid -> fluid.m_6212_(stack.getFluid())) && !relationalTank.isAllowAny()) {
            return false;
        }
        return relationalTank.getTank() != null && relationalTank.getTank().isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (RelationalTank tank : this.tanks) {
            if (tank.getTankType() == TankType.OUTPUT || !this.isFluidValid(tank.getId(), resource) || !tank.getTank().isEmpty() && !resource.isFluidEqual(tank.getTank().getFluid())) continue;
            return tank.getTank().fill(resource.copy(), action);
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (RelationalTank tank : this.tanks) {
            if (tank.getTankType() == TankType.INPUT && !((Boolean)Config.ALLOW_EXTRACTION_FROM_INPUT_TANKS.get()).booleanValue() && !tank.isAllowAny() || !resource.isFluidEqual(tank.getTank().getFluid())) continue;
            return tank.getTank().drain(resource.copy(), action);
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (RelationalTank tank : this.tanks) {
            if (tank.getTankType() == TankType.INPUT && !((Boolean)Config.ALLOW_EXTRACTION_FROM_INPUT_TANKS.get()).booleanValue() && !tank.isAllowAny() || tank.getTank().getFluidAmount() <= 0) continue;
            return tank.getTank().drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }
}

