/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.sidemanager;

import com.veteam.voluminousenergy.util.SlotType;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class VESlotManager {
    private final int slot;
    private AtomicReference<Direction> side = new AtomicReference();
    private AtomicBoolean enabled = new AtomicBoolean();
    private final String translationKey;
    private final SlotType slotType;
    private final String nbtName;

    public VESlotManager(int slotNum, Direction direction, boolean status, String translationKey, SlotType slotType, String nbtName) {
        this.side.set(direction);
        this.slot = slotNum;
        this.enabled.set(status);
        this.translationKey = translationKey;
        this.slotType = slotType;
        this.nbtName = nbtName;
    }

    public void setStatus(boolean bool) {
        this.enabled.set(bool);
    }

    public void setDirection(Direction direction) {
        this.side.set(direction);
    }

    public void setDirection(int direction) {
        this.side.set(this.directionFromInt(direction));
    }

    public Direction getDirection() {
        return this.side.get();
    }

    public boolean getStatus() {
        return this.enabled.get();
    }

    public int getSlotNum() {
        return this.slot;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getNbtName() {
        return this.nbtName;
    }

    public void write(CompoundTag nbt) {
        nbt.m_128379_(this.nbtName + "_enabled", this.getStatus());
        nbt.m_128405_(this.nbtName + "_direction", this.getDirection().m_122411_());
    }

    public void read(CompoundTag nbt) {
        this.setStatus(nbt.m_128471_(this.nbtName + "_enabled"));
        int sideInt = nbt.m_128451_(this.nbtName + "_direction");
        this.setDirection(this.directionFromInt(sideInt));
    }

    public SlotType getSlotType() {
        return this.slotType;
    }

    public Direction directionFromInt(int sideInt) {
        return switch (sideInt) {
            case 0 -> Direction.DOWN;
            case 1 -> Direction.UP;
            case 2 -> Direction.NORTH;
            case 3 -> Direction.SOUTH;
            case 4 -> Direction.WEST;
            case 5 -> Direction.EAST;
            default -> Direction.UP;
        };
    }
}

