/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.tools.networking.packets;

import com.veteam.voluminousenergy.blocks.containers.VoluminousContainer;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class UuidPacket {
    private UUID uuid;
    private boolean connection;

    public UuidPacket() {
    }

    public UuidPacket(UUID uuid, boolean connection) {
        this.uuid = uuid;
        this.connection = connection;
    }

    public static UuidPacket fromBytes(FriendlyByteBuf buffer) {
        UuidPacket packet = new UuidPacket();
        packet.uuid = buffer.m_130259_();
        packet.connection = buffer.readBoolean();
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.writeBoolean(this.connection);
    }

    public static void handle(UuidPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        AbstractContainerMenu serverContainer = contextSupplier.get().getSender().f_36096_;
        contextSupplier.get().setPacketHandled(true);
    }

    public static void handlePacket(UuidPacket packet, AbstractContainerMenu openContainer) {
        if (openContainer == null) {
            return;
        }
        if (openContainer instanceof VoluminousContainer) {
            VoluminousContainer voluminousContainer = (VoluminousContainer)openContainer;
            VoluminousTileEntity voluminousTileEntity = (VoluminousTileEntity)voluminousContainer.getTileEntity();
            voluminousTileEntity.m_6596_();
        }
    }
}

